/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Google Cloud Messaging credentials
 */
@Generated("software.amazon.awssdk:codegen")
public final class GCMChannelRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<GCMChannelRequest.Builder, GCMChannelRequest> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GCMChannelRequest::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GCMChannelRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiKey;

    private final Boolean enabled;

    private GCMChannelRequest(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.enabled = builder.enabled;
    }

    /**
     * Platform credential API key from Google.
     * 
     * @return Platform credential API key from Google.
     */
    public String apiKey() {
        return apiKey;
    }

    /**
     * If the channel is enabled for sending messages.
     * 
     * @return If the channel is enabled for sending messages.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMChannelRequest)) {
            return false;
        }
        GCMChannelRequest other = (GCMChannelRequest) obj;
        return Objects.equals(apiKey(), other.apiKey()) && Objects.equals(enabled(), other.enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("GCMChannelRequest").add("ApiKey", apiKey()).add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GCMChannelRequest, T> g) {
        return obj -> g.apply((GCMChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GCMChannelRequest> {
        /**
         * Platform credential API key from Google.
         * 
         * @param apiKey
         *        Platform credential API key from Google.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * If the channel is enabled for sending messages.
         * 
         * @param enabled
         *        If the channel is enabled for sending messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String apiKey;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GCMChannelRequest model) {
            apiKey(model.apiKey);
            enabled(model.enabled);
        }

        public final String getApiKey() {
            return apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public GCMChannelRequest build() {
            return new GCMChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
