/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Simple message object.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageBody implements SdkPojo, Serializable, ToCopyableBuilder<MessageBody.Builder, MessageBody> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MessageBody::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MessageBody::requestID)).setter(setter(Builder::requestID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String requestID;

    private MessageBody(BuilderImpl builder) {
        this.message = builder.message;
        this.requestID = builder.requestID;
    }

    /**
     * The error message that's returned from the API.
     * 
     * @return The error message that's returned from the API.
     */
    public String message() {
        return message;
    }

    /**
     * The unique message body ID.
     * 
     * @return The unique message body ID.
     */
    public String requestID() {
        return requestID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(requestID());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageBody)) {
            return false;
        }
        MessageBody other = (MessageBody) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(requestID(), other.requestID());
    }

    @Override
    public String toString() {
        return ToString.builder("MessageBody").add("Message", message()).add("RequestID", requestID()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "RequestID":
            return Optional.ofNullable(clazz.cast(requestID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageBody, T> g) {
        return obj -> g.apply((MessageBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageBody> {
        /**
         * The error message that's returned from the API.
         * 
         * @param message
         *        The error message that's returned from the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * The unique message body ID.
         * 
         * @param requestID
         *        The unique message body ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestID(String requestID);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String requestID;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageBody model) {
            message(model.message);
            requestID(model.requestID);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getRequestID() {
            return requestID;
        }

        @Override
        public final Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public final void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        @Override
        public MessageBody build() {
            return new MessageBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
