/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Segment behavior dimensions
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentBehaviors implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentBehaviors.Builder, SegmentBehaviors> {
    private static final SdkField<RecencyDimension> RECENCY_FIELD = SdkField.<RecencyDimension> builder(MarshallingType.SDK_POJO)
            .getter(getter(SegmentBehaviors::recency)).setter(setter(Builder::recency)).constructor(RecencyDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final RecencyDimension recency;

    private SegmentBehaviors(BuilderImpl builder) {
        this.recency = builder.recency;
    }

    /**
     * The recency of use.
     * 
     * @return The recency of use.
     */
    public RecencyDimension recency() {
        return recency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recency());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentBehaviors)) {
            return false;
        }
        SegmentBehaviors other = (SegmentBehaviors) obj;
        return Objects.equals(recency(), other.recency());
    }

    @Override
    public String toString() {
        return ToString.builder("SegmentBehaviors").add("Recency", recency()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Recency":
            return Optional.ofNullable(clazz.cast(recency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentBehaviors, T> g) {
        return obj -> g.apply((SegmentBehaviors) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentBehaviors> {
        /**
         * The recency of use.
         * 
         * @param recency
         *        The recency of use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recency(RecencyDimension recency);

        /**
         * The recency of use. This is a convenience that creates an instance of the {@link RecencyDimension.Builder}
         * avoiding the need to create one manually via {@link RecencyDimension#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecencyDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #recency(RecencyDimension)}.
         * 
         * @param recency
         *        a consumer that will call methods on {@link RecencyDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recency(RecencyDimension)
         */
        default Builder recency(Consumer<RecencyDimension.Builder> recency) {
            return recency(RecencyDimension.builder().applyMutation(recency).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RecencyDimension recency;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentBehaviors model) {
            recency(model.recency);
        }

        public final RecencyDimension.Builder getRecency() {
            return recency != null ? recency.toBuilder() : null;
        }

        @Override
        public final Builder recency(RecencyDimension recency) {
            this.recency = recency;
            return this;
        }

        public final void setRecency(RecencyDimension.BuilderImpl recency) {
            this.recency = recency != null ? recency.build() : null;
        }

        @Override
        public SegmentBehaviors build() {
            return new SegmentBehaviors(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
