/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Segment import definition.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentImportResource implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentImportResource.Builder, SegmentImportResource> {
    private static final SdkField<Map<String, Integer>> CHANNEL_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .getter(getter(SegmentImportResource::channelCounts))
            .setter(setter(Builder::channelCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentImportResource::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentImportResource::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentImportResource::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentImportResource::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SegmentImportResource::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_COUNTS_FIELD,
            EXTERNAL_ID_FIELD, FORMAT_FIELD, ROLE_ARN_FIELD, S3_URL_FIELD, SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Integer> channelCounts;

    private final String externalId;

    private final String format;

    private final String roleArn;

    private final String s3Url;

    private final Integer size;

    private SegmentImportResource(BuilderImpl builder) {
        this.channelCounts = builder.channelCounts;
        this.externalId = builder.externalId;
        this.format = builder.format;
        this.roleArn = builder.roleArn;
        this.s3Url = builder.s3Url;
        this.size = builder.size;
    }

    /**
     * The number of channel types in the imported segment.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The number of channel types in the imported segment.
     */
    public Map<String, Integer> channelCounts() {
        return channelCounts;
    }

    /**
     * (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy. Used by Amazon
     * Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not recommended for IAM roles
     * assumed by Amazon Pinpoint.
     * 
     * @return (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy. Used
     *         by Amazon Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not
     *         recommended for IAM roles assumed by Amazon Pinpoint.
     */
    public String externalId() {
        return externalId;
    }

    /**
     * The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
     * @see Format
     */
    public Format format() {
        return Format.fromValue(format);
    }

    /**
     * The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
     * @see Format
     */
    public String formatAsString() {
        return format;
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the endpoints in Amazon S3.
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the endpoints in
     *         Amazon S3.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * The URL of the S3 bucket that the segment was imported from.
     * 
     * @return The URL of the S3 bucket that the segment was imported from.
     */
    public String s3Url() {
        return s3Url;
    }

    /**
     * The number of endpoints that were successfully imported to create this segment.
     * 
     * @return The number of endpoints that were successfully imported to create this segment.
     */
    public Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelCounts());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentImportResource)) {
            return false;
        }
        SegmentImportResource other = (SegmentImportResource) obj;
        return Objects.equals(channelCounts(), other.channelCounts()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(s3Url(), other.s3Url()) && Objects.equals(size(), other.size());
    }

    @Override
    public String toString() {
        return ToString.builder("SegmentImportResource").add("ChannelCounts", channelCounts()).add("ExternalId", externalId())
                .add("Format", formatAsString()).add("RoleArn", roleArn()).add("S3Url", s3Url()).add("Size", size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelCounts":
            return Optional.ofNullable(clazz.cast(channelCounts()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "S3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentImportResource, T> g) {
        return obj -> g.apply((SegmentImportResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentImportResource> {
        /**
         * The number of channel types in the imported segment.
         * 
         * @param channelCounts
         *        The number of channel types in the imported segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelCounts(Map<String, Integer> channelCounts);

        /**
         * (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy. Used by
         * Amazon Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not recommended for
         * IAM roles assumed by Amazon Pinpoint.
         * 
         * @param externalId
         *        (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy.
         *        Used by Amazon Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not
         *        recommended for IAM roles assumed by Amazon Pinpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
         * 
         * @param format
         *        The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
         * 
         * @param format
         *        The format of the endpoint files that were imported to create this segment. Valid values: CSV, JSON
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the endpoints in Amazon
         * S3.
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the endpoints in
         *        Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The URL of the S3 bucket that the segment was imported from.
         * 
         * @param s3Url
         *        The URL of the S3 bucket that the segment was imported from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);

        /**
         * The number of endpoints that were successfully imported to create this segment.
         * 
         * @param size
         *        The number of endpoints that were successfully imported to create this segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Integer> channelCounts = DefaultSdkAutoConstructMap.getInstance();

        private String externalId;

        private String format;

        private String roleArn;

        private String s3Url;

        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentImportResource model) {
            channelCounts(model.channelCounts);
            externalId(model.externalId);
            format(model.format);
            roleArn(model.roleArn);
            s3Url(model.s3Url);
            size(model.size);
        }

        public final Map<String, Integer> getChannelCounts() {
            return channelCounts;
        }

        @Override
        public final Builder channelCounts(Map<String, Integer> channelCounts) {
            this.channelCounts = MapOf__integerCopier.copy(channelCounts);
            return this;
        }

        public final void setChannelCounts(Map<String, Integer> channelCounts) {
            this.channelCounts = MapOf__integerCopier.copy(channelCounts);
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3Url() {
            return s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public SegmentImportResource build() {
            return new SegmentImportResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
