/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Send message request.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendUsersMessageRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SendUsersMessageRequest.Builder, SendUsersMessageRequest> {
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(SendUsersMessageRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DirectMessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<DirectMessageConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(SendUsersMessageRequest::messageConfiguration)).setter(setter(Builder::messageConfiguration))
            .constructor(DirectMessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendUsersMessageRequest::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceId").build()).build();

    private static final SdkField<Map<String, EndpointSendConfiguration>> USERS_FIELD = SdkField
            .<Map<String, EndpointSendConfiguration>> builder(MarshallingType.MAP)
            .getter(getter(SendUsersMessageRequest::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EndpointSendConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointSendConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD,
            MESSAGE_CONFIGURATION_FIELD, TRACE_ID_FIELD, USERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> context;

    private final DirectMessageConfiguration messageConfiguration;

    private final String traceId;

    private final Map<String, EndpointSendConfiguration> users;

    private SendUsersMessageRequest(BuilderImpl builder) {
        this.context = builder.context;
        this.messageConfiguration = builder.messageConfiguration;
        this.traceId = builder.traceId;
        this.users = builder.users;
    }

    /**
     * A map of custom attribute-value pairs. Amazon Pinpoint adds these attributes to the data.pinpoint object in the
     * body of the push notification payload. Amazon Pinpoint also provides these attributes in the events that it
     * generates for users-messages deliveries.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of custom attribute-value pairs. Amazon Pinpoint adds these attributes to the data.pinpoint object
     *         in the body of the push notification payload. Amazon Pinpoint also provides these attributes in the
     *         events that it generates for users-messages deliveries.
     */
    public Map<String, String> context() {
        return context;
    }

    /**
     * Message definitions for the default message and any messages that are tailored for specific channels.
     * 
     * @return Message definitions for the default message and any messages that are tailored for specific channels.
     */
    public DirectMessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * A unique ID that you can use to trace a message. This ID is visible to recipients.
     * 
     * @return A unique ID that you can use to trace a message. This ID is visible to recipients.
     */
    public String traceId() {
        return traceId;
    }

    /**
     * A map that associates user IDs with EndpointSendConfiguration objects. Within an EndpointSendConfiguration
     * object, you can tailor the message for a user by specifying message overrides or substitutions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map that associates user IDs with EndpointSendConfiguration objects. Within an
     *         EndpointSendConfiguration object, you can tailor the message for a user by specifying message overrides
     *         or substitutions.
     */
    public Map<String, EndpointSendConfiguration> users() {
        return users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(users());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessageRequest)) {
            return false;
        }
        SendUsersMessageRequest other = (SendUsersMessageRequest) obj;
        return Objects.equals(context(), other.context()) && Objects.equals(messageConfiguration(), other.messageConfiguration())
                && Objects.equals(traceId(), other.traceId()) && Objects.equals(users(), other.users());
    }

    @Override
    public String toString() {
        return ToString.builder("SendUsersMessageRequest").add("Context", context())
                .add("MessageConfiguration", messageConfiguration()).add("TraceId", traceId()).add("Users", users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "TraceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessageRequest, T> g) {
        return obj -> g.apply((SendUsersMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendUsersMessageRequest> {
        /**
         * A map of custom attribute-value pairs. Amazon Pinpoint adds these attributes to the data.pinpoint object in
         * the body of the push notification payload. Amazon Pinpoint also provides these attributes in the events that
         * it generates for users-messages deliveries.
         * 
         * @param context
         *        A map of custom attribute-value pairs. Amazon Pinpoint adds these attributes to the data.pinpoint
         *        object in the body of the push notification payload. Amazon Pinpoint also provides these attributes in
         *        the events that it generates for users-messages deliveries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * Message definitions for the default message and any messages that are tailored for specific channels.
         * 
         * @param messageConfiguration
         *        Message definitions for the default message and any messages that are tailored for specific channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(DirectMessageConfiguration messageConfiguration);

        /**
         * Message definitions for the default message and any messages that are tailored for specific channels. This is
         * a convenience that creates an instance of the {@link DirectMessageConfiguration.Builder} avoiding the need to
         * create one manually via {@link DirectMessageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectMessageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #messageConfiguration(DirectMessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link DirectMessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(DirectMessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<DirectMessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(DirectMessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * A unique ID that you can use to trace a message. This ID is visible to recipients.
         * 
         * @param traceId
         *        A unique ID that you can use to trace a message. This ID is visible to recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * A map that associates user IDs with EndpointSendConfiguration objects. Within an EndpointSendConfiguration
         * object, you can tailor the message for a user by specifying message overrides or substitutions.
         * 
         * @param users
         *        A map that associates user IDs with EndpointSendConfiguration objects. Within an
         *        EndpointSendConfiguration object, you can tailor the message for a user by specifying message
         *        overrides or substitutions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Map<String, EndpointSendConfiguration> users);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private DirectMessageConfiguration messageConfiguration;

        private String traceId;

        private Map<String, EndpointSendConfiguration> users = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessageRequest model) {
            context(model.context);
            messageConfiguration(model.messageConfiguration);
            traceId(model.traceId);
            users(model.users);
        }

        public final Map<String, String> getContext() {
            return context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final DirectMessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(DirectMessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getTraceId() {
            return traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public final Map<String, EndpointSendConfiguration.Builder> getUsers() {
            return users != null ? CollectionUtils.mapValues(users, EndpointSendConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder users(Map<String, EndpointSendConfiguration> users) {
            this.users = MapOfEndpointSendConfigurationCopier.copy(users);
            return this;
        }

        public final void setUsers(Map<String, EndpointSendConfiguration.BuilderImpl> users) {
            this.users = MapOfEndpointSendConfigurationCopier.copyFromBuilder(users);
        }

        @Override
        public SendUsersMessageRequest build() {
            return new SendUsersMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
