/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.pinpoint.model.BadRequestException;
import software.amazon.awssdk.services.pinpoint.model.CreateAppRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateAppResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.ForbiddenException;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.InternalServerErrorException;
import software.amazon.awssdk.services.pinpoint.model.MethodNotAllowedException;
import software.amazon.awssdk.services.pinpoint.model.NotFoundException;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateRequest;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateResponse;
import software.amazon.awssdk.services.pinpoint.model.PinpointException;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventsResponse;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesRequest;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelResponse;

/**
 * Service client for accessing Amazon Pinpoint. This can be created using the static {@link #builder()} method.
 *
 * Amazon Pinpoint
 */
@Generated("software.amazon.awssdk:codegen")
public interface PinpointClient extends SdkClient {
    String SERVICE_NAME = "mobiletargeting";

    /**
     * Create a {@link PinpointClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PinpointClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PinpointClient}.
     */
    static PinpointClientBuilder builder() {
        return new DefaultPinpointClientBuilder();
    }

    /**
     * Creates or updates an app.
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(CreateAppRequest createAppRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates or updates an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppRequest#builder()}
     * </p>
     *
     * @param createAppRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppRequest.Builder} to create a request.
     * @return Result of the CreateApp operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(Consumer<CreateAppRequest.Builder> createAppRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return createApp(CreateAppRequest.builder().applyMutation(createAppRequest).build());
    }

    /**
     * Creates or updates a campaign.
     *
     * @param createCampaignRequest
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates or updates a campaign.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on {@link CreateCampaignRequest.Builder} to create a request.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCampaignResponse createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * Creates an export job.
     *
     * @param createExportJobRequest
     * @return Result of the CreateExportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateExportJobResponse createExportJob(CreateExportJobRequest createExportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an export job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExportJobRequest#builder()}
     * </p>
     *
     * @param createExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateExportJobRequest.Builder} to create a request.
     * @return Result of the CreateExportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateExportJobResponse createExportJob(Consumer<CreateExportJobRequest.Builder> createExportJobRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return createExportJob(CreateExportJobRequest.builder().applyMutation(createExportJobRequest).build());
    }

    /**
     * Creates or updates an import job.
     *
     * @param createImportJobRequest
     * @return Result of the CreateImportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImportJobResponse createImportJob(CreateImportJobRequest createImportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates or updates an import job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateImportJobRequest#builder()}
     * </p>
     *
     * @param createImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateImportJobRequest.Builder} to create a request.
     * @return Result of the CreateImportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImportJobResponse createImportJob(Consumer<CreateImportJobRequest.Builder> createImportJobRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return createImportJob(CreateImportJobRequest.builder().applyMutation(createImportJobRequest).build());
    }

    /**
     * Used to create or update a segment.
     *
     * @param createSegmentRequest
     * @return Result of the CreateSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSegmentResponse createSegment(CreateSegmentRequest createSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to create or update a segment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSegmentRequest#builder()}
     * </p>
     *
     * @param createSegmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateSegmentRequest.Builder} to create a request.
     * @return Result of the CreateSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSegmentResponse createSegment(Consumer<CreateSegmentRequest.Builder> createSegmentRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return createSegment(CreateSegmentRequest.builder().applyMutation(createSegmentRequest).build());
    }

    /**
     * Delete an ADM channel.
     *
     * @param deleteAdmChannelRequest
     * @return Result of the DeleteAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAdmChannelResponse deleteAdmChannel(DeleteAdmChannelRequest deleteAdmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an ADM channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAdmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAdmChannelRequest#builder()}
     * </p>
     *
     * @param deleteAdmChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAdmChannelRequest.Builder} to create a request.
     * @return Result of the DeleteAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAdmChannelResponse deleteAdmChannel(Consumer<DeleteAdmChannelRequest.Builder> deleteAdmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteAdmChannel(DeleteAdmChannelRequest.builder().applyMutation(deleteAdmChannelRequest).build());
    }

    /**
     * Deletes the APNs channel for an app.
     *
     * @param deleteApnsChannelRequest
     * @return Result of the DeleteApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApnsChannelResponse deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the APNs channel for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApnsChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsChannelRequest.Builder} to create a request.
     * @return Result of the DeleteApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApnsChannelResponse deleteApnsChannel(Consumer<DeleteApnsChannelRequest.Builder> deleteApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteApnsChannel(DeleteApnsChannelRequest.builder().applyMutation(deleteApnsChannelRequest).build());
    }

    /**
     * Delete an APNS sandbox channel.
     *
     * @param deleteApnsSandboxChannelRequest
     * @return Result of the DeleteApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApnsSandboxChannelResponse deleteApnsSandboxChannel(
            DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an APNS sandbox channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsSandboxChannelRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApnsSandboxChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsSandboxChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApnsSandboxChannelResponse deleteApnsSandboxChannel(
            Consumer<DeleteApnsSandboxChannelRequest.Builder> deleteApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteApnsSandboxChannel(DeleteApnsSandboxChannelRequest.builder().applyMutation(deleteApnsSandboxChannelRequest)
                .build());
    }

    /**
     * Delete an APNS VoIP channel
     *
     * @param deleteApnsVoipChannelRequest
     * @return Result of the DeleteApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApnsVoipChannelResponse deleteApnsVoipChannel(DeleteApnsVoipChannelRequest deleteApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an APNS VoIP channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsVoipChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteApnsVoipChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsVoipChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsVoipChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApnsVoipChannelResponse deleteApnsVoipChannel(
            Consumer<DeleteApnsVoipChannelRequest.Builder> deleteApnsVoipChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteApnsVoipChannel(DeleteApnsVoipChannelRequest.builder().applyMutation(deleteApnsVoipChannelRequest).build());
    }

    /**
     * Delete an APNS VoIP sandbox channel
     *
     * @param deleteApnsVoipSandboxChannelRequest
     * @return Result of the DeleteApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApnsVoipSandboxChannelResponse deleteApnsVoipSandboxChannel(
            DeleteApnsVoipSandboxChannelRequest deleteApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an APNS VoIP sandbox channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsVoipSandboxChannelRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApnsVoipSandboxChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsVoipSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsVoipSandboxChannelRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApnsVoipSandboxChannelResponse deleteApnsVoipSandboxChannel(
            Consumer<DeleteApnsVoipSandboxChannelRequest.Builder> deleteApnsVoipSandboxChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteApnsVoipSandboxChannel(DeleteApnsVoipSandboxChannelRequest.builder()
                .applyMutation(deleteApnsVoipSandboxChannelRequest).build());
    }

    /**
     * Deletes an app.
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppRequest.Builder} to create a request.
     * @return Result of the DeleteApp operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * Delete a BAIDU GCM channel
     *
     * @param deleteBaiduChannelRequest
     * @return Result of the DeleteBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBaiduChannelResponse deleteBaiduChannel(DeleteBaiduChannelRequest deleteBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a BAIDU GCM channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBaiduChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBaiduChannelRequest#builder()}
     * </p>
     *
     * @param deleteBaiduChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBaiduChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBaiduChannelResponse deleteBaiduChannel(Consumer<DeleteBaiduChannelRequest.Builder> deleteBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteBaiduChannel(DeleteBaiduChannelRequest.builder().applyMutation(deleteBaiduChannelRequest).build());
    }

    /**
     * Deletes a campaign.
     *
     * @param deleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a campaign.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCampaignRequest.Builder} to create a request.
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * Delete an email channel.
     *
     * @param deleteEmailChannelRequest
     * @return Result of the DeleteEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEmailChannelResponse deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an email channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailChannelRequest#builder()}
     * </p>
     *
     * @param deleteEmailChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEmailChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEmailChannelResponse deleteEmailChannel(Consumer<DeleteEmailChannelRequest.Builder> deleteEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteEmailChannel(DeleteEmailChannelRequest.builder().applyMutation(deleteEmailChannelRequest).build());
    }

    /**
     * Deletes an endpoint.
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an endpoint.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointRequest.Builder} to create a request.
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * Deletes the event stream for an app.
     *
     * @param deleteEventStreamRequest
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEventStreamResponse deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the event stream for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventStreamRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventStreamRequest#builder()}
     * </p>
     *
     * @param deleteEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventStreamRequest.Builder} to create a request.
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEventStreamResponse deleteEventStream(Consumer<DeleteEventStreamRequest.Builder> deleteEventStreamRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteEventStream(DeleteEventStreamRequest.builder().applyMutation(deleteEventStreamRequest).build());
    }

    /**
     * Deletes the GCM channel for an app.
     *
     * @param deleteGcmChannelRequest
     * @return Result of the DeleteGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGcmChannelResponse deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the GCM channel for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGcmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteGcmChannelRequest#builder()}
     * </p>
     *
     * @param deleteGcmChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGcmChannelRequest.Builder} to create a request.
     * @return Result of the DeleteGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGcmChannelResponse deleteGcmChannel(Consumer<DeleteGcmChannelRequest.Builder> deleteGcmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteGcmChannel(DeleteGcmChannelRequest.builder().applyMutation(deleteGcmChannelRequest).build());
    }

    /**
     * Deletes a segment.
     *
     * @param deleteSegmentRequest
     * @return Result of the DeleteSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSegmentResponse deleteSegment(DeleteSegmentRequest deleteSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a segment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSegmentRequest#builder()}
     * </p>
     *
     * @param deleteSegmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSegmentRequest.Builder} to create a request.
     * @return Result of the DeleteSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSegmentResponse deleteSegment(Consumer<DeleteSegmentRequest.Builder> deleteSegmentRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteSegment(DeleteSegmentRequest.builder().applyMutation(deleteSegmentRequest).build());
    }

    /**
     * Delete an SMS channel.
     *
     * @param deleteSmsChannelRequest
     * @return Result of the DeleteSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSmsChannelResponse deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an SMS channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSmsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSmsChannelRequest#builder()}
     * </p>
     *
     * @param deleteSmsChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSmsChannelRequest.Builder} to create a request.
     * @return Result of the DeleteSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSmsChannelResponse deleteSmsChannel(Consumer<DeleteSmsChannelRequest.Builder> deleteSmsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteSmsChannel(DeleteSmsChannelRequest.builder().applyMutation(deleteSmsChannelRequest).build());
    }

    /**
     * Deletes endpoints that are associated with a User ID.
     *
     * @param deleteUserEndpointsRequest
     * @return Result of the DeleteUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserEndpointsResponse deleteUserEndpoints(DeleteUserEndpointsRequest deleteUserEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes endpoints that are associated with a User ID.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserEndpointsRequest#builder()}
     * </p>
     *
     * @param deleteUserEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserEndpointsResponse deleteUserEndpoints(
            Consumer<DeleteUserEndpointsRequest.Builder> deleteUserEndpointsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteUserEndpoints(DeleteUserEndpointsRequest.builder().applyMutation(deleteUserEndpointsRequest).build());
    }

    /**
     * Delete an Voice channel
     *
     * @param deleteVoiceChannelRequest
     * @return Result of the DeleteVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVoiceChannelResponse deleteVoiceChannel(DeleteVoiceChannelRequest deleteVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an Voice channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVoiceChannelRequest#builder()}
     * </p>
     *
     * @param deleteVoiceChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVoiceChannelResponse deleteVoiceChannel(Consumer<DeleteVoiceChannelRequest.Builder> deleteVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return deleteVoiceChannel(DeleteVoiceChannelRequest.builder().applyMutation(deleteVoiceChannelRequest).build());
    }

    /**
     * Get an ADM channel.
     *
     * @param getAdmChannelRequest
     * @return Result of the GetAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAdmChannelResponse getAdmChannel(GetAdmChannelRequest getAdmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get an ADM channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdmChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetAdmChannelRequest#builder()}
     * </p>
     *
     * @param getAdmChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetAdmChannelRequest.Builder} to create a request.
     * @return Result of the GetAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAdmChannelResponse getAdmChannel(Consumer<GetAdmChannelRequest.Builder> getAdmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getAdmChannel(GetAdmChannelRequest.builder().applyMutation(getAdmChannelRequest).build());
    }

    /**
     * Returns information about the APNs channel for an app.
     *
     * @param getApnsChannelRequest
     * @return Result of the GetApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApnsChannelResponse getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about the APNs channel for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetApnsChannelRequest#builder()}
     * </p>
     *
     * @param getApnsChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsChannelRequest.Builder} to create a request.
     * @return Result of the GetApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApnsChannelResponse getApnsChannel(Consumer<GetApnsChannelRequest.Builder> getApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getApnsChannel(GetApnsChannelRequest.builder().applyMutation(getApnsChannelRequest).build());
    }

    /**
     * Get an APNS sandbox channel.
     *
     * @param getApnsSandboxChannelRequest
     * @return Result of the GetApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetApnsSandboxChannelResponse getApnsSandboxChannel(GetApnsSandboxChannelRequest getApnsSandboxChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get an APNS sandbox channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsSandboxChannelRequest.Builder} avoiding the
     * need to create one manually via {@link GetApnsSandboxChannelRequest#builder()}
     * </p>
     *
     * @param getApnsSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsSandboxChannelRequest.Builder} to create a
     *        request.
     * @return Result of the GetApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetApnsSandboxChannelResponse getApnsSandboxChannel(
            Consumer<GetApnsSandboxChannelRequest.Builder> getApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getApnsSandboxChannel(GetApnsSandboxChannelRequest.builder().applyMutation(getApnsSandboxChannelRequest).build());
    }

    /**
     * Get an APNS VoIP channel
     *
     * @param getApnsVoipChannelRequest
     * @return Result of the GetApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetApnsVoipChannelResponse getApnsVoipChannel(GetApnsVoipChannelRequest getApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get an APNS VoIP channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsVoipChannelRequest.Builder} avoiding the
     * need to create one manually via {@link GetApnsVoipChannelRequest#builder()}
     * </p>
     *
     * @param getApnsVoipChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsVoipChannelRequest.Builder} to create a
     *        request.
     * @return Result of the GetApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetApnsVoipChannelResponse getApnsVoipChannel(Consumer<GetApnsVoipChannelRequest.Builder> getApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getApnsVoipChannel(GetApnsVoipChannelRequest.builder().applyMutation(getApnsVoipChannelRequest).build());
    }

    /**
     * Get an APNS VoIPSandbox channel
     *
     * @param getApnsVoipSandboxChannelRequest
     * @return Result of the GetApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApnsVoipSandboxChannelResponse getApnsVoipSandboxChannel(
            GetApnsVoipSandboxChannelRequest getApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get an APNS VoIPSandbox channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsVoipSandboxChannelRequest.Builder} avoiding
     * the need to create one manually via {@link GetApnsVoipSandboxChannelRequest#builder()}
     * </p>
     *
     * @param getApnsVoipSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsVoipSandboxChannelRequest.Builder} to create a
     *        request.
     * @return Result of the GetApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApnsVoipSandboxChannelResponse getApnsVoipSandboxChannel(
            Consumer<GetApnsVoipSandboxChannelRequest.Builder> getApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getApnsVoipSandboxChannel(GetApnsVoipSandboxChannelRequest.builder()
                .applyMutation(getApnsVoipSandboxChannelRequest).build());
    }

    /**
     * Returns information about an app.
     *
     * @param getAppRequest
     * @return Result of the GetApp operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppResponse getApp(GetAppRequest getAppRequest) throws BadRequestException, InternalServerErrorException,
            ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppRequest.Builder} avoiding the need to create
     * one manually via {@link GetAppRequest#builder()}
     * </p>
     *
     * @param getAppRequest
     *        A {@link Consumer} that will call methods on {@link GetAppRequest.Builder} to create a request.
     * @return Result of the GetApp operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppResponse getApp(Consumer<GetAppRequest.Builder> getAppRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getApp(GetAppRequest.builder().applyMutation(getAppRequest).build());
    }

    /**
     * Used to request the settings for an app.
     *
     * @param getApplicationSettingsRequest
     * @return Result of the GetApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationSettingsResponse getApplicationSettings(GetApplicationSettingsRequest getApplicationSettingsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to request the settings for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationSettingsRequest#builder()}
     * </p>
     *
     * @param getApplicationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationSettingsResponse getApplicationSettings(
            Consumer<GetApplicationSettingsRequest.Builder> getApplicationSettingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getApplicationSettings(GetApplicationSettingsRequest.builder().applyMutation(getApplicationSettingsRequest)
                .build());
    }

    /**
     * Returns information about your apps.
     *
     * @param getAppsRequest
     * @return Result of the GetApps operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppsResponse getApps(GetAppsRequest getAppsRequest) throws BadRequestException, InternalServerErrorException,
            ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about your apps.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppsRequest.Builder} avoiding the need to create
     * one manually via {@link GetAppsRequest#builder()}
     * </p>
     *
     * @param getAppsRequest
     *        A {@link Consumer} that will call methods on {@link GetAppsRequest.Builder} to create a request.
     * @return Result of the GetApps operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppsResponse getApps(Consumer<GetAppsRequest.Builder> getAppsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getApps(GetAppsRequest.builder().applyMutation(getAppsRequest).build());
    }

    /**
     * Get a BAIDU GCM channel
     *
     * @param getBaiduChannelRequest
     * @return Result of the GetBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBaiduChannelResponse getBaiduChannel(GetBaiduChannelRequest getBaiduChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a BAIDU GCM channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBaiduChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetBaiduChannelRequest#builder()}
     * </p>
     *
     * @param getBaiduChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetBaiduChannelRequest.Builder} to create a request.
     * @return Result of the GetBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBaiduChannelResponse getBaiduChannel(Consumer<GetBaiduChannelRequest.Builder> getBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getBaiduChannel(GetBaiduChannelRequest.builder().applyMutation(getBaiduChannelRequest).build());
    }

    /**
     * Returns information about a campaign.
     *
     * @param getCampaignRequest
     * @return Result of the GetCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCampaignResponse getCampaign(GetCampaignRequest getCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about a campaign.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link GetCampaignRequest#builder()}
     * </p>
     *
     * @param getCampaignRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignRequest.Builder} to create a request.
     * @return Result of the GetCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCampaignResponse getCampaign(Consumer<GetCampaignRequest.Builder> getCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getCampaign(GetCampaignRequest.builder().applyMutation(getCampaignRequest).build());
    }

    /**
     * Returns information about the activity performed by a campaign.
     *
     * @param getCampaignActivitiesRequest
     * @return Result of the GetCampaignActivities operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCampaignActivitiesResponse getCampaignActivities(GetCampaignActivitiesRequest getCampaignActivitiesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about the activity performed by a campaign.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignActivitiesRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignActivitiesRequest#builder()}
     * </p>
     *
     * @param getCampaignActivitiesRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignActivitiesRequest.Builder} to create a
     *        request.
     * @return Result of the GetCampaignActivities operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCampaignActivitiesResponse getCampaignActivities(
            Consumer<GetCampaignActivitiesRequest.Builder> getCampaignActivitiesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getCampaignActivities(GetCampaignActivitiesRequest.builder().applyMutation(getCampaignActivitiesRequest).build());
    }

    /**
     * Returns information about a specific version of a campaign.
     *
     * @param getCampaignVersionRequest
     * @return Result of the GetCampaignVersion operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCampaignVersionResponse getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about a specific version of a campaign.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignVersionRequest#builder()}
     * </p>
     *
     * @param getCampaignVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignVersionRequest.Builder} to create a
     *        request.
     * @return Result of the GetCampaignVersion operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCampaignVersionResponse getCampaignVersion(Consumer<GetCampaignVersionRequest.Builder> getCampaignVersionRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getCampaignVersion(GetCampaignVersionRequest.builder().applyMutation(getCampaignVersionRequest).build());
    }

    /**
     * Returns information about your campaign versions.
     *
     * @param getCampaignVersionsRequest
     * @return Result of the GetCampaignVersions operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCampaignVersionsResponse getCampaignVersions(GetCampaignVersionsRequest getCampaignVersionsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about your campaign versions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignVersionsRequest#builder()}
     * </p>
     *
     * @param getCampaignVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetCampaignVersions operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCampaignVersionsResponse getCampaignVersions(
            Consumer<GetCampaignVersionsRequest.Builder> getCampaignVersionsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getCampaignVersions(GetCampaignVersionsRequest.builder().applyMutation(getCampaignVersionsRequest).build());
    }

    /**
     * Returns information about your campaigns.
     *
     * @param getCampaignsRequest
     * @return Result of the GetCampaigns operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCampaignsResponse getCampaigns(GetCampaignsRequest getCampaignsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about your campaigns.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link GetCampaignsRequest#builder()}
     * </p>
     *
     * @param getCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignsRequest.Builder} to create a request.
     * @return Result of the GetCampaigns operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCampaignsResponse getCampaigns(Consumer<GetCampaignsRequest.Builder> getCampaignsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getCampaigns(GetCampaignsRequest.builder().applyMutation(getCampaignsRequest).build());
    }

    /**
     * Get all channels.
     *
     * @param getChannelsRequest
     * @return Result of the GetChannels operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetChannelsResponse getChannels(GetChannelsRequest getChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get all channels.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelsRequest#builder()}
     * </p>
     *
     * @param getChannelsRequest
     *        A {@link Consumer} that will call methods on {@link GetChannelsRequest.Builder} to create a request.
     * @return Result of the GetChannels operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetChannelsResponse getChannels(Consumer<GetChannelsRequest.Builder> getChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getChannels(GetChannelsRequest.builder().applyMutation(getChannelsRequest).build());
    }

    /**
     * Get an email channel.
     *
     * @param getEmailChannelRequest
     * @return Result of the GetEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEmailChannelResponse getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get an email channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailChannelRequest#builder()}
     * </p>
     *
     * @param getEmailChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetEmailChannelRequest.Builder} to create a request.
     * @return Result of the GetEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEmailChannelResponse getEmailChannel(Consumer<GetEmailChannelRequest.Builder> getEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getEmailChannel(GetEmailChannelRequest.builder().applyMutation(getEmailChannelRequest).build());
    }

    /**
     * Returns information about an endpoint.
     *
     * @param getEndpointRequest
     * @return Result of the GetEndpoint operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEndpointResponse getEndpoint(GetEndpointRequest getEndpointRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about an endpoint.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetEndpointRequest#builder()}
     * </p>
     *
     * @param getEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetEndpointRequest.Builder} to create a request.
     * @return Result of the GetEndpoint operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEndpointResponse getEndpoint(Consumer<GetEndpointRequest.Builder> getEndpointRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getEndpoint(GetEndpointRequest.builder().applyMutation(getEndpointRequest).build());
    }

    /**
     * Returns the event stream for an app.
     *
     * @param getEventStreamRequest
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEventStreamResponse getEventStream(GetEventStreamRequest getEventStreamRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the event stream for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventStreamRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventStreamRequest#builder()}
     * </p>
     *
     * @param getEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link GetEventStreamRequest.Builder} to create a request.
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEventStreamResponse getEventStream(Consumer<GetEventStreamRequest.Builder> getEventStreamRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getEventStream(GetEventStreamRequest.builder().applyMutation(getEventStreamRequest).build());
    }

    /**
     * Returns information about an export job.
     *
     * @param getExportJobRequest
     * @return Result of the GetExportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExportJobResponse getExportJob(GetExportJobRequest getExportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about an export job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportJobRequest#builder()}
     * </p>
     *
     * @param getExportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetExportJobRequest.Builder} to create a request.
     * @return Result of the GetExportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExportJobResponse getExportJob(Consumer<GetExportJobRequest.Builder> getExportJobRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getExportJob(GetExportJobRequest.builder().applyMutation(getExportJobRequest).build());
    }

    /**
     * Returns information about your export jobs.
     *
     * @param getExportJobsRequest
     * @return Result of the GetExportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExportJobsResponse getExportJobs(GetExportJobsRequest getExportJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about your export jobs.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportJobsRequest#builder()}
     * </p>
     *
     * @param getExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetExportJobsRequest.Builder} to create a request.
     * @return Result of the GetExportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExportJobsResponse getExportJobs(Consumer<GetExportJobsRequest.Builder> getExportJobsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getExportJobs(GetExportJobsRequest.builder().applyMutation(getExportJobsRequest).build());
    }

    /**
     * Returns information about the GCM channel for an app.
     *
     * @param getGcmChannelRequest
     * @return Result of the GetGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGcmChannelResponse getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about the GCM channel for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGcmChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetGcmChannelRequest#builder()}
     * </p>
     *
     * @param getGcmChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetGcmChannelRequest.Builder} to create a request.
     * @return Result of the GetGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGcmChannelResponse getGcmChannel(Consumer<GetGcmChannelRequest.Builder> getGcmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getGcmChannel(GetGcmChannelRequest.builder().applyMutation(getGcmChannelRequest).build());
    }

    /**
     * Returns information about an import job.
     *
     * @param getImportJobRequest
     * @return Result of the GetImportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about an import job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobRequest#builder()}
     * </p>
     *
     * @param getImportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetImportJobRequest.Builder} to create a request.
     * @return Result of the GetImportJob operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobResponse getImportJob(Consumer<GetImportJobRequest.Builder> getImportJobRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getImportJob(GetImportJobRequest.builder().applyMutation(getImportJobRequest).build());
    }

    /**
     * Returns information about your import jobs.
     *
     * @param getImportJobsRequest
     * @return Result of the GetImportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobsResponse getImportJobs(GetImportJobsRequest getImportJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about your import jobs.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobsRequest#builder()}
     * </p>
     *
     * @param getImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetImportJobsRequest.Builder} to create a request.
     * @return Result of the GetImportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobsResponse getImportJobs(Consumer<GetImportJobsRequest.Builder> getImportJobsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getImportJobs(GetImportJobsRequest.builder().applyMutation(getImportJobsRequest).build());
    }

    /**
     * Returns information about a segment.
     *
     * @param getSegmentRequest
     * @return Result of the GetSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSegmentResponse getSegment(GetSegmentRequest getSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about a segment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetSegmentRequest#builder()}
     * </p>
     *
     * @param getSegmentRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentRequest.Builder} to create a request.
     * @return Result of the GetSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSegmentResponse getSegment(Consumer<GetSegmentRequest.Builder> getSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getSegment(GetSegmentRequest.builder().applyMutation(getSegmentRequest).build());
    }

    /**
     * Returns a list of export jobs for a specific segment.
     *
     * @param getSegmentExportJobsRequest
     * @return Result of the GetSegmentExportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSegmentExportJobsResponse getSegmentExportJobs(GetSegmentExportJobsRequest getSegmentExportJobsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of export jobs for a specific segment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentExportJobsRequest#builder()}
     * </p>
     *
     * @param getSegmentExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentExportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSegmentExportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSegmentExportJobsResponse getSegmentExportJobs(
            Consumer<GetSegmentExportJobsRequest.Builder> getSegmentExportJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getSegmentExportJobs(GetSegmentExportJobsRequest.builder().applyMutation(getSegmentExportJobsRequest).build());
    }

    /**
     * Returns a list of import jobs for a specific segment.
     *
     * @param getSegmentImportJobsRequest
     * @return Result of the GetSegmentImportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSegmentImportJobsResponse getSegmentImportJobs(GetSegmentImportJobsRequest getSegmentImportJobsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of import jobs for a specific segment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentImportJobsRequest#builder()}
     * </p>
     *
     * @param getSegmentImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentImportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSegmentImportJobs operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSegmentImportJobsResponse getSegmentImportJobs(
            Consumer<GetSegmentImportJobsRequest.Builder> getSegmentImportJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getSegmentImportJobs(GetSegmentImportJobsRequest.builder().applyMutation(getSegmentImportJobsRequest).build());
    }

    /**
     * Returns information about a segment version.
     *
     * @param getSegmentVersionRequest
     * @return Result of the GetSegmentVersion operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSegmentVersionResponse getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about a segment version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSegmentVersionRequest#builder()}
     * </p>
     *
     * @param getSegmentVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentVersionRequest.Builder} to create a request.
     * @return Result of the GetSegmentVersion operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSegmentVersionResponse getSegmentVersion(Consumer<GetSegmentVersionRequest.Builder> getSegmentVersionRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getSegmentVersion(GetSegmentVersionRequest.builder().applyMutation(getSegmentVersionRequest).build());
    }

    /**
     * Returns information about your segment versions.
     *
     * @param getSegmentVersionsRequest
     * @return Result of the GetSegmentVersions operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSegmentVersionsResponse getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about your segment versions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentVersionsRequest#builder()}
     * </p>
     *
     * @param getSegmentVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSegmentVersions operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSegmentVersionsResponse getSegmentVersions(Consumer<GetSegmentVersionsRequest.Builder> getSegmentVersionsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getSegmentVersions(GetSegmentVersionsRequest.builder().applyMutation(getSegmentVersionsRequest).build());
    }

    /**
     * Used to get information about your segments.
     *
     * @param getSegmentsRequest
     * @return Result of the GetSegments operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSegmentsResponse getSegments(GetSegmentsRequest getSegmentsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to get information about your segments.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSegmentsRequest#builder()}
     * </p>
     *
     * @param getSegmentsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentsRequest.Builder} to create a request.
     * @return Result of the GetSegments operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSegmentsResponse getSegments(Consumer<GetSegmentsRequest.Builder> getSegmentsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getSegments(GetSegmentsRequest.builder().applyMutation(getSegmentsRequest).build());
    }

    /**
     * Get an SMS channel.
     *
     * @param getSmsChannelRequest
     * @return Result of the GetSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSmsChannelResponse getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get an SMS channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSmsChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetSmsChannelRequest#builder()}
     * </p>
     *
     * @param getSmsChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetSmsChannelRequest.Builder} to create a request.
     * @return Result of the GetSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSmsChannelResponse getSmsChannel(Consumer<GetSmsChannelRequest.Builder> getSmsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getSmsChannel(GetSmsChannelRequest.builder().applyMutation(getSmsChannelRequest).build());
    }

    /**
     * Returns information about the endpoints that are associated with a User ID.
     *
     * @param getUserEndpointsRequest
     * @return Result of the GetUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserEndpointsResponse getUserEndpoints(GetUserEndpointsRequest getUserEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about the endpoints that are associated with a User ID.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link GetUserEndpointsRequest#builder()}
     * </p>
     *
     * @param getUserEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link GetUserEndpointsRequest.Builder} to create a request.
     * @return Result of the GetUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserEndpointsResponse getUserEndpoints(Consumer<GetUserEndpointsRequest.Builder> getUserEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getUserEndpoints(GetUserEndpointsRequest.builder().applyMutation(getUserEndpointsRequest).build());
    }

    /**
     * Get a Voice Channel
     *
     * @param getVoiceChannelRequest
     * @return Result of the GetVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVoiceChannelResponse getVoiceChannel(GetVoiceChannelRequest getVoiceChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a Voice Channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetVoiceChannelRequest#builder()}
     * </p>
     *
     * @param getVoiceChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceChannelRequest.Builder} to create a request.
     * @return Result of the GetVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVoiceChannelResponse getVoiceChannel(Consumer<GetVoiceChannelRequest.Builder> getVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return getVoiceChannel(GetVoiceChannelRequest.builder().applyMutation(getVoiceChannelRequest).build());
    }

    /**
     * Returns information about the specified phone number.
     *
     * @param phoneNumberValidateRequest
     * @return Result of the PhoneNumberValidate operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PhoneNumberValidate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    default PhoneNumberValidateResponse phoneNumberValidate(PhoneNumberValidateRequest phoneNumberValidateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about the specified phone number.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PhoneNumberValidateRequest.Builder} avoiding the
     * need to create one manually via {@link PhoneNumberValidateRequest#builder()}
     * </p>
     *
     * @param phoneNumberValidateRequest
     *        A {@link Consumer} that will call methods on {@link PhoneNumberValidateRequest.Builder} to create a
     *        request.
     * @return Result of the PhoneNumberValidate operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PhoneNumberValidate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    default PhoneNumberValidateResponse phoneNumberValidate(
            Consumer<PhoneNumberValidateRequest.Builder> phoneNumberValidateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return phoneNumberValidate(PhoneNumberValidateRequest.builder().applyMutation(phoneNumberValidateRequest).build());
    }

    /**
     * Use to create or update the event stream for an app.
     *
     * @param putEventStreamRequest
     * @return Result of the PutEventStream operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventStreamResponse putEventStream(PutEventStreamRequest putEventStreamRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Use to create or update the event stream for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventStreamRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventStreamRequest#builder()}
     * </p>
     *
     * @param putEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link PutEventStreamRequest.Builder} to create a request.
     * @return Result of the PutEventStream operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventStreamResponse putEventStream(Consumer<PutEventStreamRequest.Builder> putEventStreamRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return putEventStream(PutEventStreamRequest.builder().applyMutation(putEventStreamRequest).build());
    }

    /**
     * Use to record events for endpoints. This method creates events and creates or updates the endpoints that those
     * events are associated with.
     *
     * @param putEventsRequest
     * @return Result of the PutEvents operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Use to record events for endpoints. This method creates events and creates or updates the endpoints that those
     * events are associated with.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventsRequest#builder()}
     * </p>
     *
     * @param putEventsRequest
     *        A {@link Consumer} that will call methods on {@link PutEventsRequest.Builder} to create a request.
     * @return Result of the PutEvents operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventsResponse putEvents(Consumer<PutEventsRequest.Builder> putEventsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return putEvents(PutEventsRequest.builder().applyMutation(putEventsRequest).build());
    }

    /**
     * Used to remove the attributes for an app
     *
     * @param removeAttributesRequest
     * @return Result of the RemoveAttributes operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.RemoveAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default RemoveAttributesResponse removeAttributes(RemoveAttributesRequest removeAttributesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to remove the attributes for an app<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveAttributesRequest#builder()}
     * </p>
     *
     * @param removeAttributesRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAttributesRequest.Builder} to create a request.
     * @return Result of the RemoveAttributes operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.RemoveAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default RemoveAttributesResponse removeAttributes(Consumer<RemoveAttributesRequest.Builder> removeAttributesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return removeAttributes(RemoveAttributesRequest.builder().applyMutation(removeAttributesRequest).build());
    }

    /**
     * Used to send a direct message.
     *
     * @param sendMessagesRequest
     * @return Result of the SendMessages operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default SendMessagesResponse sendMessages(SendMessagesRequest sendMessagesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to send a direct message.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendMessagesRequest.Builder} avoiding the need to
     * create one manually via {@link SendMessagesRequest#builder()}
     * </p>
     *
     * @param sendMessagesRequest
     *        A {@link Consumer} that will call methods on {@link SendMessagesRequest.Builder} to create a request.
     * @return Result of the SendMessages operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default SendMessagesResponse sendMessages(Consumer<SendMessagesRequest.Builder> sendMessagesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return sendMessages(SendMessagesRequest.builder().applyMutation(sendMessagesRequest).build());
    }

    /**
     * Used to send a message to a list of users.
     *
     * @param sendUsersMessagesRequest
     * @return Result of the SendUsersMessages operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendUsersMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default SendUsersMessagesResponse sendUsersMessages(SendUsersMessagesRequest sendUsersMessagesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to send a message to a list of users.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendUsersMessagesRequest.Builder} avoiding the need
     * to create one manually via {@link SendUsersMessagesRequest#builder()}
     * </p>
     *
     * @param sendUsersMessagesRequest
     *        A {@link Consumer} that will call methods on {@link SendUsersMessagesRequest.Builder} to create a request.
     * @return Result of the SendUsersMessages operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendUsersMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default SendUsersMessagesResponse sendUsersMessages(Consumer<SendUsersMessagesRequest.Builder> sendUsersMessagesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return sendUsersMessages(SendUsersMessagesRequest.builder().applyMutation(sendUsersMessagesRequest).build());
    }

    /**
     * Update an ADM channel.
     *
     * @param updateAdmChannelRequest
     * @return Result of the UpdateAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAdmChannelResponse updateAdmChannel(UpdateAdmChannelRequest updateAdmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an ADM channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAdmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAdmChannelRequest#builder()}
     * </p>
     *
     * @param updateAdmChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAdmChannelRequest.Builder} to create a request.
     * @return Result of the UpdateAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAdmChannelResponse updateAdmChannel(Consumer<UpdateAdmChannelRequest.Builder> updateAdmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateAdmChannel(UpdateAdmChannelRequest.builder().applyMutation(updateAdmChannelRequest).build());
    }

    /**
     * Use to update the APNs channel for an app.
     *
     * @param updateApnsChannelRequest
     * @return Result of the UpdateApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApnsChannelResponse updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Use to update the APNs channel for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApnsChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsChannelRequest.Builder} to create a request.
     * @return Result of the UpdateApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApnsChannelResponse updateApnsChannel(Consumer<UpdateApnsChannelRequest.Builder> updateApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateApnsChannel(UpdateApnsChannelRequest.builder().applyMutation(updateApnsChannelRequest).build());
    }

    /**
     * Update an APNS sandbox channel.
     *
     * @param updateApnsSandboxChannelRequest
     * @return Result of the UpdateApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApnsSandboxChannelResponse updateApnsSandboxChannel(
            UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an APNS sandbox channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsSandboxChannelRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateApnsSandboxChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsSandboxChannelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApnsSandboxChannelResponse updateApnsSandboxChannel(
            Consumer<UpdateApnsSandboxChannelRequest.Builder> updateApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateApnsSandboxChannel(UpdateApnsSandboxChannelRequest.builder().applyMutation(updateApnsSandboxChannelRequest)
                .build());
    }

    /**
     * Update an APNS VoIP channel
     *
     * @param updateApnsVoipChannelRequest
     * @return Result of the UpdateApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApnsVoipChannelResponse updateApnsVoipChannel(UpdateApnsVoipChannelRequest updateApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an APNS VoIP channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsVoipChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateApnsVoipChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsVoipChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsVoipChannelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApnsVoipChannelResponse updateApnsVoipChannel(
            Consumer<UpdateApnsVoipChannelRequest.Builder> updateApnsVoipChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateApnsVoipChannel(UpdateApnsVoipChannelRequest.builder().applyMutation(updateApnsVoipChannelRequest).build());
    }

    /**
     * Update an APNS VoIP sandbox channel
     *
     * @param updateApnsVoipSandboxChannelRequest
     * @return Result of the UpdateApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApnsVoipSandboxChannelResponse updateApnsVoipSandboxChannel(
            UpdateApnsVoipSandboxChannelRequest updateApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an APNS VoIP sandbox channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsVoipSandboxChannelRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApnsVoipSandboxChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsVoipSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsVoipSandboxChannelRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApnsVoipSandboxChannelResponse updateApnsVoipSandboxChannel(
            Consumer<UpdateApnsVoipSandboxChannelRequest.Builder> updateApnsVoipSandboxChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateApnsVoipSandboxChannel(UpdateApnsVoipSandboxChannelRequest.builder()
                .applyMutation(updateApnsVoipSandboxChannelRequest).build());
    }

    /**
     * Used to update the settings for an app.
     *
     * @param updateApplicationSettingsRequest
     * @return Result of the UpdateApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationSettingsResponse updateApplicationSettings(
            UpdateApplicationSettingsRequest updateApplicationSettingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to update the settings for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateApplicationSettingsRequest#builder()}
     * </p>
     *
     * @param updateApplicationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationSettingsResponse updateApplicationSettings(
            Consumer<UpdateApplicationSettingsRequest.Builder> updateApplicationSettingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateApplicationSettings(UpdateApplicationSettingsRequest.builder()
                .applyMutation(updateApplicationSettingsRequest).build());
    }

    /**
     * Update a BAIDU GCM channel
     *
     * @param updateBaiduChannelRequest
     * @return Result of the UpdateBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBaiduChannelResponse updateBaiduChannel(UpdateBaiduChannelRequest updateBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a BAIDU GCM channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBaiduChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBaiduChannelRequest#builder()}
     * </p>
     *
     * @param updateBaiduChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBaiduChannelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBaiduChannelResponse updateBaiduChannel(Consumer<UpdateBaiduChannelRequest.Builder> updateBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateBaiduChannel(UpdateBaiduChannelRequest.builder().applyMutation(updateBaiduChannelRequest).build());
    }

    /**
     * Use to update a campaign.
     *
     * @param updateCampaignRequest
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Use to update a campaign.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCampaignRequest#builder()}
     * </p>
     *
     * @param updateCampaignRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCampaignRequest.Builder} to create a request.
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCampaignResponse updateCampaign(Consumer<UpdateCampaignRequest.Builder> updateCampaignRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateCampaign(UpdateCampaignRequest.builder().applyMutation(updateCampaignRequest).build());
    }

    /**
     * Update an email channel.
     *
     * @param updateEmailChannelRequest
     * @return Result of the UpdateEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEmailChannelResponse updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an email channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmailChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEmailChannelRequest#builder()}
     * </p>
     *
     * @param updateEmailChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEmailChannelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEmailChannelResponse updateEmailChannel(Consumer<UpdateEmailChannelRequest.Builder> updateEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateEmailChannel(UpdateEmailChannelRequest.builder().applyMutation(updateEmailChannelRequest).build());
    }

    /**
     * Creates or updates an endpoint.
     *
     * @param updateEndpointRequest
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates or updates an endpoint.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEndpointRequest#builder()}
     * </p>
     *
     * @param updateEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointRequest.Builder} to create a request.
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(Consumer<UpdateEndpointRequest.Builder> updateEndpointRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateEndpoint(UpdateEndpointRequest.builder().applyMutation(updateEndpointRequest).build());
    }

    /**
     * Use to update a batch of endpoints.
     *
     * @param updateEndpointsBatchRequest
     * @return Result of the UpdateEndpointsBatch operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpointsBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEndpointsBatchResponse updateEndpointsBatch(UpdateEndpointsBatchRequest updateEndpointsBatchRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Use to update a batch of endpoints.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointsBatchRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointsBatchRequest#builder()}
     * </p>
     *
     * @param updateEndpointsBatchRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointsBatchRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEndpointsBatch operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpointsBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEndpointsBatchResponse updateEndpointsBatch(
            Consumer<UpdateEndpointsBatchRequest.Builder> updateEndpointsBatchRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateEndpointsBatch(UpdateEndpointsBatchRequest.builder().applyMutation(updateEndpointsBatchRequest).build());
    }

    /**
     * Use to update the GCM channel for an app.
     *
     * @param updateGcmChannelRequest
     * @return Result of the UpdateGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGcmChannelResponse updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Use to update the GCM channel for an app.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGcmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateGcmChannelRequest#builder()}
     * </p>
     *
     * @param updateGcmChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGcmChannelRequest.Builder} to create a request.
     * @return Result of the UpdateGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGcmChannelResponse updateGcmChannel(Consumer<UpdateGcmChannelRequest.Builder> updateGcmChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateGcmChannel(UpdateGcmChannelRequest.builder().applyMutation(updateGcmChannelRequest).build());
    }

    /**
     * Used to update a segment.
     *
     * @param updateSegmentRequest
     * @return Result of the UpdateSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSegmentResponse updateSegment(UpdateSegmentRequest updateSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Used to update a segment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSegmentRequest#builder()}
     * </p>
     *
     * @param updateSegmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSegmentRequest.Builder} to create a request.
     * @return Result of the UpdateSegment operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSegmentResponse updateSegment(Consumer<UpdateSegmentRequest.Builder> updateSegmentRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateSegment(UpdateSegmentRequest.builder().applyMutation(updateSegmentRequest).build());
    }

    /**
     * Update an SMS channel.
     *
     * @param updateSmsChannelRequest
     * @return Result of the UpdateSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSmsChannelResponse updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an SMS channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSmsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSmsChannelRequest#builder()}
     * </p>
     *
     * @param updateSmsChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSmsChannelRequest.Builder} to create a request.
     * @return Result of the UpdateSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSmsChannelResponse updateSmsChannel(Consumer<UpdateSmsChannelRequest.Builder> updateSmsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateSmsChannel(UpdateSmsChannelRequest.builder().applyMutation(updateSmsChannelRequest).build());
    }

    /**
     * Update an Voice channel
     *
     * @param updateVoiceChannelRequest
     * @return Result of the UpdateVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVoiceChannelResponse updateVoiceChannel(UpdateVoiceChannelRequest updateVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an Voice channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVoiceChannelRequest#builder()}
     * </p>
     *
     * @param updateVoiceChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceChannelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVoiceChannelResponse updateVoiceChannel(Consumer<UpdateVoiceChannelRequest.Builder> updateVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        return updateVoiceChannel(UpdateVoiceChannelRequest.builder().applyMutation(updateVoiceChannelRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("pinpoint");
    }
}
