/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Activity definition
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityResponse.Builder, ActivityResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::campaignId)).setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final SdkField<String> SCHEDULED_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::scheduledStart)).setter(setter(Builder::scheduledStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStart").build()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Integer> SUCCESSFUL_ENDPOINT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ActivityResponse::successfulEndpointCount)).setter(setter(Builder::successfulEndpointCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulEndpointCount").build())
            .build();

    private static final SdkField<Integer> TIMEZONES_COMPLETED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ActivityResponse::timezonesCompletedCount)).setter(setter(Builder::timezonesCompletedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezonesCompletedCount").build())
            .build();

    private static final SdkField<Integer> TIMEZONES_TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ActivityResponse::timezonesTotalCount)).setter(setter(Builder::timezonesTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezonesTotalCount").build())
            .build();

    private static final SdkField<Integer> TOTAL_ENDPOINT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ActivityResponse::totalEndpointCount)).setter(setter(Builder::totalEndpointCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalEndpointCount").build())
            .build();

    private static final SdkField<String> TREATMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityResponse::treatmentId)).setter(setter(Builder::treatmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CAMPAIGN_ID_FIELD, END_FIELD, ID_FIELD, RESULT_FIELD, SCHEDULED_START_FIELD, START_FIELD, STATE_FIELD,
            SUCCESSFUL_ENDPOINT_COUNT_FIELD, TIMEZONES_COMPLETED_COUNT_FIELD, TIMEZONES_TOTAL_COUNT_FIELD,
            TOTAL_ENDPOINT_COUNT_FIELD, TREATMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String campaignId;

    private final String end;

    private final String id;

    private final String result;

    private final String scheduledStart;

    private final String start;

    private final String state;

    private final Integer successfulEndpointCount;

    private final Integer timezonesCompletedCount;

    private final Integer timezonesTotalCount;

    private final Integer totalEndpointCount;

    private final String treatmentId;

    private ActivityResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.end = builder.end;
        this.id = builder.id;
        this.result = builder.result;
        this.scheduledStart = builder.scheduledStart;
        this.start = builder.start;
        this.state = builder.state;
        this.successfulEndpointCount = builder.successfulEndpointCount;
        this.timezonesCompletedCount = builder.timezonesCompletedCount;
        this.timezonesTotalCount = builder.timezonesTotalCount;
        this.totalEndpointCount = builder.totalEndpointCount;
        this.treatmentId = builder.treatmentId;
    }

    /**
     * The ID of the application to which the campaign applies.
     * 
     * @return The ID of the application to which the campaign applies.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The ID of the campaign to which the activity applies.
     * 
     * @return The ID of the campaign to which the activity applies.
     */
    public String campaignId() {
        return campaignId;
    }

    /**
     * The actual time the activity was marked CANCELLED or COMPLETED. Provided in ISO 8601 format.
     * 
     * @return The actual time the activity was marked CANCELLED or COMPLETED. Provided in ISO 8601 format.
     */
    public String end() {
        return end;
    }

    /**
     * The unique activity ID.
     * 
     * @return The unique activity ID.
     */
    public String id() {
        return id;
    }

    /**
     * Indicates whether the activity succeeded.
     *
     * Valid values: SUCCESS, FAIL
     * 
     * @return Indicates whether the activity succeeded.
     *
     *         Valid values: SUCCESS, FAIL
     */
    public String result() {
        return result;
    }

    /**
     * The scheduled start time for the activity in ISO 8601 format.
     * 
     * @return The scheduled start time for the activity in ISO 8601 format.
     */
    public String scheduledStart() {
        return scheduledStart;
    }

    /**
     * The actual start time of the activity in ISO 8601 format.
     * 
     * @return The actual start time of the activity in ISO 8601 format.
     */
    public String start() {
        return start;
    }

    /**
     * The state of the activity.
     *
     * Valid values: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, COMPLETED
     * 
     * @return The state of the activity.
     *
     *         Valid values: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, COMPLETED
     */
    public String state() {
        return state;
    }

    /**
     * The total number of endpoints to which the campaign successfully delivered messages.
     * 
     * @return The total number of endpoints to which the campaign successfully delivered messages.
     */
    public Integer successfulEndpointCount() {
        return successfulEndpointCount;
    }

    /**
     * The total number of timezones completed.
     * 
     * @return The total number of timezones completed.
     */
    public Integer timezonesCompletedCount() {
        return timezonesCompletedCount;
    }

    /**
     * The total number of unique timezones present in the segment.
     * 
     * @return The total number of unique timezones present in the segment.
     */
    public Integer timezonesTotalCount() {
        return timezonesTotalCount;
    }

    /**
     * The total number of endpoints to which the campaign attempts to deliver messages.
     * 
     * @return The total number of endpoints to which the campaign attempts to deliver messages.
     */
    public Integer totalEndpointCount() {
        return totalEndpointCount;
    }

    /**
     * The ID of a variation of the campaign used for A/B testing.
     * 
     * @return The ID of a variation of the campaign used for A/B testing.
     */
    public String treatmentId() {
        return treatmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStart());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(successfulEndpointCount());
        hashCode = 31 * hashCode + Objects.hashCode(timezonesCompletedCount());
        hashCode = 31 * hashCode + Objects.hashCode(timezonesTotalCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalEndpointCount());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityResponse)) {
            return false;
        }
        ActivityResponse other = (ActivityResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(campaignId(), other.campaignId())
                && Objects.equals(end(), other.end()) && Objects.equals(id(), other.id())
                && Objects.equals(result(), other.result()) && Objects.equals(scheduledStart(), other.scheduledStart())
                && Objects.equals(start(), other.start()) && Objects.equals(state(), other.state())
                && Objects.equals(successfulEndpointCount(), other.successfulEndpointCount())
                && Objects.equals(timezonesCompletedCount(), other.timezonesCompletedCount())
                && Objects.equals(timezonesTotalCount(), other.timezonesTotalCount())
                && Objects.equals(totalEndpointCount(), other.totalEndpointCount())
                && Objects.equals(treatmentId(), other.treatmentId());
    }

    @Override
    public String toString() {
        return ToString.builder("ActivityResponse").add("ApplicationId", applicationId()).add("CampaignId", campaignId())
                .add("End", end()).add("Id", id()).add("Result", result()).add("ScheduledStart", scheduledStart())
                .add("Start", start()).add("State", state()).add("SuccessfulEndpointCount", successfulEndpointCount())
                .add("TimezonesCompletedCount", timezonesCompletedCount()).add("TimezonesTotalCount", timezonesTotalCount())
                .add("TotalEndpointCount", totalEndpointCount()).add("TreatmentId", treatmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "ScheduledStart":
            return Optional.ofNullable(clazz.cast(scheduledStart()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "SuccessfulEndpointCount":
            return Optional.ofNullable(clazz.cast(successfulEndpointCount()));
        case "TimezonesCompletedCount":
            return Optional.ofNullable(clazz.cast(timezonesCompletedCount()));
        case "TimezonesTotalCount":
            return Optional.ofNullable(clazz.cast(timezonesTotalCount()));
        case "TotalEndpointCount":
            return Optional.ofNullable(clazz.cast(totalEndpointCount()));
        case "TreatmentId":
            return Optional.ofNullable(clazz.cast(treatmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityResponse, T> g) {
        return obj -> g.apply((ActivityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityResponse> {
        /**
         * The ID of the application to which the campaign applies.
         * 
         * @param applicationId
         *        The ID of the application to which the campaign applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The ID of the campaign to which the activity applies.
         * 
         * @param campaignId
         *        The ID of the campaign to which the activity applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * The actual time the activity was marked CANCELLED or COMPLETED. Provided in ISO 8601 format.
         * 
         * @param end
         *        The actual time the activity was marked CANCELLED or COMPLETED. Provided in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * The unique activity ID.
         * 
         * @param id
         *        The unique activity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Indicates whether the activity succeeded.
         *
         * Valid values: SUCCESS, FAIL
         * 
         * @param result
         *        Indicates whether the activity succeeded.
         *
         *        Valid values: SUCCESS, FAIL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * The scheduled start time for the activity in ISO 8601 format.
         * 
         * @param scheduledStart
         *        The scheduled start time for the activity in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStart(String scheduledStart);

        /**
         * The actual start time of the activity in ISO 8601 format.
         * 
         * @param start
         *        The actual start time of the activity in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * The state of the activity.
         *
         * Valid values: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, COMPLETED
         * 
         * @param state
         *        The state of the activity.
         *
         *        Valid values: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, COMPLETED
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * The total number of endpoints to which the campaign successfully delivered messages.
         * 
         * @param successfulEndpointCount
         *        The total number of endpoints to which the campaign successfully delivered messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulEndpointCount(Integer successfulEndpointCount);

        /**
         * The total number of timezones completed.
         * 
         * @param timezonesCompletedCount
         *        The total number of timezones completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezonesCompletedCount(Integer timezonesCompletedCount);

        /**
         * The total number of unique timezones present in the segment.
         * 
         * @param timezonesTotalCount
         *        The total number of unique timezones present in the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezonesTotalCount(Integer timezonesTotalCount);

        /**
         * The total number of endpoints to which the campaign attempts to deliver messages.
         * 
         * @param totalEndpointCount
         *        The total number of endpoints to which the campaign attempts to deliver messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalEndpointCount(Integer totalEndpointCount);

        /**
         * The ID of a variation of the campaign used for A/B testing.
         * 
         * @param treatmentId
         *        The ID of a variation of the campaign used for A/B testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentId(String treatmentId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String campaignId;

        private String end;

        private String id;

        private String result;

        private String scheduledStart;

        private String start;

        private String state;

        private Integer successfulEndpointCount;

        private Integer timezonesCompletedCount;

        private Integer timezonesTotalCount;

        private Integer totalEndpointCount;

        private String treatmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityResponse model) {
            applicationId(model.applicationId);
            campaignId(model.campaignId);
            end(model.end);
            id(model.id);
            result(model.result);
            scheduledStart(model.scheduledStart);
            start(model.start);
            state(model.state);
            successfulEndpointCount(model.successfulEndpointCount);
            timezonesCompletedCount(model.timezonesCompletedCount);
            timezonesTotalCount(model.timezonesTotalCount);
            totalEndpointCount(model.totalEndpointCount);
            treatmentId(model.treatmentId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCampaignId() {
            return campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        public final String getEnd() {
            return end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getScheduledStart() {
            return scheduledStart;
        }

        @Override
        public final Builder scheduledStart(String scheduledStart) {
            this.scheduledStart = scheduledStart;
            return this;
        }

        public final void setScheduledStart(String scheduledStart) {
            this.scheduledStart = scheduledStart;
        }

        public final String getStart() {
            return start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getSuccessfulEndpointCount() {
            return successfulEndpointCount;
        }

        @Override
        public final Builder successfulEndpointCount(Integer successfulEndpointCount) {
            this.successfulEndpointCount = successfulEndpointCount;
            return this;
        }

        public final void setSuccessfulEndpointCount(Integer successfulEndpointCount) {
            this.successfulEndpointCount = successfulEndpointCount;
        }

        public final Integer getTimezonesCompletedCount() {
            return timezonesCompletedCount;
        }

        @Override
        public final Builder timezonesCompletedCount(Integer timezonesCompletedCount) {
            this.timezonesCompletedCount = timezonesCompletedCount;
            return this;
        }

        public final void setTimezonesCompletedCount(Integer timezonesCompletedCount) {
            this.timezonesCompletedCount = timezonesCompletedCount;
        }

        public final Integer getTimezonesTotalCount() {
            return timezonesTotalCount;
        }

        @Override
        public final Builder timezonesTotalCount(Integer timezonesTotalCount) {
            this.timezonesTotalCount = timezonesTotalCount;
            return this;
        }

        public final void setTimezonesTotalCount(Integer timezonesTotalCount) {
            this.timezonesTotalCount = timezonesTotalCount;
        }

        public final Integer getTotalEndpointCount() {
            return totalEndpointCount;
        }

        @Override
        public final Builder totalEndpointCount(Integer totalEndpointCount) {
            this.totalEndpointCount = totalEndpointCount;
            return this;
        }

        public final void setTotalEndpointCount(Integer totalEndpointCount) {
            this.totalEndpointCount = totalEndpointCount;
        }

        public final String getTreatmentId() {
            return treatmentId;
        }

        @Override
        public final Builder treatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
            return this;
        }

        public final void setTreatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
        }

        @Override
        public ActivityResponse build() {
            return new ActivityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
