/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The email message configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignEmailMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignEmailMessage.Builder, CampaignEmailMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignEmailMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignEmailMessage::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<String> HTML_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignEmailMessage::htmlBody)).setter(setter(Builder::htmlBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlBody").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignEmailMessage::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            FROM_ADDRESS_FIELD, HTML_BODY_FIELD, TITLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String fromAddress;

    private final String htmlBody;

    private final String title;

    private CampaignEmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.fromAddress = builder.fromAddress;
        this.htmlBody = builder.htmlBody;
        this.title = builder.title;
    }

    /**
     * The email text body.
     * 
     * @return The email text body.
     */
    public String body() {
        return body;
    }

    /**
     * The email address used to send the email from. Defaults to use FromAddress specified in the Email Channel.
     * 
     * @return The email address used to send the email from. Defaults to use FromAddress specified in the Email
     *         Channel.
     */
    public String fromAddress() {
        return fromAddress;
    }

    /**
     * The email html body.
     * 
     * @return The email html body.
     */
    public String htmlBody() {
        return htmlBody;
    }

    /**
     * The email title (Or subject).
     * 
     * @return The email title (Or subject).
     */
    public String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(htmlBody());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignEmailMessage)) {
            return false;
        }
        CampaignEmailMessage other = (CampaignEmailMessage) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(fromAddress(), other.fromAddress())
                && Objects.equals(htmlBody(), other.htmlBody()) && Objects.equals(title(), other.title());
    }

    @Override
    public String toString() {
        return ToString.builder("CampaignEmailMessage").add("Body", body()).add("FromAddress", fromAddress())
                .add("HtmlBody", htmlBody()).add("Title", title()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "HtmlBody":
            return Optional.ofNullable(clazz.cast(htmlBody()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignEmailMessage, T> g) {
        return obj -> g.apply((CampaignEmailMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignEmailMessage> {
        /**
         * The email text body.
         * 
         * @param body
         *        The email text body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * The email address used to send the email from. Defaults to use FromAddress specified in the Email Channel.
         * 
         * @param fromAddress
         *        The email address used to send the email from. Defaults to use FromAddress specified in the Email
         *        Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * The email html body.
         * 
         * @param htmlBody
         *        The email html body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlBody(String htmlBody);

        /**
         * The email title (Or subject).
         * 
         * @param title
         *        The email title (Or subject).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String fromAddress;

        private String htmlBody;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignEmailMessage model) {
            body(model.body);
            fromAddress(model.fromAddress);
            htmlBody(model.htmlBody);
            title(model.title);
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final String getHtmlBody() {
            return htmlBody;
        }

        @Override
        public final Builder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public final void setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public CampaignEmailMessage build() {
            return new CampaignEmailMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
