/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAdmChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteAdmChannelResponse.Builder, DeleteAdmChannelResponse> {
    private static final SdkField<ADMChannelResponse> ADM_CHANNEL_RESPONSE_FIELD = SdkField
            .<ADMChannelResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteAdmChannelResponse::admChannelResponse))
            .setter(setter(Builder::admChannelResponse))
            .constructor(ADMChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADMChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_CHANNEL_RESPONSE_FIELD));

    private final ADMChannelResponse admChannelResponse;

    private DeleteAdmChannelResponse(BuilderImpl builder) {
        super(builder);
        this.admChannelResponse = builder.admChannelResponse;
    }

    /**
     * Returns the value of the ADMChannelResponse property for this object.
     * 
     * @return The value of the ADMChannelResponse property for this object.
     */
    public ADMChannelResponse admChannelResponse() {
        return admChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(admChannelResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAdmChannelResponse)) {
            return false;
        }
        DeleteAdmChannelResponse other = (DeleteAdmChannelResponse) obj;
        return Objects.equals(admChannelResponse(), other.admChannelResponse());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteAdmChannelResponse").add("ADMChannelResponse", admChannelResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ADMChannelResponse":
            return Optional.ofNullable(clazz.cast(admChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAdmChannelResponse, T> g) {
        return obj -> g.apply((DeleteAdmChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAdmChannelResponse> {
        /**
         * Sets the value of the ADMChannelResponse property for this object.
         *
         * @param admChannelResponse
         *        The new value for the ADMChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admChannelResponse(ADMChannelResponse admChannelResponse);

        /**
         * Sets the value of the ADMChannelResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link ADMChannelResponse.Builder} avoiding the need to
         * create one manually via {@link ADMChannelResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ADMChannelResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #admChannelResponse(ADMChannelResponse)}.
         * 
         * @param admChannelResponse
         *        a consumer that will call methods on {@link ADMChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #admChannelResponse(ADMChannelResponse)
         */
        default Builder admChannelResponse(Consumer<ADMChannelResponse.Builder> admChannelResponse) {
            return admChannelResponse(ADMChannelResponse.builder().applyMutation(admChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ADMChannelResponse admChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAdmChannelResponse model) {
            super(model);
            admChannelResponse(model.admChannelResponse);
        }

        public final ADMChannelResponse.Builder getADMChannelResponse() {
            return admChannelResponse != null ? admChannelResponse.toBuilder() : null;
        }

        @Override
        public final Builder admChannelResponse(ADMChannelResponse admChannelResponse) {
            this.admChannelResponse = admChannelResponse;
            return this;
        }

        public final void setADMChannelResponse(ADMChannelResponse.BuilderImpl admChannelResponse) {
            this.admChannelResponse = admChannelResponse != null ? admChannelResponse.build() : null;
        }

        @Override
        public DeleteAdmChannelResponse build() {
            return new DeleteAdmChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
