/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Email Message.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailMessage implements SdkPojo, Serializable, ToCopyableBuilder<EmailMessage.Builder, EmailMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> FEEDBACK_FORWARDING_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailMessage::feedbackForwardingAddress)).setter(setter(Builder::feedbackForwardingAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingAddress").build())
            .build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailMessage::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<RawEmail> RAW_EMAIL_FIELD = SdkField.<RawEmail> builder(MarshallingType.SDK_POJO)
            .getter(getter(EmailMessage::rawEmail)).setter(setter(Builder::rawEmail)).constructor(RawEmail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawEmail").build()).build();

    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EmailMessage::replyToAddresses))
            .setter(setter(Builder::replyToAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SimpleEmail> SIMPLE_EMAIL_FIELD = SdkField.<SimpleEmail> builder(MarshallingType.SDK_POJO)
            .getter(getter(EmailMessage::simpleEmail)).setter(setter(Builder::simpleEmail)).constructor(SimpleEmail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleEmail").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(EmailMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            FEEDBACK_FORWARDING_ADDRESS_FIELD, FROM_ADDRESS_FIELD, RAW_EMAIL_FIELD, REPLY_TO_ADDRESSES_FIELD, SIMPLE_EMAIL_FIELD,
            SUBSTITUTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String feedbackForwardingAddress;

    private final String fromAddress;

    private final RawEmail rawEmail;

    private final List<String> replyToAddresses;

    private final SimpleEmail simpleEmail;

    private final Map<String, List<String>> substitutions;

    private EmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.feedbackForwardingAddress = builder.feedbackForwardingAddress;
        this.fromAddress = builder.fromAddress;
        this.rawEmail = builder.rawEmail;
        this.replyToAddresses = builder.replyToAddresses;
        this.simpleEmail = builder.simpleEmail;
        this.substitutions = builder.substitutions;
    }

    /**
     * The body of the email message.
     * 
     * @return The body of the email message.
     */
    public String body() {
        return body;
    }

    /**
     * The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled.
     * 
     * @return The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled.
     */
    public String feedbackForwardingAddress() {
        return feedbackForwardingAddress;
    }

    /**
     * The email address used to send the email from. Defaults to use FromAddress specified in the Email Channel.
     * 
     * @return The email address used to send the email from. Defaults to use FromAddress specified in the Email
     *         Channel.
     */
    public String fromAddress() {
        return fromAddress;
    }

    /**
     * An email represented as a raw MIME message.
     * 
     * @return An email represented as a raw MIME message.
     */
    public RawEmail rawEmail() {
        return rawEmail;
    }

    /**
     * The reply-to email address(es) for the email. If the recipient replies to the email, each reply-to address will
     * receive the reply.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The reply-to email address(es) for the email. If the recipient replies to the email, each reply-to
     *         address will receive the reply.
     */
    public List<String> replyToAddresses() {
        return replyToAddresses;
    }

    /**
     * An email composed of a subject, a text part and a html part.
     * 
     * @return An email composed of a subject, a text part and a html part.
     */
    public SimpleEmail simpleEmail() {
        return simpleEmail;
    }

    /**
     * Default message substitutions. Can be overridden by individual address substitutions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default message substitutions. Can be overridden by individual address substitutions.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackForwardingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(rawEmail());
        hashCode = 31 * hashCode + Objects.hashCode(replyToAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(simpleEmail());
        hashCode = 31 * hashCode + Objects.hashCode(substitutions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessage)) {
            return false;
        }
        EmailMessage other = (EmailMessage) obj;
        return Objects.equals(body(), other.body())
                && Objects.equals(feedbackForwardingAddress(), other.feedbackForwardingAddress())
                && Objects.equals(fromAddress(), other.fromAddress()) && Objects.equals(rawEmail(), other.rawEmail())
                && Objects.equals(replyToAddresses(), other.replyToAddresses())
                && Objects.equals(simpleEmail(), other.simpleEmail()) && Objects.equals(substitutions(), other.substitutions());
    }

    @Override
    public String toString() {
        return ToString.builder("EmailMessage").add("Body", body()).add("FeedbackForwardingAddress", feedbackForwardingAddress())
                .add("FromAddress", fromAddress()).add("RawEmail", rawEmail()).add("ReplyToAddresses", replyToAddresses())
                .add("SimpleEmail", simpleEmail()).add("Substitutions", substitutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "FeedbackForwardingAddress":
            return Optional.ofNullable(clazz.cast(feedbackForwardingAddress()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "RawEmail":
            return Optional.ofNullable(clazz.cast(rawEmail()));
        case "ReplyToAddresses":
            return Optional.ofNullable(clazz.cast(replyToAddresses()));
        case "SimpleEmail":
            return Optional.ofNullable(clazz.cast(simpleEmail()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailMessage, T> g) {
        return obj -> g.apply((EmailMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailMessage> {
        /**
         * The body of the email message.
         * 
         * @param body
         *        The body of the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled.
         * 
         * @param feedbackForwardingAddress
         *        The email address that bounces and complaints will be forwarded to when feedback forwarding is
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackForwardingAddress(String feedbackForwardingAddress);

        /**
         * The email address used to send the email from. Defaults to use FromAddress specified in the Email Channel.
         * 
         * @param fromAddress
         *        The email address used to send the email from. Defaults to use FromAddress specified in the Email
         *        Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * An email represented as a raw MIME message.
         * 
         * @param rawEmail
         *        An email represented as a raw MIME message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawEmail(RawEmail rawEmail);

        /**
         * An email represented as a raw MIME message. This is a convenience that creates an instance of the
         * {@link RawEmail.Builder} avoiding the need to create one manually via {@link RawEmail#builder()}.
         *
         * When the {@link Consumer} completes, {@link RawEmail.Builder#build()} is called immediately and its result is
         * passed to {@link #rawEmail(RawEmail)}.
         * 
         * @param rawEmail
         *        a consumer that will call methods on {@link RawEmail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawEmail(RawEmail)
         */
        default Builder rawEmail(Consumer<RawEmail.Builder> rawEmail) {
            return rawEmail(RawEmail.builder().applyMutation(rawEmail).build());
        }

        /**
         * The reply-to email address(es) for the email. If the recipient replies to the email, each reply-to address
         * will receive the reply.
         * 
         * @param replyToAddresses
         *        The reply-to email address(es) for the email. If the recipient replies to the email, each reply-to
         *        address will receive the reply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToAddresses(Collection<String> replyToAddresses);

        /**
         * The reply-to email address(es) for the email. If the recipient replies to the email, each reply-to address
         * will receive the reply.
         * 
         * @param replyToAddresses
         *        The reply-to email address(es) for the email. If the recipient replies to the email, each reply-to
         *        address will receive the reply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToAddresses(String... replyToAddresses);

        /**
         * An email composed of a subject, a text part and a html part.
         * 
         * @param simpleEmail
         *        An email composed of a subject, a text part and a html part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleEmail(SimpleEmail simpleEmail);

        /**
         * An email composed of a subject, a text part and a html part. This is a convenience that creates an instance
         * of the {@link SimpleEmail.Builder} avoiding the need to create one manually via {@link SimpleEmail#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link SimpleEmail.Builder#build()} is called immediately and its result
         * is passed to {@link #simpleEmail(SimpleEmail)}.
         * 
         * @param simpleEmail
         *        a consumer that will call methods on {@link SimpleEmail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleEmail(SimpleEmail)
         */
        default Builder simpleEmail(Consumer<SimpleEmail.Builder> simpleEmail) {
            return simpleEmail(SimpleEmail.builder().applyMutation(simpleEmail).build());
        }

        /**
         * Default message substitutions. Can be overridden by individual address substitutions.
         * 
         * @param substitutions
         *        Default message substitutions. Can be overridden by individual address substitutions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String feedbackForwardingAddress;

        private String fromAddress;

        private RawEmail rawEmail;

        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();

        private SimpleEmail simpleEmail;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMessage model) {
            body(model.body);
            feedbackForwardingAddress(model.feedbackForwardingAddress);
            fromAddress(model.fromAddress);
            rawEmail(model.rawEmail);
            replyToAddresses(model.replyToAddresses);
            simpleEmail(model.simpleEmail);
            substitutions(model.substitutions);
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getFeedbackForwardingAddress() {
            return feedbackForwardingAddress;
        }

        @Override
        public final Builder feedbackForwardingAddress(String feedbackForwardingAddress) {
            this.feedbackForwardingAddress = feedbackForwardingAddress;
            return this;
        }

        public final void setFeedbackForwardingAddress(String feedbackForwardingAddress) {
            this.feedbackForwardingAddress = feedbackForwardingAddress;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final RawEmail.Builder getRawEmail() {
            return rawEmail != null ? rawEmail.toBuilder() : null;
        }

        @Override
        public final Builder rawEmail(RawEmail rawEmail) {
            this.rawEmail = rawEmail;
            return this;
        }

        public final void setRawEmail(RawEmail.BuilderImpl rawEmail) {
            this.rawEmail = rawEmail != null ? rawEmail.build() : null;
        }

        public final Collection<String> getReplyToAddresses() {
            return replyToAddresses;
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = ListOf__stringCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String... replyToAddresses) {
            replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = ListOf__stringCopier.copy(replyToAddresses);
        }

        public final SimpleEmail.Builder getSimpleEmail() {
            return simpleEmail != null ? simpleEmail.toBuilder() : null;
        }

        @Override
        public final Builder simpleEmail(SimpleEmail simpleEmail) {
            this.simpleEmail = simpleEmail;
            return this;
        }

        public final void setSimpleEmail(SimpleEmail.BuilderImpl simpleEmail) {
            this.simpleEmail = simpleEmail != null ? simpleEmail.build() : null;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public EmailMessage build() {
            return new EmailMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
