/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * List of endpoints
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointsResponse.Builder, EndpointsResponse> {
    private static final SdkField<List<EndpointResponse>> ITEM_FIELD = SdkField
            .<List<EndpointResponse>> builder(MarshallingType.LIST)
            .getter(getter(EndpointsResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EndpointResponse> item;

    private EndpointsResponse(BuilderImpl builder) {
        this.item = builder.item;
    }

    /**
     * The list of endpoints.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of endpoints.
     */
    public List<EndpointResponse> item() {
        return item;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(item());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointsResponse)) {
            return false;
        }
        EndpointsResponse other = (EndpointsResponse) obj;
        return Objects.equals(item(), other.item());
    }

    @Override
    public String toString() {
        return ToString.builder("EndpointsResponse").add("Item", item()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointsResponse, T> g) {
        return obj -> g.apply((EndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointsResponse> {
        /**
         * The list of endpoints.
         * 
         * @param item
         *        The list of endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<EndpointResponse> item);

        /**
         * The list of endpoints.
         * 
         * @param item
         *        The list of endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(EndpointResponse... item);

        /**
         * The list of endpoints. This is a convenience that creates an instance of the {@link List
         * <EndpointResponse>.Builder} avoiding the need to create one manually via {@link List
         * <EndpointResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointResponse>.Builder#build()} is called immediately and
         * its result is passed to {@link #item(List<EndpointResponse>)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link List<EndpointResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(List<EndpointResponse>)
         */
        Builder item(Consumer<EndpointResponse.Builder>... item);
    }

    static final class BuilderImpl implements Builder {
        private List<EndpointResponse> item = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointsResponse model) {
            item(model.item);
        }

        public final Collection<EndpointResponse.Builder> getItem() {
            return item != null ? item.stream().map(EndpointResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<EndpointResponse> item) {
            this.item = ListOfEndpointResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(EndpointResponse... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<EndpointResponse.Builder>... item) {
            item(Stream.of(item).map(c -> EndpointResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<EndpointResponse.BuilderImpl> item) {
            this.item = ListOfEndpointResponseCopier.copyFromBuilder(item);
        }

        @Override
        public EndpointsResponse build() {
            return new EndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
