/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventStreamResponse extends PinpointResponse implements
        ToCopyableBuilder<GetEventStreamResponse.Builder, GetEventStreamResponse> {
    private static final SdkField<EventStream> EVENT_STREAM_FIELD = SdkField
            .<EventStream> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetEventStreamResponse::eventStream))
            .setter(setter(Builder::eventStream))
            .constructor(EventStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStream").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_STREAM_FIELD));

    private final EventStream eventStream;

    private GetEventStreamResponse(BuilderImpl builder) {
        super(builder);
        this.eventStream = builder.eventStream;
    }

    /**
     * Returns the value of the EventStream property for this object.
     * 
     * @return The value of the EventStream property for this object.
     */
    public EventStream eventStream() {
        return eventStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventStream());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventStreamResponse)) {
            return false;
        }
        GetEventStreamResponse other = (GetEventStreamResponse) obj;
        return Objects.equals(eventStream(), other.eventStream());
    }

    @Override
    public String toString() {
        return ToString.builder("GetEventStreamResponse").add("EventStream", eventStream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventStream":
            return Optional.ofNullable(clazz.cast(eventStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventStreamResponse, T> g) {
        return obj -> g.apply((GetEventStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEventStreamResponse> {
        /**
         * Sets the value of the EventStream property for this object.
         *
         * @param eventStream
         *        The new value for the EventStream property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStream(EventStream eventStream);

        /**
         * Sets the value of the EventStream property for this object.
         *
         * This is a convenience that creates an instance of the {@link EventStream.Builder} avoiding the need to create
         * one manually via {@link EventStream#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventStream.Builder#build()} is called immediately and its result
         * is passed to {@link #eventStream(EventStream)}.
         * 
         * @param eventStream
         *        a consumer that will call methods on {@link EventStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventStream(EventStream)
         */
        default Builder eventStream(Consumer<EventStream.Builder> eventStream) {
            return eventStream(EventStream.builder().applyMutation(eventStream).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private EventStream eventStream;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventStreamResponse model) {
            super(model);
            eventStream(model.eventStream);
        }

        public final EventStream.Builder getEventStream() {
            return eventStream != null ? eventStream.toBuilder() : null;
        }

        @Override
        public final Builder eventStream(EventStream eventStream) {
            this.eventStream = eventStream;
            return this;
        }

        public final void setEventStream(EventStream.BuilderImpl eventStream) {
            this.eventStream = eventStream != null ? eventStream.build() : null;
        }

        @Override
        public GetEventStreamResponse build() {
            return new GetEventStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
