/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentVersionsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetSegmentVersionsResponse.Builder, GetSegmentVersionsResponse> {
    private static final SdkField<SegmentsResponse> SEGMENTS_RESPONSE_FIELD = SdkField
            .<SegmentsResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSegmentVersionsResponse::segmentsResponse))
            .setter(setter(Builder::segmentsResponse))
            .constructor(SegmentsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENTS_RESPONSE_FIELD));

    private final SegmentsResponse segmentsResponse;

    private GetSegmentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.segmentsResponse = builder.segmentsResponse;
    }

    /**
     * Returns the value of the SegmentsResponse property for this object.
     * 
     * @return The value of the SegmentsResponse property for this object.
     */
    public SegmentsResponse segmentsResponse() {
        return segmentsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentsResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentVersionsResponse)) {
            return false;
        }
        GetSegmentVersionsResponse other = (GetSegmentVersionsResponse) obj;
        return Objects.equals(segmentsResponse(), other.segmentsResponse());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSegmentVersionsResponse").add("SegmentsResponse", segmentsResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentsResponse":
            return Optional.ofNullable(clazz.cast(segmentsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentVersionsResponse, T> g) {
        return obj -> g.apply((GetSegmentVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSegmentVersionsResponse> {
        /**
         * Sets the value of the SegmentsResponse property for this object.
         *
         * @param segmentsResponse
         *        The new value for the SegmentsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsResponse(SegmentsResponse segmentsResponse);

        /**
         * Sets the value of the SegmentsResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link SegmentsResponse.Builder} avoiding the need to
         * create one manually via {@link SegmentsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentsResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentsResponse(SegmentsResponse)}.
         * 
         * @param segmentsResponse
         *        a consumer that will call methods on {@link SegmentsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentsResponse(SegmentsResponse)
         */
        default Builder segmentsResponse(Consumer<SegmentsResponse.Builder> segmentsResponse) {
            return segmentsResponse(SegmentsResponse.builder().applyMutation(segmentsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private SegmentsResponse segmentsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentVersionsResponse model) {
            super(model);
            segmentsResponse(model.segmentsResponse);
        }

        public final SegmentsResponse.Builder getSegmentsResponse() {
            return segmentsResponse != null ? segmentsResponse.toBuilder() : null;
        }

        @Override
        public final Builder segmentsResponse(SegmentsResponse segmentsResponse) {
            this.segmentsResponse = segmentsResponse;
            return this;
        }

        public final void setSegmentsResponse(SegmentsResponse.BuilderImpl segmentsResponse) {
            this.segmentsResponse = segmentsResponse != null ? segmentsResponse.build() : null;
        }

        @Override
        public GetSegmentVersionsResponse build() {
            return new GetSegmentVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
