/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Shcedule that defines when a campaign is run.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Schedule::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<CampaignEventFilter> EVENT_FILTER_FIELD = SdkField
            .<CampaignEventFilter> builder(MarshallingType.SDK_POJO).getter(getter(Schedule::eventFilter))
            .setter(setter(Builder::eventFilter)).constructor(CampaignEventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build()).build();

    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Schedule::frequencyAsString)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()).build();

    private static final SdkField<Boolean> IS_LOCAL_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Schedule::isLocalTime)).setter(setter(Builder::isLocalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLocalTime").build()).build();

    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.<QuietTime> builder(MarshallingType.SDK_POJO)
            .getter(getter(Schedule::quietTime)).setter(setter(Builder::quietTime)).constructor(QuietTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Schedule::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Schedule::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            EVENT_FILTER_FIELD, FREQUENCY_FIELD, IS_LOCAL_TIME_FIELD, QUIET_TIME_FIELD, START_TIME_FIELD, TIMEZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endTime;

    private final CampaignEventFilter eventFilter;

    private final String frequency;

    private final Boolean isLocalTime;

    private final QuietTime quietTime;

    private final String startTime;

    private final String timezone;

    private Schedule(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.eventFilter = builder.eventFilter;
        this.frequency = builder.frequency;
        this.isLocalTime = builder.isLocalTime;
        this.quietTime = builder.quietTime;
        this.startTime = builder.startTime;
        this.timezone = builder.timezone;
    }

    /**
     * The scheduled time that the campaign ends in ISO 8601 format.
     * 
     * @return The scheduled time that the campaign ends in ISO 8601 format.
     */
    public String endTime() {
        return endTime;
    }

    /**
     * Defines the type of events that can trigger the campaign. Used when the Frequency is set to EVENT.
     * 
     * @return Defines the type of events that can trigger the campaign. Used when the Frequency is set to EVENT.
     */
    public CampaignEventFilter eventFilter() {
        return eventFilter;
    }

    /**
     * How often the campaign delivers messages.
     *
     * Valid values:
     *
     * ONCE
     *
     * HOURLY
     *
     * DAILY
     *
     * WEEKLY
     *
     * MONTHLY
     *
     * EVENT
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the campaign delivers messages.
     *
     *         Valid values:
     *
     *         ONCE
     *
     *         HOURLY
     *
     *         DAILY
     *
     *         WEEKLY
     *
     *         MONTHLY
     *
     *         EVENT
     * @see Frequency
     */
    public Frequency frequency() {
        return Frequency.fromValue(frequency);
    }

    /**
     * How often the campaign delivers messages.
     *
     * Valid values:
     *
     * ONCE
     *
     * HOURLY
     *
     * DAILY
     *
     * WEEKLY
     *
     * MONTHLY
     *
     * EVENT
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the campaign delivers messages.
     *
     *         Valid values:
     *
     *         ONCE
     *
     *         HOURLY
     *
     *         DAILY
     *
     *         WEEKLY
     *
     *         MONTHLY
     *
     *         EVENT
     * @see Frequency
     */
    public String frequencyAsString() {
        return frequency;
    }

    /**
     * Indicates whether the campaign schedule takes effect according to each user's local time.
     * 
     * @return Indicates whether the campaign schedule takes effect according to each user's local time.
     */
    public Boolean isLocalTime() {
        return isLocalTime;
    }

    /**
     * The default quiet time for the campaign. The campaign doesn't send messages to endpoints during the quiet time.
     *
     * Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a quiet
     * time for your campaign. If your endpoints don't include this attribute, they'll receive the messages that you
     * send them, even if quiet time is enabled.
     *
     * When you set up a campaign to use quiet time, the campaign doesn't send messages during the time range you
     * specified, as long as all of the following are true: - The endpoint includes a valid Demographic.Timezone
     * attribute. - The current time in the endpoint's time zone is later than or equal to the time specified in the
     * QuietTime.Start attribute for the campaign. - The current time in the endpoint's time zone is earlier than or
     * equal to the time specified in the QuietTime.End attribute for the campaign.
     * 
     * @return The default quiet time for the campaign. The campaign doesn't send messages to endpoints during the quiet
     *         time.
     *
     *         Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a
     *         quiet time for your campaign. If your endpoints don't include this attribute, they'll receive the
     *         messages that you send them, even if quiet time is enabled.
     *
     *         When you set up a campaign to use quiet time, the campaign doesn't send messages during the time range
     *         you specified, as long as all of the following are true: - The endpoint includes a valid
     *         Demographic.Timezone attribute. - The current time in the endpoint's time zone is later than or equal to
     *         the time specified in the QuietTime.Start attribute for the campaign. - The current time in the
     *         endpoint's time zone is earlier than or equal to the time specified in the QuietTime.End attribute for
     *         the campaign.
     */
    public QuietTime quietTime() {
        return quietTime;
    }

    /**
     * The scheduled time that the campaign begins in ISO 8601 format.
     * 
     * @return The scheduled time that the campaign begins in ISO 8601 format.
     */
    public String startTime() {
        return startTime;
    }

    /**
     * The starting UTC offset for the schedule if the value for isLocalTime is true
     *
     * Valid values: UTC UTC+01 UTC+02 UTC+03 UTC+03:30 UTC+04 UTC+04:30 UTC+05 UTC+05:30 UTC+05:45 UTC+06 UTC+06:30
     * UTC+07 UTC+08 UTC+09 UTC+09:30 UTC+10 UTC+10:30 UTC+11 UTC+12 UTC+13 UTC-02 UTC-03 UTC-04 UTC-05 UTC-06 UTC-07
     * UTC-08 UTC-09 UTC-10 UTC-11
     * 
     * @return The starting UTC offset for the schedule if the value for isLocalTime is true
     *
     *         Valid values: UTC UTC+01 UTC+02 UTC+03 UTC+03:30 UTC+04 UTC+04:30 UTC+05 UTC+05:30 UTC+05:45 UTC+06
     *         UTC+06:30 UTC+07 UTC+08 UTC+09 UTC+09:30 UTC+10 UTC+10:30 UTC+11 UTC+12 UTC+13 UTC-02 UTC-03 UTC-04
     *         UTC-05 UTC-06 UTC-07 UTC-08 UTC-09 UTC-10 UTC-11
     */
    public String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isLocalTime());
        hashCode = 31 * hashCode + Objects.hashCode(quietTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(eventFilter(), other.eventFilter())
                && Objects.equals(frequencyAsString(), other.frequencyAsString())
                && Objects.equals(isLocalTime(), other.isLocalTime()) && Objects.equals(quietTime(), other.quietTime())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(timezone(), other.timezone());
    }

    @Override
    public String toString() {
        return ToString.builder("Schedule").add("EndTime", endTime()).add("EventFilter", eventFilter())
                .add("Frequency", frequencyAsString()).add("IsLocalTime", isLocalTime()).add("QuietTime", quietTime())
                .add("StartTime", startTime()).add("Timezone", timezone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "EventFilter":
            return Optional.ofNullable(clazz.cast(eventFilter()));
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "IsLocalTime":
            return Optional.ofNullable(clazz.cast(isLocalTime()));
        case "QuietTime":
            return Optional.ofNullable(clazz.cast(quietTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * The scheduled time that the campaign ends in ISO 8601 format.
         * 
         * @param endTime
         *        The scheduled time that the campaign ends in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * Defines the type of events that can trigger the campaign. Used when the Frequency is set to EVENT.
         * 
         * @param eventFilter
         *        Defines the type of events that can trigger the campaign. Used when the Frequency is set to EVENT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(CampaignEventFilter eventFilter);

        /**
         * Defines the type of events that can trigger the campaign. Used when the Frequency is set to EVENT. This is a
         * convenience that creates an instance of the {@link CampaignEventFilter.Builder} avoiding the need to create
         * one manually via {@link CampaignEventFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignEventFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #eventFilter(CampaignEventFilter)}.
         * 
         * @param eventFilter
         *        a consumer that will call methods on {@link CampaignEventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFilter(CampaignEventFilter)
         */
        default Builder eventFilter(Consumer<CampaignEventFilter.Builder> eventFilter) {
            return eventFilter(CampaignEventFilter.builder().applyMutation(eventFilter).build());
        }

        /**
         * How often the campaign delivers messages.
         *
         * Valid values:
         *
         * ONCE
         *
         * HOURLY
         *
         * DAILY
         *
         * WEEKLY
         *
         * MONTHLY
         *
         * EVENT
         * 
         * @param frequency
         *        How often the campaign delivers messages.
         *
         *        Valid values:
         *
         *        ONCE
         *
         *        HOURLY
         *
         *        DAILY
         *
         *        WEEKLY
         *
         *        MONTHLY
         *
         *        EVENT
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder frequency(String frequency);

        /**
         * How often the campaign delivers messages.
         *
         * Valid values:
         *
         * ONCE
         *
         * HOURLY
         *
         * DAILY
         *
         * WEEKLY
         *
         * MONTHLY
         *
         * EVENT
         * 
         * @param frequency
         *        How often the campaign delivers messages.
         *
         *        Valid values:
         *
         *        ONCE
         *
         *        HOURLY
         *
         *        DAILY
         *
         *        WEEKLY
         *
         *        MONTHLY
         *
         *        EVENT
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder frequency(Frequency frequency);

        /**
         * Indicates whether the campaign schedule takes effect according to each user's local time.
         * 
         * @param isLocalTime
         *        Indicates whether the campaign schedule takes effect according to each user's local time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLocalTime(Boolean isLocalTime);

        /**
         * The default quiet time for the campaign. The campaign doesn't send messages to endpoints during the quiet
         * time.
         *
         * Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a quiet
         * time for your campaign. If your endpoints don't include this attribute, they'll receive the messages that you
         * send them, even if quiet time is enabled.
         *
         * When you set up a campaign to use quiet time, the campaign doesn't send messages during the time range you
         * specified, as long as all of the following are true: - The endpoint includes a valid Demographic.Timezone
         * attribute. - The current time in the endpoint's time zone is later than or equal to the time specified in the
         * QuietTime.Start attribute for the campaign. - The current time in the endpoint's time zone is earlier than or
         * equal to the time specified in the QuietTime.End attribute for the campaign.
         * 
         * @param quietTime
         *        The default quiet time for the campaign. The campaign doesn't send messages to endpoints during the
         *        quiet time.
         *
         *        Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable
         *        a quiet time for your campaign. If your endpoints don't include this attribute, they'll receive the
         *        messages that you send them, even if quiet time is enabled.
         *
         *        When you set up a campaign to use quiet time, the campaign doesn't send messages during the time range
         *        you specified, as long as all of the following are true: - The endpoint includes a valid
         *        Demographic.Timezone attribute. - The current time in the endpoint's time zone is later than or equal
         *        to the time specified in the QuietTime.Start attribute for the campaign. - The current time in the
         *        endpoint's time zone is earlier than or equal to the time specified in the QuietTime.End attribute for
         *        the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quietTime(QuietTime quietTime);

        /**
         * The default quiet time for the campaign. The campaign doesn't send messages to endpoints during the quiet
         * time.
         *
         * Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a quiet
         * time for your campaign. If your endpoints don't include this attribute, they'll receive the messages that you
         * send them, even if quiet time is enabled.
         *
         * When you set up a campaign to use quiet time, the campaign doesn't send messages during the time range you
         * specified, as long as all of the following are true: - The endpoint includes a valid Demographic.Timezone
         * attribute. - The current time in the endpoint's time zone is later than or equal to the time specified in the
         * QuietTime.Start attribute for the campaign. - The current time in the endpoint's time zone is earlier than or
         * equal to the time specified in the QuietTime.End attribute for the campaign. This is a convenience that
         * creates an instance of the {@link QuietTime.Builder} avoiding the need to create one manually via
         * {@link QuietTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuietTime.Builder#build()} is called immediately and its result
         * is passed to {@link #quietTime(QuietTime)}.
         * 
         * @param quietTime
         *        a consumer that will call methods on {@link QuietTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quietTime(QuietTime)
         */
        default Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return quietTime(QuietTime.builder().applyMutation(quietTime).build());
        }

        /**
         * The scheduled time that the campaign begins in ISO 8601 format.
         * 
         * @param startTime
         *        The scheduled time that the campaign begins in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * The starting UTC offset for the schedule if the value for isLocalTime is true
         *
         * Valid values: UTC UTC+01 UTC+02 UTC+03 UTC+03:30 UTC+04 UTC+04:30 UTC+05 UTC+05:30 UTC+05:45 UTC+06 UTC+06:30
         * UTC+07 UTC+08 UTC+09 UTC+09:30 UTC+10 UTC+10:30 UTC+11 UTC+12 UTC+13 UTC-02 UTC-03 UTC-04 UTC-05 UTC-06
         * UTC-07 UTC-08 UTC-09 UTC-10 UTC-11
         * 
         * @param timezone
         *        The starting UTC offset for the schedule if the value for isLocalTime is true
         *
         *        Valid values: UTC UTC+01 UTC+02 UTC+03 UTC+03:30 UTC+04 UTC+04:30 UTC+05 UTC+05:30 UTC+05:45 UTC+06
         *        UTC+06:30 UTC+07 UTC+08 UTC+09 UTC+09:30 UTC+10 UTC+10:30 UTC+11 UTC+12 UTC+13 UTC-02 UTC-03 UTC-04
         *        UTC-05 UTC-06 UTC-07 UTC-08 UTC-09 UTC-10 UTC-11
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl implements Builder {
        private String endTime;

        private CampaignEventFilter eventFilter;

        private String frequency;

        private Boolean isLocalTime;

        private QuietTime quietTime;

        private String startTime;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            endTime(model.endTime);
            eventFilter(model.eventFilter);
            frequency(model.frequency);
            isLocalTime(model.isLocalTime);
            quietTime(model.quietTime);
            startTime(model.startTime);
            timezone(model.timezone);
        }

        public final String getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final CampaignEventFilter.Builder getEventFilter() {
            return eventFilter != null ? eventFilter.toBuilder() : null;
        }

        @Override
        public final Builder eventFilter(CampaignEventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final void setEventFilter(CampaignEventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(Frequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Boolean getIsLocalTime() {
            return isLocalTime;
        }

        @Override
        public final Builder isLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
            return this;
        }

        public final void setIsLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
        }

        public final QuietTime.Builder getQuietTime() {
            return quietTime != null ? quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
