/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Segment definition.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentResponse implements SdkPojo, Serializable, ToCopyableBuilder<SegmentResponse.Builder, SegmentResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<SegmentDimensions> DIMENSIONS_FIELD = SdkField
            .<SegmentDimensions> builder(MarshallingType.SDK_POJO).getter(getter(SegmentResponse::dimensions))
            .setter(setter(Builder::dimensions)).constructor(SegmentDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<SegmentImportResource> IMPORT_DEFINITION_FIELD = SdkField
            .<SegmentImportResource> builder(MarshallingType.SDK_POJO).getter(getter(SegmentResponse::importDefinition))
            .setter(setter(Builder::importDefinition)).constructor(SegmentImportResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDefinition").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<SegmentGroupList> SEGMENT_GROUPS_FIELD = SdkField
            .<SegmentGroupList> builder(MarshallingType.SDK_POJO).getter(getter(SegmentResponse::segmentGroups))
            .setter(setter(Builder::segmentGroups)).constructor(SegmentGroupList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentGroups").build()).build();

    private static final SdkField<String> SEGMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::segmentTypeAsString)).setter(setter(Builder::segmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentType").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SegmentResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CREATION_DATE_FIELD, DIMENSIONS_FIELD, ID_FIELD, IMPORT_DEFINITION_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD,
            SEGMENT_GROUPS_FIELD, SEGMENT_TYPE_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String creationDate;

    private final SegmentDimensions dimensions;

    private final String id;

    private final SegmentImportResource importDefinition;

    private final String lastModifiedDate;

    private final String name;

    private final SegmentGroupList segmentGroups;

    private final String segmentType;

    private final Integer version;

    private SegmentResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.dimensions = builder.dimensions;
        this.id = builder.id;
        this.importDefinition = builder.importDefinition;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.segmentGroups = builder.segmentGroups;
        this.segmentType = builder.segmentType;
        this.version = builder.version;
    }

    /**
     * The ID of the application that the segment applies to.
     * 
     * @return The ID of the application that the segment applies to.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The date and time when the segment was created.
     * 
     * @return The date and time when the segment was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * The segment dimensions attributes.
     * 
     * @return The segment dimensions attributes.
     */
    public SegmentDimensions dimensions() {
        return dimensions;
    }

    /**
     * The unique segment ID.
     * 
     * @return The unique segment ID.
     */
    public String id() {
        return id;
    }

    /**
     * The import job settings.
     * 
     * @return The import job settings.
     */
    public SegmentImportResource importDefinition() {
        return importDefinition;
    }

    /**
     * The date and time when the segment was last modified.
     * 
     * @return The date and time when the segment was last modified.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * The name of the segment.
     * 
     * @return The name of the segment.
     */
    public String name() {
        return name;
    }

    /**
     * A segment group, which consists of zero or more source segments, plus dimensions that are applied to those source
     * segments.
     * 
     * @return A segment group, which consists of zero or more source segments, plus dimensions that are applied to
     *         those source segments.
     */
    public SegmentGroupList segmentGroups() {
        return segmentGroups;
    }

    /**
     * The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data reported
     * by your app. You create this type of segment by using the segment builder in the Amazon Pinpoint console or by
     * making a POST request to the segments resource. IMPORT - A static segment built from an imported set of endpoint
     * definitions. You create this type of segment by importing a segment in the Amazon Pinpoint console or by making a
     * POST request to the jobs/import resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentType} will
     * return {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #segmentTypeAsString}.
     * </p>
     * 
     * @return The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data
     *         reported by your app. You create this type of segment by using the segment builder in the Amazon Pinpoint
     *         console or by making a POST request to the segments resource. IMPORT - A static segment built from an
     *         imported set of endpoint definitions. You create this type of segment by importing a segment in the
     *         Amazon Pinpoint console or by making a POST request to the jobs/import resource.
     * @see SegmentType
     */
    public SegmentType segmentType() {
        return SegmentType.fromValue(segmentType);
    }

    /**
     * The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data reported
     * by your app. You create this type of segment by using the segment builder in the Amazon Pinpoint console or by
     * making a POST request to the segments resource. IMPORT - A static segment built from an imported set of endpoint
     * definitions. You create this type of segment by importing a segment in the Amazon Pinpoint console or by making a
     * POST request to the jobs/import resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentType} will
     * return {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #segmentTypeAsString}.
     * </p>
     * 
     * @return The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data
     *         reported by your app. You create this type of segment by using the segment builder in the Amazon Pinpoint
     *         console or by making a POST request to the segments resource. IMPORT - A static segment built from an
     *         imported set of endpoint definitions. You create this type of segment by importing a segment in the
     *         Amazon Pinpoint console or by making a POST request to the jobs/import resource.
     * @see SegmentType
     */
    public String segmentTypeAsString() {
        return segmentType;
    }

    /**
     * The segment version number.
     * 
     * @return The segment version number.
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(importDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(segmentGroups());
        hashCode = 31 * hashCode + Objects.hashCode(segmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentResponse)) {
            return false;
        }
        SegmentResponse other = (SegmentResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(dimensions(), other.dimensions()) && Objects.equals(id(), other.id())
                && Objects.equals(importDefinition(), other.importDefinition())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(name(), other.name())
                && Objects.equals(segmentGroups(), other.segmentGroups())
                && Objects.equals(segmentTypeAsString(), other.segmentTypeAsString())
                && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("SegmentResponse").add("ApplicationId", applicationId()).add("CreationDate", creationDate())
                .add("Dimensions", dimensions()).add("Id", id()).add("ImportDefinition", importDefinition())
                .add("LastModifiedDate", lastModifiedDate()).add("Name", name()).add("SegmentGroups", segmentGroups())
                .add("SegmentType", segmentTypeAsString()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ImportDefinition":
            return Optional.ofNullable(clazz.cast(importDefinition()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SegmentGroups":
            return Optional.ofNullable(clazz.cast(segmentGroups()));
        case "SegmentType":
            return Optional.ofNullable(clazz.cast(segmentTypeAsString()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentResponse, T> g) {
        return obj -> g.apply((SegmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentResponse> {
        /**
         * The ID of the application that the segment applies to.
         * 
         * @param applicationId
         *        The ID of the application that the segment applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The date and time when the segment was created.
         * 
         * @param creationDate
         *        The date and time when the segment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * The segment dimensions attributes.
         * 
         * @param dimensions
         *        The segment dimensions attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(SegmentDimensions dimensions);

        /**
         * The segment dimensions attributes. This is a convenience that creates an instance of the
         * {@link SegmentDimensions.Builder} avoiding the need to create one manually via
         * {@link SegmentDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(SegmentDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link SegmentDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(SegmentDimensions)
         */
        default Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return dimensions(SegmentDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * The unique segment ID.
         * 
         * @param id
         *        The unique segment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The import job settings.
         * 
         * @param importDefinition
         *        The import job settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDefinition(SegmentImportResource importDefinition);

        /**
         * The import job settings. This is a convenience that creates an instance of the
         * {@link SegmentImportResource.Builder} avoiding the need to create one manually via
         * {@link SegmentImportResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentImportResource.Builder#build()} is called immediately and
         * its result is passed to {@link #importDefinition(SegmentImportResource)}.
         * 
         * @param importDefinition
         *        a consumer that will call methods on {@link SegmentImportResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDefinition(SegmentImportResource)
         */
        default Builder importDefinition(Consumer<SegmentImportResource.Builder> importDefinition) {
            return importDefinition(SegmentImportResource.builder().applyMutation(importDefinition).build());
        }

        /**
         * The date and time when the segment was last modified.
         * 
         * @param lastModifiedDate
         *        The date and time when the segment was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * The name of the segment.
         * 
         * @param name
         *        The name of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * A segment group, which consists of zero or more source segments, plus dimensions that are applied to those
         * source segments.
         * 
         * @param segmentGroups
         *        A segment group, which consists of zero or more source segments, plus dimensions that are applied to
         *        those source segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentGroups(SegmentGroupList segmentGroups);

        /**
         * A segment group, which consists of zero or more source segments, plus dimensions that are applied to those
         * source segments. This is a convenience that creates an instance of the {@link SegmentGroupList.Builder}
         * avoiding the need to create one manually via {@link SegmentGroupList#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentGroupList.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentGroups(SegmentGroupList)}.
         * 
         * @param segmentGroups
         *        a consumer that will call methods on {@link SegmentGroupList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentGroups(SegmentGroupList)
         */
        default Builder segmentGroups(Consumer<SegmentGroupList.Builder> segmentGroups) {
            return segmentGroups(SegmentGroupList.builder().applyMutation(segmentGroups).build());
        }

        /**
         * The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data
         * reported by your app. You create this type of segment by using the segment builder in the Amazon Pinpoint
         * console or by making a POST request to the segments resource. IMPORT - A static segment built from an
         * imported set of endpoint definitions. You create this type of segment by importing a segment in the Amazon
         * Pinpoint console or by making a POST request to the jobs/import resource.
         * 
         * @param segmentType
         *        The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data
         *        reported by your app. You create this type of segment by using the segment builder in the Amazon
         *        Pinpoint console or by making a POST request to the segments resource. IMPORT - A static segment built
         *        from an imported set of endpoint definitions. You create this type of segment by importing a segment
         *        in the Amazon Pinpoint console or by making a POST request to the jobs/import resource.
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder segmentType(String segmentType);

        /**
         * The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data
         * reported by your app. You create this type of segment by using the segment builder in the Amazon Pinpoint
         * console or by making a POST request to the segments resource. IMPORT - A static segment built from an
         * imported set of endpoint definitions. You create this type of segment by importing a segment in the Amazon
         * Pinpoint console or by making a POST request to the jobs/import resource.
         * 
         * @param segmentType
         *        The segment type: DIMENSIONAL - A dynamic segment built from selection criteria based on endpoint data
         *        reported by your app. You create this type of segment by using the segment builder in the Amazon
         *        Pinpoint console or by making a POST request to the segments resource. IMPORT - A static segment built
         *        from an imported set of endpoint definitions. You create this type of segment by importing a segment
         *        in the Amazon Pinpoint console or by making a POST request to the jobs/import resource.
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder segmentType(SegmentType segmentType);

        /**
         * The segment version number.
         * 
         * @param version
         *        The segment version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String creationDate;

        private SegmentDimensions dimensions;

        private String id;

        private SegmentImportResource importDefinition;

        private String lastModifiedDate;

        private String name;

        private SegmentGroupList segmentGroups;

        private String segmentType;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentResponse model) {
            applicationId(model.applicationId);
            creationDate(model.creationDate);
            dimensions(model.dimensions);
            id(model.id);
            importDefinition(model.importDefinition);
            lastModifiedDate(model.lastModifiedDate);
            name(model.name);
            segmentGroups(model.segmentGroups);
            segmentType(model.segmentType);
            version(model.version);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final SegmentDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final SegmentImportResource.Builder getImportDefinition() {
            return importDefinition != null ? importDefinition.toBuilder() : null;
        }

        @Override
        public final Builder importDefinition(SegmentImportResource importDefinition) {
            this.importDefinition = importDefinition;
            return this;
        }

        public final void setImportDefinition(SegmentImportResource.BuilderImpl importDefinition) {
            this.importDefinition = importDefinition != null ? importDefinition.build() : null;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final SegmentGroupList.Builder getSegmentGroups() {
            return segmentGroups != null ? segmentGroups.toBuilder() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroupList segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final void setSegmentGroups(SegmentGroupList.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        public final String getSegmentType() {
            return segmentType;
        }

        @Override
        public final Builder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        @Override
        public final Builder segmentType(SegmentType segmentType) {
            this.segmentType(segmentType.toString());
            return this;
        }

        public final void setSegmentType(String segmentType) {
            this.segmentType = segmentType;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public SegmentResponse build() {
            return new SegmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
