/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEmailChannelRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateEmailChannelRequest.Builder, UpdateEmailChannelRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEmailChannelRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<EmailChannelRequest> EMAIL_CHANNEL_REQUEST_FIELD = SdkField
            .<EmailChannelRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateEmailChannelRequest::emailChannelRequest))
            .setter(setter(Builder::emailChannelRequest))
            .constructor(EmailChannelRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailChannelRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            EMAIL_CHANNEL_REQUEST_FIELD));

    private final String applicationId;

    private final EmailChannelRequest emailChannelRequest;

    private UpdateEmailChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.emailChannelRequest = builder.emailChannelRequest;
    }

    /**
     * The unique ID of your Amazon Pinpoint application.
     * 
     * @return The unique ID of your Amazon Pinpoint application.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the EmailChannelRequest property for this object.
     * 
     * @return The value of the EmailChannelRequest property for this object.
     */
    public EmailChannelRequest emailChannelRequest() {
        return emailChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(emailChannelRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEmailChannelRequest)) {
            return false;
        }
        UpdateEmailChannelRequest other = (UpdateEmailChannelRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(emailChannelRequest(), other.emailChannelRequest());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateEmailChannelRequest").add("ApplicationId", applicationId())
                .add("EmailChannelRequest", emailChannelRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EmailChannelRequest":
            return Optional.ofNullable(clazz.cast(emailChannelRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEmailChannelRequest, T> g) {
        return obj -> g.apply((UpdateEmailChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEmailChannelRequest> {
        /**
         * The unique ID of your Amazon Pinpoint application.
         * 
         * @param applicationId
         *        The unique ID of your Amazon Pinpoint application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the EmailChannelRequest property for this object.
         *
         * @param emailChannelRequest
         *        The new value for the EmailChannelRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailChannelRequest(EmailChannelRequest emailChannelRequest);

        /**
         * Sets the value of the EmailChannelRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link EmailChannelRequest.Builder} avoiding the need
         * to create one manually via {@link EmailChannelRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailChannelRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #emailChannelRequest(EmailChannelRequest)}.
         * 
         * @param emailChannelRequest
         *        a consumer that will call methods on {@link EmailChannelRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailChannelRequest(EmailChannelRequest)
         */
        default Builder emailChannelRequest(Consumer<EmailChannelRequest.Builder> emailChannelRequest) {
            return emailChannelRequest(EmailChannelRequest.builder().applyMutation(emailChannelRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private EmailChannelRequest emailChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEmailChannelRequest model) {
            super(model);
            applicationId(model.applicationId);
            emailChannelRequest(model.emailChannelRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final EmailChannelRequest.Builder getEmailChannelRequest() {
            return emailChannelRequest != null ? emailChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder emailChannelRequest(EmailChannelRequest emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest;
            return this;
        }

        public final void setEmailChannelRequest(EmailChannelRequest.BuilderImpl emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest != null ? emailChannelRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEmailChannelRequest build() {
            return new UpdateEmailChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
