/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Used to create a campaign.
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteCampaignRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteCampaignRequest.Builder, WriteCampaignRequest> {
    private static final SdkField<List<WriteTreatmentResource>> ADDITIONAL_TREATMENTS_FIELD = SdkField
            .<List<WriteTreatmentResource>> builder(MarshallingType.LIST)
            .getter(getter(WriteCampaignRequest::additionalTreatments))
            .setter(setter(Builder::additionalTreatments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalTreatments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WriteTreatmentResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(WriteTreatmentResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteCampaignRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> HOLDOUT_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WriteCampaignRequest::holdoutPercent)).setter(setter(Builder::holdoutPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoldoutPercent").build()).build();

    private static final SdkField<CampaignHook> HOOK_FIELD = SdkField.<CampaignHook> builder(MarshallingType.SDK_POJO)
            .getter(getter(WriteCampaignRequest::hook)).setter(setter(Builder::hook)).constructor(CampaignHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hook").build()).build();

    private static final SdkField<Boolean> IS_PAUSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(WriteCampaignRequest::isPaused)).setter(setter(Builder::isPaused))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPaused").build()).build();

    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.<CampaignLimits> builder(MarshallingType.SDK_POJO)
            .getter(getter(WriteCampaignRequest::limits)).setter(setter(Builder::limits)).constructor(CampaignLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<MessageConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(WriteCampaignRequest::messageConfiguration))
            .setter(setter(Builder::messageConfiguration)).constructor(MessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteCampaignRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .getter(getter(WriteCampaignRequest::schedule)).setter(setter(Builder::schedule)).constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteCampaignRequest::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WriteCampaignRequest::segmentVersion)).setter(setter(Builder::segmentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()).build();

    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteCampaignRequest::treatmentDescription)).setter(setter(Builder::treatmentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build())
            .build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteCampaignRequest::treatmentName)).setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TREATMENTS_FIELD,
            DESCRIPTION_FIELD, HOLDOUT_PERCENT_FIELD, HOOK_FIELD, IS_PAUSED_FIELD, LIMITS_FIELD, MESSAGE_CONFIGURATION_FIELD,
            NAME_FIELD, SCHEDULE_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD, TREATMENT_DESCRIPTION_FIELD,
            TREATMENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<WriteTreatmentResource> additionalTreatments;

    private final String description;

    private final Integer holdoutPercent;

    private final CampaignHook hook;

    private final Boolean isPaused;

    private final CampaignLimits limits;

    private final MessageConfiguration messageConfiguration;

    private final String name;

    private final Schedule schedule;

    private final String segmentId;

    private final Integer segmentVersion;

    private final String treatmentDescription;

    private final String treatmentName;

    private WriteCampaignRequest(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.hook = builder.hook;
        this.isPaused = builder.isPaused;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    /**
     * Treatments that are defined in addition to the default treatment.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Treatments that are defined in addition to the default treatment.
     */
    public List<WriteTreatmentResource> additionalTreatments() {
        return additionalTreatments;
    }

    /**
     * A description of the campaign.
     * 
     * @return A description of the campaign.
     */
    public String description() {
        return description;
    }

    /**
     * The allocated percentage of end users who will not receive messages from this campaign.
     * 
     * @return The allocated percentage of end users who will not receive messages from this campaign.
     */
    public Integer holdoutPercent() {
        return holdoutPercent;
    }

    /**
     * Campaign hook information.
     * 
     * @return Campaign hook information.
     */
    public CampaignHook hook() {
        return hook;
    }

    /**
     * Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume it by
     * setting IsPaused to false.
     * 
     * @return Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume it
     *         by setting IsPaused to false.
     */
    public Boolean isPaused() {
        return isPaused;
    }

    /**
     * The campaign limits settings.
     * 
     * @return The campaign limits settings.
     */
    public CampaignLimits limits() {
        return limits;
    }

    /**
     * The message configuration settings.
     * 
     * @return The message configuration settings.
     */
    public MessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * The custom name of the campaign.
     * 
     * @return The custom name of the campaign.
     */
    public String name() {
        return name;
    }

    /**
     * The campaign schedule.
     * 
     * @return The campaign schedule.
     */
    public Schedule schedule() {
        return schedule;
    }

    /**
     * The ID of the segment to which the campaign sends messages.
     * 
     * @return The ID of the segment to which the campaign sends messages.
     */
    public String segmentId() {
        return segmentId;
    }

    /**
     * The version of the segment to which the campaign sends messages.
     * 
     * @return The version of the segment to which the campaign sends messages.
     */
    public Integer segmentVersion() {
        return segmentVersion;
    }

    /**
     * A custom description for the treatment.
     * 
     * @return A custom description for the treatment.
     */
    public String treatmentDescription() {
        return treatmentDescription;
    }

    /**
     * The custom name of a variation of the campaign used for A/B testing.
     * 
     * @return The custom name of a variation of the campaign used for A/B testing.
     */
    public String treatmentName() {
        return treatmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalTreatments());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(hook());
        hashCode = 31 * hashCode + Objects.hashCode(isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteCampaignRequest)) {
            return false;
        }
        WriteCampaignRequest other = (WriteCampaignRequest) obj;
        return Objects.equals(additionalTreatments(), other.additionalTreatments())
                && Objects.equals(description(), other.description()) && Objects.equals(holdoutPercent(), other.holdoutPercent())
                && Objects.equals(hook(), other.hook()) && Objects.equals(isPaused(), other.isPaused())
                && Objects.equals(limits(), other.limits())
                && Objects.equals(messageConfiguration(), other.messageConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(segmentId(), other.segmentId())
                && Objects.equals(segmentVersion(), other.segmentVersion())
                && Objects.equals(treatmentDescription(), other.treatmentDescription())
                && Objects.equals(treatmentName(), other.treatmentName());
    }

    @Override
    public String toString() {
        return ToString.builder("WriteCampaignRequest").add("AdditionalTreatments", additionalTreatments())
                .add("Description", description()).add("HoldoutPercent", holdoutPercent()).add("Hook", hook())
                .add("IsPaused", isPaused()).add("Limits", limits()).add("MessageConfiguration", messageConfiguration())
                .add("Name", name()).add("Schedule", schedule()).add("SegmentId", segmentId())
                .add("SegmentVersion", segmentVersion()).add("TreatmentDescription", treatmentDescription())
                .add("TreatmentName", treatmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalTreatments":
            return Optional.ofNullable(clazz.cast(additionalTreatments()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HoldoutPercent":
            return Optional.ofNullable(clazz.cast(holdoutPercent()));
        case "Hook":
            return Optional.ofNullable(clazz.cast(hook()));
        case "IsPaused":
            return Optional.ofNullable(clazz.cast(isPaused()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentVersion":
            return Optional.ofNullable(clazz.cast(segmentVersion()));
        case "TreatmentDescription":
            return Optional.ofNullable(clazz.cast(treatmentDescription()));
        case "TreatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteCampaignRequest, T> g) {
        return obj -> g.apply((WriteCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteCampaignRequest> {
        /**
         * Treatments that are defined in addition to the default treatment.
         * 
         * @param additionalTreatments
         *        Treatments that are defined in addition to the default treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(Collection<WriteTreatmentResource> additionalTreatments);

        /**
         * Treatments that are defined in addition to the default treatment.
         * 
         * @param additionalTreatments
         *        Treatments that are defined in addition to the default treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(WriteTreatmentResource... additionalTreatments);

        /**
         * Treatments that are defined in addition to the default treatment. This is a convenience that creates an
         * instance of the {@link List<WriteTreatmentResource>.Builder} avoiding the need to create one manually via
         * {@link List<WriteTreatmentResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WriteTreatmentResource>.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalTreatments(List<WriteTreatmentResource>)}.
         * 
         * @param additionalTreatments
         *        a consumer that will call methods on {@link List<WriteTreatmentResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalTreatments(List<WriteTreatmentResource>)
         */
        Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder>... additionalTreatments);

        /**
         * A description of the campaign.
         * 
         * @param description
         *        A description of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The allocated percentage of end users who will not receive messages from this campaign.
         * 
         * @param holdoutPercent
         *        The allocated percentage of end users who will not receive messages from this campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder holdoutPercent(Integer holdoutPercent);

        /**
         * Campaign hook information.
         * 
         * @param hook
         *        Campaign hook information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hook(CampaignHook hook);

        /**
         * Campaign hook information. This is a convenience that creates an instance of the {@link CampaignHook.Builder}
         * avoiding the need to create one manually via {@link CampaignHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignHook.Builder#build()} is called immediately and its
         * result is passed to {@link #hook(CampaignHook)}.
         * 
         * @param hook
         *        a consumer that will call methods on {@link CampaignHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hook(CampaignHook)
         */
        default Builder hook(Consumer<CampaignHook.Builder> hook) {
            return hook(CampaignHook.builder().applyMutation(hook).build());
        }

        /**
         * Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume it by
         * setting IsPaused to false.
         * 
         * @param isPaused
         *        Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume
         *        it by setting IsPaused to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPaused(Boolean isPaused);

        /**
         * The campaign limits settings.
         * 
         * @param limits
         *        The campaign limits settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(CampaignLimits limits);

        /**
         * The campaign limits settings. This is a convenience that creates an instance of the
         * {@link CampaignLimits.Builder} avoiding the need to create one manually via {@link CampaignLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(CampaignLimits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link CampaignLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(CampaignLimits)
         */
        default Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return limits(CampaignLimits.builder().applyMutation(limits).build());
        }

        /**
         * The message configuration settings.
         * 
         * @param messageConfiguration
         *        The message configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(MessageConfiguration messageConfiguration);

        /**
         * The message configuration settings. This is a convenience that creates an instance of the
         * {@link MessageConfiguration.Builder} avoiding the need to create one manually via
         * {@link MessageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #messageConfiguration(MessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link MessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(MessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(MessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * The custom name of the campaign.
         * 
         * @param name
         *        The custom name of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The campaign schedule.
         * 
         * @param schedule
         *        The campaign schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * The campaign schedule. This is a convenience that creates an instance of the {@link Schedule.Builder}
         * avoiding the need to create one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * The ID of the segment to which the campaign sends messages.
         * 
         * @param segmentId
         *        The ID of the segment to which the campaign sends messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * The version of the segment to which the campaign sends messages.
         * 
         * @param segmentVersion
         *        The version of the segment to which the campaign sends messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentVersion(Integer segmentVersion);

        /**
         * A custom description for the treatment.
         * 
         * @param treatmentDescription
         *        A custom description for the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentDescription(String treatmentDescription);

        /**
         * The custom name of a variation of the campaign used for A/B testing.
         * 
         * @param treatmentName
         *        The custom name of a variation of the campaign used for A/B testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);
    }

    static final class BuilderImpl implements Builder {
        private List<WriteTreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Integer holdoutPercent;

        private CampaignHook hook;

        private Boolean isPaused;

        private CampaignLimits limits;

        private MessageConfiguration messageConfiguration;

        private String name;

        private Schedule schedule;

        private String segmentId;

        private Integer segmentVersion;

        private String treatmentDescription;

        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteCampaignRequest model) {
            additionalTreatments(model.additionalTreatments);
            description(model.description);
            holdoutPercent(model.holdoutPercent);
            hook(model.hook);
            isPaused(model.isPaused);
            limits(model.limits);
            messageConfiguration(model.messageConfiguration);
            name(model.name);
            schedule(model.schedule);
            segmentId(model.segmentId);
            segmentVersion(model.segmentVersion);
            treatmentDescription(model.treatmentDescription);
            treatmentName(model.treatmentName);
        }

        public final Collection<WriteTreatmentResource.Builder> getAdditionalTreatments() {
            return additionalTreatments != null ? additionalTreatments.stream().map(WriteTreatmentResource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalTreatments(Collection<WriteTreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(WriteTreatmentResource... additionalTreatments) {
            additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder>... additionalTreatments) {
            additionalTreatments(Stream.of(additionalTreatments)
                    .map(c -> WriteTreatmentResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalTreatments(Collection<WriteTreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getHoldoutPercent() {
            return holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        public final CampaignHook.Builder getHook() {
            return hook != null ? hook.toBuilder() : null;
        }

        @Override
        public final Builder hook(CampaignHook hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(CampaignHook.BuilderImpl hook) {
            this.hook = hook != null ? hook.build() : null;
        }

        public final Boolean getIsPaused() {
            return isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        public final CampaignLimits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public final String getTreatmentDescription() {
            return treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public WriteCampaignRequest build() {
            return new WriteCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
