/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Segment definition.
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteSegmentRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteSegmentRequest.Builder, WriteSegmentRequest> {
    private static final SdkField<SegmentDimensions> DIMENSIONS_FIELD = SdkField
            .<SegmentDimensions> builder(MarshallingType.SDK_POJO).getter(getter(WriteSegmentRequest::dimensions))
            .setter(setter(Builder::dimensions)).constructor(SegmentDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteSegmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<SegmentGroupList> SEGMENT_GROUPS_FIELD = SdkField
            .<SegmentGroupList> builder(MarshallingType.SDK_POJO).getter(getter(WriteSegmentRequest::segmentGroups))
            .setter(setter(Builder::segmentGroups)).constructor(SegmentGroupList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentGroups").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, NAME_FIELD,
            SEGMENT_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SegmentDimensions dimensions;

    private final String name;

    private final SegmentGroupList segmentGroups;

    private WriteSegmentRequest(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.name = builder.name;
        this.segmentGroups = builder.segmentGroups;
    }

    /**
     * The segment dimensions attributes.
     * 
     * @return The segment dimensions attributes.
     */
    public SegmentDimensions dimensions() {
        return dimensions;
    }

    /**
     * The name of segment
     * 
     * @return The name of segment
     */
    public String name() {
        return name;
    }

    /**
     * A segment group, which consists of zero or more source segments, plus dimensions that are applied to those source
     * segments. Your request can only include one segment group. Your request can include either a SegmentGroups object
     * or a Dimensions object, but not both.
     * 
     * @return A segment group, which consists of zero or more source segments, plus dimensions that are applied to
     *         those source segments. Your request can only include one segment group. Your request can include either a
     *         SegmentGroups object or a Dimensions object, but not both.
     */
    public SegmentGroupList segmentGroups() {
        return segmentGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(segmentGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteSegmentRequest)) {
            return false;
        }
        WriteSegmentRequest other = (WriteSegmentRequest) obj;
        return Objects.equals(dimensions(), other.dimensions()) && Objects.equals(name(), other.name())
                && Objects.equals(segmentGroups(), other.segmentGroups());
    }

    @Override
    public String toString() {
        return ToString.builder("WriteSegmentRequest").add("Dimensions", dimensions()).add("Name", name())
                .add("SegmentGroups", segmentGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SegmentGroups":
            return Optional.ofNullable(clazz.cast(segmentGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteSegmentRequest, T> g) {
        return obj -> g.apply((WriteSegmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteSegmentRequest> {
        /**
         * The segment dimensions attributes.
         * 
         * @param dimensions
         *        The segment dimensions attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(SegmentDimensions dimensions);

        /**
         * The segment dimensions attributes. This is a convenience that creates an instance of the
         * {@link SegmentDimensions.Builder} avoiding the need to create one manually via
         * {@link SegmentDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(SegmentDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link SegmentDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(SegmentDimensions)
         */
        default Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return dimensions(SegmentDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * The name of segment
         * 
         * @param name
         *        The name of segment
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * A segment group, which consists of zero or more source segments, plus dimensions that are applied to those
         * source segments. Your request can only include one segment group. Your request can include either a
         * SegmentGroups object or a Dimensions object, but not both.
         * 
         * @param segmentGroups
         *        A segment group, which consists of zero or more source segments, plus dimensions that are applied to
         *        those source segments. Your request can only include one segment group. Your request can include
         *        either a SegmentGroups object or a Dimensions object, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentGroups(SegmentGroupList segmentGroups);

        /**
         * A segment group, which consists of zero or more source segments, plus dimensions that are applied to those
         * source segments. Your request can only include one segment group. Your request can include either a
         * SegmentGroups object or a Dimensions object, but not both. This is a convenience that creates an instance of
         * the {@link SegmentGroupList.Builder} avoiding the need to create one manually via
         * {@link SegmentGroupList#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentGroupList.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentGroups(SegmentGroupList)}.
         * 
         * @param segmentGroups
         *        a consumer that will call methods on {@link SegmentGroupList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentGroups(SegmentGroupList)
         */
        default Builder segmentGroups(Consumer<SegmentGroupList.Builder> segmentGroups) {
            return segmentGroups(SegmentGroupList.builder().applyMutation(segmentGroups).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SegmentDimensions dimensions;

        private String name;

        private SegmentGroupList segmentGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteSegmentRequest model) {
            dimensions(model.dimensions);
            name(model.name);
            segmentGroups(model.segmentGroups);
        }

        public final SegmentDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final SegmentGroupList.Builder getSegmentGroups() {
            return segmentGroups != null ? segmentGroups.toBuilder() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroupList segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final void setSegmentGroups(SegmentGroupList.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        @Override
        public WriteSegmentRequest build() {
            return new WriteSegmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
