/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies channel-specific content and settings for a message template that can be used in push notifications that
 * are sent through the ADM (Amazon Device Messaging), Baidu (Baidu Cloud Push), or GCM (Firebase Cloud Messaging,
 * formerly Google Cloud Messaging) channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AndroidPushNotificationTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<AndroidPushNotificationTemplate.Builder, AndroidPushNotificationTemplate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> IMAGE_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::imageIconUrl)).setter(setter(Builder::imageIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIconUrl").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()).build();

    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<String> SMALL_IMAGE_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::smallImageIconUrl)).setter(setter(Builder::smallImageIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallImageIconUrl").build()).build();

    private static final SdkField<String> SOUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::sound)).setter(setter(Builder::sound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sound").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AndroidPushNotificationTemplate::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD,
            IMAGE_ICON_URL_FIELD, IMAGE_URL_FIELD, RAW_CONTENT_FIELD, SMALL_IMAGE_ICON_URL_FIELD, SOUND_FIELD, TITLE_FIELD,
            URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String body;

    private final String imageIconUrl;

    private final String imageUrl;

    private final String rawContent;

    private final String smallImageIconUrl;

    private final String sound;

    private final String title;

    private final String url;

    private AndroidPushNotificationTemplate(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageUrl = builder.imageUrl;
        this.rawContent = builder.rawContent;
        this.smallImageIconUrl = builder.smallImageIconUrl;
        this.sound = builder.sound;
        this.title = builder.title;
        this.url = builder.url;
    }

    /**
     * <p>
     * The action to occur if a recipient taps a push notification that's based on the message template. Valid values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default
     * action.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking
     * features of the Android platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     * specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to occur if a recipient taps a push notification that's based on the message template. Valid
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
     *         default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the
     *         deep-linking features of the Android platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     *         specify.
     *         </p>
     *         </li>
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * The action to occur if a recipient taps a push notification that's based on the message template. Valid values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default
     * action.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking
     * features of the Android platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     * specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to occur if a recipient taps a push notification that's based on the message template. Valid
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
     *         default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the
     *         deep-linking features of the Android platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     *         specify.
     *         </p>
     *         </li>
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The message body to use in a push notification that's based on the message template.
     * </p>
     * 
     * @return The message body to use in a push notification that's based on the message template.
     */
    public String body() {
        return body;
    }

    /**
     * <p>
     * The URL of the large icon image to display in the content view of a push notification that's based on the message
     * template.
     * </p>
     * 
     * @return The URL of the large icon image to display in the content view of a push notification that's based on the
     *         message template.
     */
    public String imageIconUrl() {
        return imageIconUrl;
    }

    /**
     * <p>
     * The URL of an image to display in a push notification that's based on the message template.
     * </p>
     * 
     * @return The URL of an image to display in a push notification that's based on the message template.
     */
    public String imageUrl() {
        return imageUrl;
    }

    /**
     * <p>
     * The raw, JSON-formatted string to use as the payload for a push notification that's based on the message
     * template. If specified, this value overrides all other content for the message template.
     * </p>
     * 
     * @return The raw, JSON-formatted string to use as the payload for a push notification that's based on the message
     *         template. If specified, this value overrides all other content for the message template.
     */
    public String rawContent() {
        return rawContent;
    }

    /**
     * <p>
     * The URL of the small icon image to display in the status bar and the content view of a push notification that's
     * based on the message template.
     * </p>
     * 
     * @return The URL of the small icon image to display in the status bar and the content view of a push notification
     *         that's based on the message template.
     */
    public String smallImageIconUrl() {
        return smallImageIconUrl;
    }

    /**
     * <p>
     * The sound to play when a recipient receives a push notification that's based on the message template. You can use
     * the default stream or specify the file name of a sound resource that's bundled in your app. On an Android
     * platform, the sound file must reside in /res/raw/.
     * </p>
     * 
     * @return The sound to play when a recipient receives a push notification that's based on the message template. You
     *         can use the default stream or specify the file name of a sound resource that's bundled in your app. On an
     *         Android platform, the sound file must reside in /res/raw/.
     */
    public String sound() {
        return sound;
    }

    /**
     * <p>
     * The title to use in a push notification that's based on the message template. This title appears above the
     * notification message on a recipient's device.
     * </p>
     * 
     * @return The title to use in a push notification that's based on the message template. This title appears above
     *         the notification message on a recipient's device.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The URL to open in a recipient's default mobile browser, if a recipient taps a a push notification that's based
     * on the message template and the value of the Action property is URL.
     * </p>
     * 
     * @return The URL to open in a recipient's default mobile browser, if a recipient taps a a push notification that's
     *         based on the message template and the value of the Action property is URL.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(smallImageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sound());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AndroidPushNotificationTemplate)) {
            return false;
        }
        AndroidPushNotificationTemplate other = (AndroidPushNotificationTemplate) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(body(), other.body())
                && Objects.equals(imageIconUrl(), other.imageIconUrl()) && Objects.equals(imageUrl(), other.imageUrl())
                && Objects.equals(rawContent(), other.rawContent())
                && Objects.equals(smallImageIconUrl(), other.smallImageIconUrl()) && Objects.equals(sound(), other.sound())
                && Objects.equals(title(), other.title()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AndroidPushNotificationTemplate").add("Action", actionAsString()).add("Body", body())
                .add("ImageIconUrl", imageIconUrl()).add("ImageUrl", imageUrl()).add("RawContent", rawContent())
                .add("SmallImageIconUrl", smallImageIconUrl()).add("Sound", sound()).add("Title", title()).add("Url", url())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "ImageIconUrl":
            return Optional.ofNullable(clazz.cast(imageIconUrl()));
        case "ImageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "SmallImageIconUrl":
            return Optional.ofNullable(clazz.cast(smallImageIconUrl()));
        case "Sound":
            return Optional.ofNullable(clazz.cast(sound()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AndroidPushNotificationTemplate, T> g) {
        return obj -> g.apply((AndroidPushNotificationTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AndroidPushNotificationTemplate> {
        /**
         * <p>
         * The action to occur if a recipient taps a push notification that's based on the message template. Valid
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the
         * deep-linking features of the Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
         * specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to occur if a recipient taps a push notification that's based on the message template.
         *        Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is
         *        the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the
         *        deep-linking features of the Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that
         *        you specify.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * The action to occur if a recipient taps a push notification that's based on the message template. Valid
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the
         * deep-linking features of the Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
         * specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to occur if a recipient taps a push notification that's based on the message template.
         *        Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is
         *        the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the
         *        deep-linking features of the Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that
         *        you specify.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * The message body to use in a push notification that's based on the message template.
         * </p>
         * 
         * @param body
         *        The message body to use in a push notification that's based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The URL of the large icon image to display in the content view of a push notification that's based on the
         * message template.
         * </p>
         * 
         * @param imageIconUrl
         *        The URL of the large icon image to display in the content view of a push notification that's based on
         *        the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIconUrl(String imageIconUrl);

        /**
         * <p>
         * The URL of an image to display in a push notification that's based on the message template.
         * </p>
         * 
         * @param imageUrl
         *        The URL of an image to display in a push notification that's based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * <p>
         * The raw, JSON-formatted string to use as the payload for a push notification that's based on the message
         * template. If specified, this value overrides all other content for the message template.
         * </p>
         * 
         * @param rawContent
         *        The raw, JSON-formatted string to use as the payload for a push notification that's based on the
         *        message template. If specified, this value overrides all other content for the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(String rawContent);

        /**
         * <p>
         * The URL of the small icon image to display in the status bar and the content view of a push notification
         * that's based on the message template.
         * </p>
         * 
         * @param smallImageIconUrl
         *        The URL of the small icon image to display in the status bar and the content view of a push
         *        notification that's based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallImageIconUrl(String smallImageIconUrl);

        /**
         * <p>
         * The sound to play when a recipient receives a push notification that's based on the message template. You can
         * use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android
         * platform, the sound file must reside in /res/raw/.
         * </p>
         * 
         * @param sound
         *        The sound to play when a recipient receives a push notification that's based on the message template.
         *        You can use the default stream or specify the file name of a sound resource that's bundled in your
         *        app. On an Android platform, the sound file must reside in /res/raw/.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sound(String sound);

        /**
         * <p>
         * The title to use in a push notification that's based on the message template. This title appears above the
         * notification message on a recipient's device.
         * </p>
         * 
         * @param title
         *        The title to use in a push notification that's based on the message template. This title appears above
         *        the notification message on a recipient's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The URL to open in a recipient's default mobile browser, if a recipient taps a a push notification that's
         * based on the message template and the value of the Action property is URL.
         * </p>
         * 
         * @param url
         *        The URL to open in a recipient's default mobile browser, if a recipient taps a a push notification
         *        that's based on the message template and the value of the Action property is URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String body;

        private String imageIconUrl;

        private String imageUrl;

        private String rawContent;

        private String smallImageIconUrl;

        private String sound;

        private String title;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(AndroidPushNotificationTemplate model) {
            action(model.action);
            body(model.body);
            imageIconUrl(model.imageIconUrl);
            imageUrl(model.imageUrl);
            rawContent(model.rawContent);
            smallImageIconUrl(model.smallImageIconUrl);
            sound(model.sound);
            title(model.title);
            url(model.url);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getImageIconUrl() {
            return imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getRawContent() {
            return rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final String getSmallImageIconUrl() {
            return smallImageIconUrl;
        }

        @Override
        public final Builder smallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
            return this;
        }

        public final void setSmallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
        }

        public final String getSound() {
            return sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public AndroidPushNotificationTemplate build() {
            return new AndroidPushNotificationTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
