/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a request to create a message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTemplateMessageBody implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateTemplateMessageBody.Builder, CreateTemplateMessageBody> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTemplateMessageBody::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTemplateMessageBody::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTemplateMessageBody::requestID)).setter(setter(Builder::requestID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MESSAGE_FIELD,
            REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String message;

    private final String requestID;

    private CreateTemplateMessageBody(BuilderImpl builder) {
        this.arn = builder.arn;
        this.message = builder.message;
        this.requestID = builder.requestID;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the message template that was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the message template that was created.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The message that's returned from the API for the request to create the message template.
     * </p>
     * 
     * @return The message that's returned from the API for the request to create the message template.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The unique identifier for the request to create the message template.
     * </p>
     * 
     * @return The unique identifier for the request to create the message template.
     */
    public String requestID() {
        return requestID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(requestID());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateMessageBody)) {
            return false;
        }
        CreateTemplateMessageBody other = (CreateTemplateMessageBody) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(message(), other.message())
                && Objects.equals(requestID(), other.requestID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTemplateMessageBody").add("Arn", arn()).add("Message", message())
                .add("RequestID", requestID()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "RequestID":
            return Optional.ofNullable(clazz.cast(requestID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateMessageBody, T> g) {
        return obj -> g.apply((CreateTemplateMessageBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateTemplateMessageBody> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the message template that was created.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the message template that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The message that's returned from the API for the request to create the message template.
         * </p>
         * 
         * @param message
         *        The message that's returned from the API for the request to create the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The unique identifier for the request to create the message template.
         * </p>
         * 
         * @param requestID
         *        The unique identifier for the request to create the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestID(String requestID);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String message;

        private String requestID;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateMessageBody model) {
            arn(model.arn);
            message(model.message);
            requestID(model.requestID);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getRequestID() {
            return requestID;
        }

        @Override
        public final Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public final void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        @Override
        public CreateTemplateMessageBody build() {
            return new CreateTemplateMessageBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
