/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGcmChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteGcmChannelResponse.Builder, DeleteGcmChannelResponse> {
    private static final SdkField<GCMChannelResponse> GCM_CHANNEL_RESPONSE_FIELD = SdkField
            .<GCMChannelResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteGcmChannelResponse::gcmChannelResponse))
            .setter(setter(Builder::gcmChannelResponse))
            .constructor(GCMChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCMChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GCM_CHANNEL_RESPONSE_FIELD));

    private final GCMChannelResponse gcmChannelResponse;

    private DeleteGcmChannelResponse(BuilderImpl builder) {
        super(builder);
        this.gcmChannelResponse = builder.gcmChannelResponse;
    }

    /**
     * Returns the value of the GCMChannelResponse property for this object.
     * 
     * @return The value of the GCMChannelResponse property for this object.
     */
    public GCMChannelResponse gcmChannelResponse() {
        return gcmChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gcmChannelResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGcmChannelResponse)) {
            return false;
        }
        DeleteGcmChannelResponse other = (DeleteGcmChannelResponse) obj;
        return Objects.equals(gcmChannelResponse(), other.gcmChannelResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteGcmChannelResponse").add("GCMChannelResponse", gcmChannelResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GCMChannelResponse":
            return Optional.ofNullable(clazz.cast(gcmChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteGcmChannelResponse, T> g) {
        return obj -> g.apply((DeleteGcmChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGcmChannelResponse> {
        /**
         * Sets the value of the GCMChannelResponse property for this object.
         *
         * @param gcmChannelResponse
         *        The new value for the GCMChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcmChannelResponse(GCMChannelResponse gcmChannelResponse);

        /**
         * Sets the value of the GCMChannelResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link GCMChannelResponse.Builder} avoiding the need to
         * create one manually via {@link GCMChannelResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link GCMChannelResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #gcmChannelResponse(GCMChannelResponse)}.
         * 
         * @param gcmChannelResponse
         *        a consumer that will call methods on {@link GCMChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gcmChannelResponse(GCMChannelResponse)
         */
        default Builder gcmChannelResponse(Consumer<GCMChannelResponse.Builder> gcmChannelResponse) {
            return gcmChannelResponse(GCMChannelResponse.builder().applyMutation(gcmChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private GCMChannelResponse gcmChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGcmChannelResponse model) {
            super(model);
            gcmChannelResponse(model.gcmChannelResponse);
        }

        public final GCMChannelResponse.Builder getGcmChannelResponse() {
            return gcmChannelResponse != null ? gcmChannelResponse.toBuilder() : null;
        }

        @Override
        public final Builder gcmChannelResponse(GCMChannelResponse gcmChannelResponse) {
            this.gcmChannelResponse = gcmChannelResponse;
            return this;
        }

        public final void setGcmChannelResponse(GCMChannelResponse.BuilderImpl gcmChannelResponse) {
            this.gcmChannelResponse = gcmChannelResponse != null ? gcmChannelResponse.build() : null;
        }

        @Override
        public DeleteGcmChannelResponse build() {
            return new DeleteGcmChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
