/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content, including message variables and attributes, to use in a message that's sent directly to an
 * endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointSendConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointSendConfiguration.Builder, EndpointSendConfiguration> {
    private static final SdkField<String> BODY_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointSendConfiguration::bodyOverride)).setter(setter(Builder::bodyOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyOverride").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(EndpointSendConfiguration::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointSendConfiguration::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(EndpointSendConfiguration::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TITLE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointSendConfiguration::titleOverride)).setter(setter(Builder::titleOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_OVERRIDE_FIELD,
            CONTEXT_FIELD, RAW_CONTENT_FIELD, SUBSTITUTIONS_FIELD, TITLE_OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bodyOverride;

    private final Map<String, String> context;

    private final String rawContent;

    private final Map<String, List<String>> substitutions;

    private final String titleOverride;

    private EndpointSendConfiguration(BuilderImpl builder) {
        this.bodyOverride = builder.bodyOverride;
        this.context = builder.context;
        this.rawContent = builder.rawContent;
        this.substitutions = builder.substitutions;
        this.titleOverride = builder.titleOverride;
    }

    /**
     * <p>
     * The body of the message. If specified, this value overrides the default message body.
     * </p>
     * 
     * @return The body of the message. If specified, this value overrides the default message body.
     */
    public String bodyOverride() {
        return bodyOverride;
    }

    /**
     * <p>
     * A map of custom attributes to attach to the message for the address. For a push notification, this payload is
     * added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery
     * receipt event attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of custom attributes to attach to the message for the address. For a push notification, this
     *         payload is added to the data.pinpoint object. For an email or text message, this payload is added to
     *         email/SMS delivery receipt event attributes.
     */
    public Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all
     * other values for the message.
     * </p>
     * 
     * @return The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides
     *         all other values for the message.
     */
    public String rawContent() {
        return rawContent;
    }

    /**
     * <p>
     * A map of the message variables to merge with the variables specified for the default message
     * (DefaultMessage.Substitutions). The variables specified in this map take precedence over all other variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of the message variables to merge with the variables specified for the default message
     *         (DefaultMessage.Substitutions). The variables specified in this map take precedence over all other
     *         variables.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * <p>
     * The title or subject line of the message. If specified, this value overrides the default message title or subject
     * line.
     * </p>
     * 
     * @return The title or subject line of the message. If specified, this value overrides the default message title or
     *         subject line.
     */
    public String titleOverride() {
        return titleOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bodyOverride());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(titleOverride());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointSendConfiguration)) {
            return false;
        }
        EndpointSendConfiguration other = (EndpointSendConfiguration) obj;
        return Objects.equals(bodyOverride(), other.bodyOverride()) && Objects.equals(context(), other.context())
                && Objects.equals(rawContent(), other.rawContent()) && Objects.equals(substitutions(), other.substitutions())
                && Objects.equals(titleOverride(), other.titleOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EndpointSendConfiguration").add("BodyOverride", bodyOverride()).add("Context", context())
                .add("RawContent", rawContent()).add("Substitutions", substitutions()).add("TitleOverride", titleOverride())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BodyOverride":
            return Optional.ofNullable(clazz.cast(bodyOverride()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "TitleOverride":
            return Optional.ofNullable(clazz.cast(titleOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointSendConfiguration, T> g) {
        return obj -> g.apply((EndpointSendConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointSendConfiguration> {
        /**
         * <p>
         * The body of the message. If specified, this value overrides the default message body.
         * </p>
         * 
         * @param bodyOverride
         *        The body of the message. If specified, this value overrides the default message body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodyOverride(String bodyOverride);

        /**
         * <p>
         * A map of custom attributes to attach to the message for the address. For a push notification, this payload is
         * added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery
         * receipt event attributes.
         * </p>
         * 
         * @param context
         *        A map of custom attributes to attach to the message for the address. For a push notification, this
         *        payload is added to the data.pinpoint object. For an email or text message, this payload is added to
         *        email/SMS delivery receipt event attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all
         * other values for the message.
         * </p>
         * 
         * @param rawContent
         *        The raw, JSON-formatted string to use as the payload for the message. If specified, this value
         *        overrides all other values for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(String rawContent);

        /**
         * <p>
         * A map of the message variables to merge with the variables specified for the default message
         * (DefaultMessage.Substitutions). The variables specified in this map take precedence over all other variables.
         * </p>
         * 
         * @param substitutions
         *        A map of the message variables to merge with the variables specified for the default message
         *        (DefaultMessage.Substitutions). The variables specified in this map take precedence over all other
         *        variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * <p>
         * The title or subject line of the message. If specified, this value overrides the default message title or
         * subject line.
         * </p>
         * 
         * @param titleOverride
         *        The title or subject line of the message. If specified, this value overrides the default message title
         *        or subject line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleOverride(String titleOverride);
    }

    static final class BuilderImpl implements Builder {
        private String bodyOverride;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private String rawContent;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private String titleOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointSendConfiguration model) {
            bodyOverride(model.bodyOverride);
            context(model.context);
            rawContent(model.rawContent);
            substitutions(model.substitutions);
            titleOverride(model.titleOverride);
        }

        public final String getBodyOverride() {
            return bodyOverride;
        }

        @Override
        public final Builder bodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
            return this;
        }

        public final void setBodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
        }

        public final Map<String, String> getContext() {
            return context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final String getRawContent() {
            return rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitleOverride() {
            return titleOverride;
        }

        @Override
        public final Builder titleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
            return this;
        }

        public final void setTitleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
        }

        @Override
        public EndpointSendConfiguration build() {
            return new EndpointSendConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
