/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCampaignActivitiesResponse extends PinpointResponse implements
        ToCopyableBuilder<GetCampaignActivitiesResponse.Builder, GetCampaignActivitiesResponse> {
    private static final SdkField<ActivitiesResponse> ACTIVITIES_RESPONSE_FIELD = SdkField
            .<ActivitiesResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetCampaignActivitiesResponse::activitiesResponse))
            .setter(setter(Builder::activitiesResponse))
            .constructor(ActivitiesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivitiesResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITIES_RESPONSE_FIELD));

    private final ActivitiesResponse activitiesResponse;

    private GetCampaignActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.activitiesResponse = builder.activitiesResponse;
    }

    /**
     * Returns the value of the ActivitiesResponse property for this object.
     * 
     * @return The value of the ActivitiesResponse property for this object.
     */
    public ActivitiesResponse activitiesResponse() {
        return activitiesResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activitiesResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignActivitiesResponse)) {
            return false;
        }
        GetCampaignActivitiesResponse other = (GetCampaignActivitiesResponse) obj;
        return Objects.equals(activitiesResponse(), other.activitiesResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCampaignActivitiesResponse").add("ActivitiesResponse", activitiesResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivitiesResponse":
            return Optional.ofNullable(clazz.cast(activitiesResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignActivitiesResponse, T> g) {
        return obj -> g.apply((GetCampaignActivitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCampaignActivitiesResponse> {
        /**
         * Sets the value of the ActivitiesResponse property for this object.
         *
         * @param activitiesResponse
         *        The new value for the ActivitiesResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activitiesResponse(ActivitiesResponse activitiesResponse);

        /**
         * Sets the value of the ActivitiesResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link ActivitiesResponse.Builder} avoiding the need to
         * create one manually via {@link ActivitiesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivitiesResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #activitiesResponse(ActivitiesResponse)}.
         * 
         * @param activitiesResponse
         *        a consumer that will call methods on {@link ActivitiesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activitiesResponse(ActivitiesResponse)
         */
        default Builder activitiesResponse(Consumer<ActivitiesResponse.Builder> activitiesResponse) {
            return activitiesResponse(ActivitiesResponse.builder().applyMutation(activitiesResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ActivitiesResponse activitiesResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignActivitiesResponse model) {
            super(model);
            activitiesResponse(model.activitiesResponse);
        }

        public final ActivitiesResponse.Builder getActivitiesResponse() {
            return activitiesResponse != null ? activitiesResponse.toBuilder() : null;
        }

        @Override
        public final Builder activitiesResponse(ActivitiesResponse activitiesResponse) {
            this.activitiesResponse = activitiesResponse;
            return this;
        }

        public final void setActivitiesResponse(ActivitiesResponse.BuilderImpl activitiesResponse) {
            this.activitiesResponse = activitiesResponse != null ? activitiesResponse.build() : null;
        }

        @Override
        public GetCampaignActivitiesResponse build() {
            return new GetCampaignActivitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
