/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a holdout activity in a journey. This type of activity stops a journey for a specified
 * percentage of participants.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HoldoutActivity implements SdkPojo, Serializable, ToCopyableBuilder<HoldoutActivity.Builder, HoldoutActivity> {
    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HoldoutActivity::nextActivity)).setter(setter(Builder::nextActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()).build();

    private static final SdkField<Integer> PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HoldoutActivity::percentage)).setter(setter(Builder::percentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_ACTIVITY_FIELD,
            PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nextActivity;

    private final Integer percentage;

    private HoldoutActivity(BuilderImpl builder) {
        this.nextActivity = builder.nextActivity;
        this.percentage = builder.percentage;
    }

    /**
     * <p>
     * The unique identifier for the next activity to perform, after performing the holdout activity.
     * </p>
     * 
     * @return The unique identifier for the next activity to perform, after performing the holdout activity.
     */
    public String nextActivity() {
        return nextActivity;
    }

    /**
     * <p>
     * The percentage of participants who shouldn't continue the journey.
     * </p>
     * 
     * @return The percentage of participants who shouldn't continue the journey.
     */
    public Integer percentage() {
        return percentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextActivity());
        hashCode = 31 * hashCode + Objects.hashCode(percentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoldoutActivity)) {
            return false;
        }
        HoldoutActivity other = (HoldoutActivity) obj;
        return Objects.equals(nextActivity(), other.nextActivity()) && Objects.equals(percentage(), other.percentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HoldoutActivity").add("NextActivity", nextActivity()).add("Percentage", percentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextActivity":
            return Optional.ofNullable(clazz.cast(nextActivity()));
        case "Percentage":
            return Optional.ofNullable(clazz.cast(percentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HoldoutActivity, T> g) {
        return obj -> g.apply((HoldoutActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HoldoutActivity> {
        /**
         * <p>
         * The unique identifier for the next activity to perform, after performing the holdout activity.
         * </p>
         * 
         * @param nextActivity
         *        The unique identifier for the next activity to perform, after performing the holdout activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextActivity(String nextActivity);

        /**
         * <p>
         * The percentage of participants who shouldn't continue the journey.
         * </p>
         * 
         * @param percentage
         *        The percentage of participants who shouldn't continue the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentage(Integer percentage);
    }

    static final class BuilderImpl implements Builder {
        private String nextActivity;

        private Integer percentage;

        private BuilderImpl() {
        }

        private BuilderImpl(HoldoutActivity model) {
            nextActivity(model.nextActivity);
            percentage(model.percentage);
        }

        public final String getNextActivity() {
            return nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        public final Integer getPercentage() {
            return percentage;
        }

        @Override
        public final Builder percentage(Integer percentage) {
            this.percentage = percentage;
            return this;
        }

        public final void setPercentage(Integer percentage) {
            this.percentage = percentage;
        }

        @Override
        public HoldoutActivity build() {
            return new HoldoutActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
