/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content and settings for a push notification that's sent to recipients of a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> IMAGE_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::imageIconUrl)).setter(setter(Builder::imageIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIconUrl").build()).build();

    private static final SdkField<String> IMAGE_SMALL_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::imageSmallIconUrl)).setter(setter(Builder::imageSmallIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSmallIconUrl").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()).build();

    private static final SdkField<String> JSON_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::jsonBody)).setter(setter(Builder::jsonBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonBody").build()).build();

    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::mediaUrl)).setter(setter(Builder::mediaUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()).build();

    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Message::silentPush)).setter(setter(Builder::silentPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Message::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD,
            IMAGE_ICON_URL_FIELD, IMAGE_SMALL_ICON_URL_FIELD, IMAGE_URL_FIELD, JSON_BODY_FIELD, MEDIA_URL_FIELD,
            RAW_CONTENT_FIELD, SILENT_PUSH_FIELD, TIME_TO_LIVE_FIELD, TITLE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String body;

    private final String imageIconUrl;

    private final String imageSmallIconUrl;

    private final String imageUrl;

    private final String jsonBody;

    private final String mediaUrl;

    private final String rawContent;

    private final Boolean silentPush;

    private final Integer timeToLive;

    private final String title;

    private final String url;

    private Message(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageSmallIconUrl = builder.imageSmallIconUrl;
        this.imageUrl = builder.imageUrl;
        this.jsonBody = builder.jsonBody;
        this.mediaUrl = builder.mediaUrl;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    /**
     * <p>
     * The action to occur if a recipient taps the push notification. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default
     * action.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     * deep-linking features of iOS and Android.
     * </p>
     * </li>
     * <li>
     * <p>
     * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     * specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to occur if a recipient taps the push notification. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
     *         default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     *         deep-linking features of iOS and Android.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     *         specify.
     *         </p>
     *         </li>
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * The action to occur if a recipient taps the push notification. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default
     * action.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     * deep-linking features of iOS and Android.
     * </p>
     * </li>
     * <li>
     * <p>
     * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     * specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to occur if a recipient taps the push notification. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
     *         default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     *         deep-linking features of iOS and Android.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     *         specify.
     *         </p>
     *         </li>
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The body of the notification message. The maximum number of characters is 200.
     * </p>
     * 
     * @return The body of the notification message. The maximum number of characters is 200.
     */
    public String body() {
        return body;
    }

    /**
     * <p>
     * The URL of the image to display as the push-notification icon, such as the icon for the app.
     * </p>
     * 
     * @return The URL of the image to display as the push-notification icon, such as the icon for the app.
     */
    public String imageIconUrl() {
        return imageIconUrl;
    }

    /**
     * <p>
     * The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the
     * app.
     * </p>
     * 
     * @return The URL of the image to display as the small, push-notification icon, such as a small version of the icon
     *         for the app.
     */
    public String imageSmallIconUrl() {
        return imageSmallIconUrl;
    }

    /**
     * <p>
     * The URL of an image to display in the push notification.
     * </p>
     * 
     * @return The URL of an image to display in the push notification.
     */
    public String imageUrl() {
        return imageUrl;
    }

    /**
     * <p>
     * The JSON payload to use for a silent push notification.
     * </p>
     * 
     * @return The JSON payload to use for a silent push notification.
     */
    public String jsonBody() {
        return jsonBody;
    }

    /**
     * <p>
     * The URL of the image or video to display in the push notification.
     * </p>
     * 
     * @return The URL of the image or video to display in the push notification.
     */
    public String mediaUrl() {
        return mediaUrl;
    }

    /**
     * <p>
     * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value
     * overrides all other content for the message.
     * </p>
     * 
     * @return The raw, JSON-formatted string to use as the payload for the notification message. If specified, this
     *         value overrides all other content for the message.
     */
    public String rawContent() {
        return rawContent;
    }

    /**
     * <p>
     * Specifies whether the notification is a silent push notification, which is a push notification that doesn't
     * display on a recipient's device. Silent push notifications can be used for cases such as updating an app's
     * configuration, displaying messages in an in-app message center, or supporting phone home functionality.
     * </p>
     * 
     * @return Specifies whether the notification is a silent push notification, which is a push notification that
     *         doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating
     *         an app's configuration, displaying messages in an in-app message center, or supporting phone home
     *         functionality.
     */
    public Boolean silentPush() {
        return silentPush;
    }

    /**
     * <p>
     * The number of seconds that the push-notification service should keep the message, if the service is unable to
     * deliver the notification the first time. This value is converted to an expiration value when it's sent to a
     * push-notification service. If this value is 0, the service treats the notification as if it expires immediately
     * and the service doesn't store or try to deliver the notification again.
     * </p>
     * <p>
     * This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
     * </p>
     * 
     * @return The number of seconds that the push-notification service should keep the message, if the service is
     *         unable to deliver the notification the first time. This value is converted to an expiration value when
     *         it's sent to a push-notification service. If this value is 0, the service treats the notification as if
     *         it expires immediately and the service doesn't store or try to deliver the notification again.</p>
     *         <p>
     *         This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
     */
    public Integer timeToLive() {
        return timeToLive;
    }

    /**
     * <p>
     * The title to display above the notification message on a recipient's device.
     * </p>
     * 
     * @return The title to display above the notification message on a recipient's device.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value
     * of the Action property is URL.
     * </p>
     * 
     * @return The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and
     *         the value of the Action property is URL.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(imageSmallIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(jsonBody());
        hashCode = 31 * hashCode + Objects.hashCode(mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(body(), other.body())
                && Objects.equals(imageIconUrl(), other.imageIconUrl())
                && Objects.equals(imageSmallIconUrl(), other.imageSmallIconUrl()) && Objects.equals(imageUrl(), other.imageUrl())
                && Objects.equals(jsonBody(), other.jsonBody()) && Objects.equals(mediaUrl(), other.mediaUrl())
                && Objects.equals(rawContent(), other.rawContent()) && Objects.equals(silentPush(), other.silentPush())
                && Objects.equals(timeToLive(), other.timeToLive()) && Objects.equals(title(), other.title())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Message").add("Action", actionAsString()).add("Body", body())
                .add("ImageIconUrl", imageIconUrl()).add("ImageSmallIconUrl", imageSmallIconUrl()).add("ImageUrl", imageUrl())
                .add("JsonBody", jsonBody()).add("MediaUrl", mediaUrl()).add("RawContent", rawContent())
                .add("SilentPush", silentPush()).add("TimeToLive", timeToLive()).add("Title", title()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "ImageIconUrl":
            return Optional.ofNullable(clazz.cast(imageIconUrl()));
        case "ImageSmallIconUrl":
            return Optional.ofNullable(clazz.cast(imageSmallIconUrl()));
        case "ImageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "JsonBody":
            return Optional.ofNullable(clazz.cast(jsonBody()));
        case "MediaUrl":
            return Optional.ofNullable(clazz.cast(mediaUrl()));
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "SilentPush":
            return Optional.ofNullable(clazz.cast(silentPush()));
        case "TimeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The action to occur if a recipient taps the push notification. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         * deep-linking features of iOS and Android.
         * </p>
         * </li>
         * <li>
         * <p>
         * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
         * specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to occur if a recipient taps the push notification. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is
         *        the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         *        deep-linking features of iOS and Android.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that
         *        you specify.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * The action to occur if a recipient taps the push notification. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         * deep-linking features of iOS and Android.
         * </p>
         * </li>
         * <li>
         * <p>
         * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
         * specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to occur if a recipient taps the push notification. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is
         *        the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         *        deep-linking features of iOS and Android.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that
         *        you specify.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * The body of the notification message. The maximum number of characters is 200.
         * </p>
         * 
         * @param body
         *        The body of the notification message. The maximum number of characters is 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The URL of the image to display as the push-notification icon, such as the icon for the app.
         * </p>
         * 
         * @param imageIconUrl
         *        The URL of the image to display as the push-notification icon, such as the icon for the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIconUrl(String imageIconUrl);

        /**
         * <p>
         * The URL of the image to display as the small, push-notification icon, such as a small version of the icon for
         * the app.
         * </p>
         * 
         * @param imageSmallIconUrl
         *        The URL of the image to display as the small, push-notification icon, such as a small version of the
         *        icon for the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSmallIconUrl(String imageSmallIconUrl);

        /**
         * <p>
         * The URL of an image to display in the push notification.
         * </p>
         * 
         * @param imageUrl
         *        The URL of an image to display in the push notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * <p>
         * The JSON payload to use for a silent push notification.
         * </p>
         * 
         * @param jsonBody
         *        The JSON payload to use for a silent push notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonBody(String jsonBody);

        /**
         * <p>
         * The URL of the image or video to display in the push notification.
         * </p>
         * 
         * @param mediaUrl
         *        The URL of the image or video to display in the push notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUrl(String mediaUrl);

        /**
         * <p>
         * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value
         * overrides all other content for the message.
         * </p>
         * 
         * @param rawContent
         *        The raw, JSON-formatted string to use as the payload for the notification message. If specified, this
         *        value overrides all other content for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(String rawContent);

        /**
         * <p>
         * Specifies whether the notification is a silent push notification, which is a push notification that doesn't
         * display on a recipient's device. Silent push notifications can be used for cases such as updating an app's
         * configuration, displaying messages in an in-app message center, or supporting phone home functionality.
         * </p>
         * 
         * @param silentPush
         *        Specifies whether the notification is a silent push notification, which is a push notification that
         *        doesn't display on a recipient's device. Silent push notifications can be used for cases such as
         *        updating an app's configuration, displaying messages in an in-app message center, or supporting phone
         *        home functionality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silentPush(Boolean silentPush);

        /**
         * <p>
         * The number of seconds that the push-notification service should keep the message, if the service is unable to
         * deliver the notification the first time. This value is converted to an expiration value when it's sent to a
         * push-notification service. If this value is 0, the service treats the notification as if it expires
         * immediately and the service doesn't store or try to deliver the notification again.
         * </p>
         * <p>
         * This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
         * </p>
         * 
         * @param timeToLive
         *        The number of seconds that the push-notification service should keep the message, if the service is
         *        unable to deliver the notification the first time. This value is converted to an expiration value when
         *        it's sent to a push-notification service. If this value is 0, the service treats the notification as
         *        if it expires immediately and the service doesn't store or try to deliver the notification again.</p>
         *        <p>
         *        This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Integer timeToLive);

        /**
         * <p>
         * The title to display above the notification message on a recipient's device.
         * </p>
         * 
         * @param title
         *        The title to display above the notification message on a recipient's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the
         * value of the Action property is URL.
         * </p>
         * 
         * @param url
         *        The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and
         *        the value of the Action property is URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String body;

        private String imageIconUrl;

        private String imageSmallIconUrl;

        private String imageUrl;

        private String jsonBody;

        private String mediaUrl;

        private String rawContent;

        private Boolean silentPush;

        private Integer timeToLive;

        private String title;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            action(model.action);
            body(model.body);
            imageIconUrl(model.imageIconUrl);
            imageSmallIconUrl(model.imageSmallIconUrl);
            imageUrl(model.imageUrl);
            jsonBody(model.jsonBody);
            mediaUrl(model.mediaUrl);
            rawContent(model.rawContent);
            silentPush(model.silentPush);
            timeToLive(model.timeToLive);
            title(model.title);
            url(model.url);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getImageIconUrl() {
            return imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        public final String getImageSmallIconUrl() {
            return imageSmallIconUrl;
        }

        @Override
        public final Builder imageSmallIconUrl(String imageSmallIconUrl) {
            this.imageSmallIconUrl = imageSmallIconUrl;
            return this;
        }

        public final void setImageSmallIconUrl(String imageSmallIconUrl) {
            this.imageSmallIconUrl = imageSmallIconUrl;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getJsonBody() {
            return jsonBody;
        }

        @Override
        public final Builder jsonBody(String jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public final void setJsonBody(String jsonBody) {
            this.jsonBody = jsonBody;
        }

        public final String getMediaUrl() {
            return mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public final String getRawContent() {
            return rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final Integer getTimeToLive() {
            return timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
