/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a multivariate split activity in a journey. This type of activity sends participants down
 * one of as many as five paths in a journey, based on conditions that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiConditionalSplitActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiConditionalSplitActivity.Builder, MultiConditionalSplitActivity> {
    private static final SdkField<List<MultiConditionalBranch>> BRANCHES_FIELD = SdkField
            .<List<MultiConditionalBranch>> builder(MarshallingType.LIST)
            .getter(getter(MultiConditionalSplitActivity::branches))
            .setter(setter(Builder::branches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiConditionalBranch> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiConditionalBranch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MultiConditionalSplitActivity::defaultActivity)).setter(setter(Builder::defaultActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActivity").build()).build();

    private static final SdkField<WaitTime> EVALUATION_WAIT_TIME_FIELD = SdkField.<WaitTime> builder(MarshallingType.SDK_POJO)
            .getter(getter(MultiConditionalSplitActivity::evaluationWaitTime)).setter(setter(Builder::evaluationWaitTime))
            .constructor(WaitTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationWaitTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCHES_FIELD,
            DEFAULT_ACTIVITY_FIELD, EVALUATION_WAIT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MultiConditionalBranch> branches;

    private final String defaultActivity;

    private final WaitTime evaluationWaitTime;

    private MultiConditionalSplitActivity(BuilderImpl builder) {
        this.branches = builder.branches;
        this.defaultActivity = builder.defaultActivity;
        this.evaluationWaitTime = builder.evaluationWaitTime;
    }

    /**
     * <p>
     * The paths for the activity, including the conditions for entering each path and the activity to perform for each
     * path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The paths for the activity, including the conditions for entering each path and the activity to perform
     *         for each path.
     */
    public List<MultiConditionalBranch> branches() {
        return branches;
    }

    /**
     * <p>
     * The activity to perform by default for any path in the activity.
     * </p>
     * 
     * @return The activity to perform by default for any path in the activity.
     */
    public String defaultActivity() {
        return defaultActivity;
    }

    /**
     * <p>
     * The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.
     * </p>
     * 
     * @return The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions
     *         are met.
     */
    public WaitTime evaluationWaitTime() {
        return evaluationWaitTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branches());
        hashCode = 31 * hashCode + Objects.hashCode(defaultActivity());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationWaitTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiConditionalSplitActivity)) {
            return false;
        }
        MultiConditionalSplitActivity other = (MultiConditionalSplitActivity) obj;
        return Objects.equals(branches(), other.branches()) && Objects.equals(defaultActivity(), other.defaultActivity())
                && Objects.equals(evaluationWaitTime(), other.evaluationWaitTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MultiConditionalSplitActivity").add("Branches", branches())
                .add("DefaultActivity", defaultActivity()).add("EvaluationWaitTime", evaluationWaitTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Branches":
            return Optional.ofNullable(clazz.cast(branches()));
        case "DefaultActivity":
            return Optional.ofNullable(clazz.cast(defaultActivity()));
        case "EvaluationWaitTime":
            return Optional.ofNullable(clazz.cast(evaluationWaitTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiConditionalSplitActivity, T> g) {
        return obj -> g.apply((MultiConditionalSplitActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiConditionalSplitActivity> {
        /**
         * <p>
         * The paths for the activity, including the conditions for entering each path and the activity to perform for
         * each path.
         * </p>
         * 
         * @param branches
         *        The paths for the activity, including the conditions for entering each path and the activity to
         *        perform for each path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(Collection<MultiConditionalBranch> branches);

        /**
         * <p>
         * The paths for the activity, including the conditions for entering each path and the activity to perform for
         * each path.
         * </p>
         * 
         * @param branches
         *        The paths for the activity, including the conditions for entering each path and the activity to
         *        perform for each path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(MultiConditionalBranch... branches);

        /**
         * <p>
         * The paths for the activity, including the conditions for entering each path and the activity to perform for
         * each path.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MultiConditionalBranch>.Builder} avoiding
         * the need to create one manually via {@link List<MultiConditionalBranch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MultiConditionalBranch>.Builder#build()} is called
         * immediately and its result is passed to {@link #branches(List<MultiConditionalBranch>)}.
         * 
         * @param branches
         *        a consumer that will call methods on {@link List<MultiConditionalBranch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branches(List<MultiConditionalBranch>)
         */
        Builder branches(Consumer<MultiConditionalBranch.Builder>... branches);

        /**
         * <p>
         * The activity to perform by default for any path in the activity.
         * </p>
         * 
         * @param defaultActivity
         *        The activity to perform by default for any path in the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultActivity(String defaultActivity);

        /**
         * <p>
         * The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are
         * met.
         * </p>
         * 
         * @param evaluationWaitTime
         *        The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions
         *        are met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationWaitTime(WaitTime evaluationWaitTime);

        /**
         * <p>
         * The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are
         * met.
         * </p>
         * This is a convenience that creates an instance of the {@link WaitTime.Builder} avoiding the need to create
         * one manually via {@link WaitTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link WaitTime.Builder#build()} is called immediately and its result is
         * passed to {@link #evaluationWaitTime(WaitTime)}.
         * 
         * @param evaluationWaitTime
         *        a consumer that will call methods on {@link WaitTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationWaitTime(WaitTime)
         */
        default Builder evaluationWaitTime(Consumer<WaitTime.Builder> evaluationWaitTime) {
            return evaluationWaitTime(WaitTime.builder().applyMutation(evaluationWaitTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<MultiConditionalBranch> branches = DefaultSdkAutoConstructList.getInstance();

        private String defaultActivity;

        private WaitTime evaluationWaitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiConditionalSplitActivity model) {
            branches(model.branches);
            defaultActivity(model.defaultActivity);
            evaluationWaitTime(model.evaluationWaitTime);
        }

        public final Collection<MultiConditionalBranch.Builder> getBranches() {
            return branches != null ? branches.stream().map(MultiConditionalBranch::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder branches(Collection<MultiConditionalBranch> branches) {
            this.branches = ListOfMultiConditionalBranchCopier.copy(branches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(MultiConditionalBranch... branches) {
            branches(Arrays.asList(branches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(Consumer<MultiConditionalBranch.Builder>... branches) {
            branches(Stream.of(branches).map(c -> MultiConditionalBranch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBranches(Collection<MultiConditionalBranch.BuilderImpl> branches) {
            this.branches = ListOfMultiConditionalBranchCopier.copyFromBuilder(branches);
        }

        public final String getDefaultActivity() {
            return defaultActivity;
        }

        @Override
        public final Builder defaultActivity(String defaultActivity) {
            this.defaultActivity = defaultActivity;
            return this;
        }

        public final void setDefaultActivity(String defaultActivity) {
            this.defaultActivity = defaultActivity;
        }

        public final WaitTime.Builder getEvaluationWaitTime() {
            return evaluationWaitTime != null ? evaluationWaitTime.toBuilder() : null;
        }

        @Override
        public final Builder evaluationWaitTime(WaitTime evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime;
            return this;
        }

        public final void setEvaluationWaitTime(WaitTime.BuilderImpl evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime != null ? evaluationWaitTime.build() : null;
        }

        @Override
        public MultiConditionalSplitActivity build() {
            return new MultiConditionalSplitActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
