/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the status and settings of the SMS channel for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMSChannelRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SMSChannelRequest.Builder, SMSChannelRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SMSChannelRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SMSChannelRequest::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final SdkField<String> SHORT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SMSChannelRequest::shortCode)).setter(setter(Builder::shortCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            SENDER_ID_FIELD, SHORT_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String senderId;

    private final String shortCode;

    private SMSChannelRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.senderId = builder.senderId;
        this.shortCode = builder.shortCode;
    }

    /**
     * <p>
     * Specifies whether to enable the SMS channel for the application.
     * </p>
     * 
     * @return Specifies whether to enable the SMS channel for the application.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The identity that you want to display on recipients' devices when they receive messages from the SMS channel.
     * </p>
     * 
     * @return The identity that you want to display on recipients' devices when they receive messages from the SMS
     *         channel.
     */
    public String senderId() {
        return senderId;
    }

    /**
     * <p>
     * The registered short code that you want to use when you send messages through the SMS channel.
     * </p>
     * 
     * @return The registered short code that you want to use when you send messages through the SMS channel.
     */
    public String shortCode() {
        return shortCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(shortCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSChannelRequest)) {
            return false;
        }
        SMSChannelRequest other = (SMSChannelRequest) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(senderId(), other.senderId())
                && Objects.equals(shortCode(), other.shortCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SMSChannelRequest").add("Enabled", enabled()).add("SenderId", senderId())
                .add("ShortCode", shortCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "ShortCode":
            return Optional.ofNullable(clazz.cast(shortCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SMSChannelRequest, T> g) {
        return obj -> g.apply((SMSChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMSChannelRequest> {
        /**
         * <p>
         * Specifies whether to enable the SMS channel for the application.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to enable the SMS channel for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The identity that you want to display on recipients' devices when they receive messages from the SMS channel.
         * </p>
         * 
         * @param senderId
         *        The identity that you want to display on recipients' devices when they receive messages from the SMS
         *        channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * The registered short code that you want to use when you send messages through the SMS channel.
         * </p>
         * 
         * @param shortCode
         *        The registered short code that you want to use when you send messages through the SMS channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortCode(String shortCode);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String senderId;

        private String shortCode;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSChannelRequest model) {
            enabled(model.enabled);
            senderId(model.senderId);
            shortCode(model.shortCode);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSenderId() {
            return senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public final String getShortCode() {
            return shortCode;
        }

        @Override
        public final Builder shortCode(String shortCode) {
            this.shortCode = shortCode;
            return this;
        }

        public final void setShortCode(String shortCode) {
            this.shortCode = shortCode;
        }

        @Override
        public SMSChannelRequest build() {
            return new SMSChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
