/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the dimension settings for a segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentDimensions implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentDimensions.Builder, SegmentDimensions> {
    private static final SdkField<Map<String, AttributeDimension>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeDimension>> builder(MarshallingType.MAP)
            .getter(getter(SegmentDimensions::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SegmentBehaviors> BEHAVIOR_FIELD = SdkField
            .<SegmentBehaviors> builder(MarshallingType.SDK_POJO).getter(getter(SegmentDimensions::behavior))
            .setter(setter(Builder::behavior)).constructor(SegmentBehaviors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Behavior").build()).build();

    private static final SdkField<SegmentDemographics> DEMOGRAPHIC_FIELD = SdkField
            .<SegmentDemographics> builder(MarshallingType.SDK_POJO).getter(getter(SegmentDimensions::demographic))
            .setter(setter(Builder::demographic)).constructor(SegmentDemographics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Demographic").build()).build();

    private static final SdkField<SegmentLocation> LOCATION_FIELD = SdkField.<SegmentLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(SegmentDimensions::location)).setter(setter(Builder::location)).constructor(SegmentLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<Map<String, MetricDimension>> METRICS_FIELD = SdkField
            .<Map<String, MetricDimension>> builder(MarshallingType.MAP)
            .getter(getter(SegmentDimensions::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MetricDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeDimension>> USER_ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeDimension>> builder(MarshallingType.MAP)
            .getter(getter(SegmentDimensions::userAttributes))
            .setter(setter(Builder::userAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            BEHAVIOR_FIELD, DEMOGRAPHIC_FIELD, LOCATION_FIELD, METRICS_FIELD, USER_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, AttributeDimension> attributes;

    private final SegmentBehaviors behavior;

    private final SegmentDemographics demographic;

    private final SegmentLocation location;

    private final Map<String, MetricDimension> metrics;

    private final Map<String, AttributeDimension> userAttributes;

    private SegmentDimensions(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.behavior = builder.behavior;
        this.demographic = builder.demographic;
        this.location = builder.location;
        this.metrics = builder.metrics;
        this.userAttributes = builder.userAttributes;
    }

    /**
     * <p>
     * One or more custom attributes to use as criteria for the segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more custom attributes to use as criteria for the segment.
     */
    public Map<String, AttributeDimension> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The behavior-based criteria, such as how recently users have used your app, for the segment.
     * </p>
     * 
     * @return The behavior-based criteria, such as how recently users have used your app, for the segment.
     */
    public SegmentBehaviors behavior() {
        return behavior;
    }

    /**
     * <p>
     * The demographic-based criteria, such as device platform, for the segment.
     * </p>
     * 
     * @return The demographic-based criteria, such as device platform, for the segment.
     */
    public SegmentDemographics demographic() {
        return demographic;
    }

    /**
     * <p>
     * The location-based criteria, such as region or GPS coordinates, for the segment.
     * </p>
     * 
     * @return The location-based criteria, such as region or GPS coordinates, for the segment.
     */
    public SegmentLocation location() {
        return location;
    }

    /**
     * <p>
     * One or more custom metrics to use as criteria for the segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more custom metrics to use as criteria for the segment.
     */
    public Map<String, MetricDimension> metrics() {
        return metrics;
    }

    /**
     * <p>
     * One or more custom user attributes to use as criteria for the segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more custom user attributes to use as criteria for the segment.
     */
    public Map<String, AttributeDimension> userAttributes() {
        return userAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(behavior());
        hashCode = 31 * hashCode + Objects.hashCode(demographic());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDimensions)) {
            return false;
        }
        SegmentDimensions other = (SegmentDimensions) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(behavior(), other.behavior())
                && Objects.equals(demographic(), other.demographic()) && Objects.equals(location(), other.location())
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(userAttributes(), other.userAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SegmentDimensions").add("Attributes", attributes()).add("Behavior", behavior())
                .add("Demographic", demographic()).add("Location", location()).add("Metrics", metrics())
                .add("UserAttributes", userAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Behavior":
            return Optional.ofNullable(clazz.cast(behavior()));
        case "Demographic":
            return Optional.ofNullable(clazz.cast(demographic()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "UserAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentDimensions, T> g) {
        return obj -> g.apply((SegmentDimensions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentDimensions> {
        /**
         * <p>
         * One or more custom attributes to use as criteria for the segment.
         * </p>
         * 
         * @param attributes
         *        One or more custom attributes to use as criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, AttributeDimension> attributes);

        /**
         * <p>
         * The behavior-based criteria, such as how recently users have used your app, for the segment.
         * </p>
         * 
         * @param behavior
         *        The behavior-based criteria, such as how recently users have used your app, for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behavior(SegmentBehaviors behavior);

        /**
         * <p>
         * The behavior-based criteria, such as how recently users have used your app, for the segment.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentBehaviors.Builder} avoiding the need to
         * create one manually via {@link SegmentBehaviors#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentBehaviors.Builder#build()} is called immediately and its
         * result is passed to {@link #behavior(SegmentBehaviors)}.
         * 
         * @param behavior
         *        a consumer that will call methods on {@link SegmentBehaviors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behavior(SegmentBehaviors)
         */
        default Builder behavior(Consumer<SegmentBehaviors.Builder> behavior) {
            return behavior(SegmentBehaviors.builder().applyMutation(behavior).build());
        }

        /**
         * <p>
         * The demographic-based criteria, such as device platform, for the segment.
         * </p>
         * 
         * @param demographic
         *        The demographic-based criteria, such as device platform, for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder demographic(SegmentDemographics demographic);

        /**
         * <p>
         * The demographic-based criteria, such as device platform, for the segment.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentDemographics.Builder} avoiding the need
         * to create one manually via {@link SegmentDemographics#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentDemographics.Builder#build()} is called immediately and
         * its result is passed to {@link #demographic(SegmentDemographics)}.
         * 
         * @param demographic
         *        a consumer that will call methods on {@link SegmentDemographics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #demographic(SegmentDemographics)
         */
        default Builder demographic(Consumer<SegmentDemographics.Builder> demographic) {
            return demographic(SegmentDemographics.builder().applyMutation(demographic).build());
        }

        /**
         * <p>
         * The location-based criteria, such as region or GPS coordinates, for the segment.
         * </p>
         * 
         * @param location
         *        The location-based criteria, such as region or GPS coordinates, for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(SegmentLocation location);

        /**
         * <p>
         * The location-based criteria, such as region or GPS coordinates, for the segment.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentLocation.Builder} avoiding the need to
         * create one manually via {@link SegmentLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(SegmentLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link SegmentLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(SegmentLocation)
         */
        default Builder location(Consumer<SegmentLocation.Builder> location) {
            return location(SegmentLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * One or more custom metrics to use as criteria for the segment.
         * </p>
         * 
         * @param metrics
         *        One or more custom metrics to use as criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, MetricDimension> metrics);

        /**
         * <p>
         * One or more custom user attributes to use as criteria for the segment.
         * </p>
         * 
         * @param userAttributes
         *        One or more custom user attributes to use as criteria for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Map<String, AttributeDimension> userAttributes);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeDimension> attributes = DefaultSdkAutoConstructMap.getInstance();

        private SegmentBehaviors behavior;

        private SegmentDemographics demographic;

        private SegmentLocation location;

        private Map<String, MetricDimension> metrics = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeDimension> userAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDimensions model) {
            attributes(model.attributes);
            behavior(model.behavior);
            demographic(model.demographic);
            location(model.location);
            metrics(model.metrics);
            userAttributes(model.userAttributes);
        }

        public final Map<String, AttributeDimension.Builder> getAttributes() {
            return attributes != null ? CollectionUtils.mapValues(attributes, AttributeDimension::toBuilder) : null;
        }

        @Override
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeDimension.BuilderImpl> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copyFromBuilder(attributes);
        }

        public final SegmentBehaviors.Builder getBehavior() {
            return behavior != null ? behavior.toBuilder() : null;
        }

        @Override
        public final Builder behavior(SegmentBehaviors behavior) {
            this.behavior = behavior;
            return this;
        }

        public final void setBehavior(SegmentBehaviors.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        public final SegmentDemographics.Builder getDemographic() {
            return demographic != null ? demographic.toBuilder() : null;
        }

        @Override
        public final Builder demographic(SegmentDemographics demographic) {
            this.demographic = demographic;
            return this;
        }

        public final void setDemographic(SegmentDemographics.BuilderImpl demographic) {
            this.demographic = demographic != null ? demographic.build() : null;
        }

        public final SegmentLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(SegmentLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(SegmentLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Map<String, MetricDimension.Builder> getMetrics() {
            return metrics != null ? CollectionUtils.mapValues(metrics, MetricDimension::toBuilder) : null;
        }

        @Override
        public final Builder metrics(Map<String, MetricDimension> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, MetricDimension.BuilderImpl> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copyFromBuilder(metrics);
        }

        public final Map<String, AttributeDimension.Builder> getUserAttributes() {
            return userAttributes != null ? CollectionUtils.mapValues(userAttributes, AttributeDimension::toBuilder) : null;
        }

        @Override
        public final Builder userAttributes(Map<String, AttributeDimension> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copy(userAttributes);
            return this;
        }

        public final void setUserAttributes(Map<String, AttributeDimension.BuilderImpl> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copyFromBuilder(userAttributes);
        }

        @Override
        public SegmentDimensions build() {
            return new SegmentDimensions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
