/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a message template that's associated with your Amazon Pinpoint account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateResponse.Builder, TemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateResponse::defaultSubstitutions)).setter(setter(Builder::defaultSubstitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build())
            .build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(TemplateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateResponse::templateDescription)).setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateResponse::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateResponse::templateTypeAsString)).setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_DATE_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, LAST_MODIFIED_DATE_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD,
            TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String creationDate;

    private final String defaultSubstitutions;

    private final String lastModifiedDate;

    private final Map<String, String> tags;

    private final String templateDescription;

    private final String templateName;

    private final String templateType;

    private TemplateResponse(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the message template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the message template.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date when the message template was created.
     * </p>
     * 
     * @return The date when the message template was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The JSON object that specifies the default values that are used for message variables in the message template.
     * This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding
     * value defines the default value for that variable.
     * </p>
     * 
     * @return The JSON object that specifies the default values that are used for message variables in the message
     *         template. This object is a set of key-value pairs. Each key defines a message variable in the template.
     *         The corresponding value defines the default value for that variable.
     */
    public String defaultSubstitutions() {
        return defaultSubstitutions;
    }

    /**
     * <p>
     * The date when the message template was last modified.
     * </p>
     * 
     * @return The date when the message template was last modified.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the message template.
     * Each tag consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that identifies the tags that are associated with the message
     *         template. Each tag consists of a required tag key and an associated tag value.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The custom description of the message template.
     * </p>
     * 
     * @return The custom description of the message template.
     */
    public String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The type of channel that the message template is designed for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of channel that the message template is designed for.
     * @see TemplateType
     */
    public TemplateType templateType() {
        return TemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of channel that the message template is designed for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of channel that the message template is designed for.
     * @see TemplateType
     */
    public String templateTypeAsString() {
        return templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateResponse)) {
            return false;
        }
        TemplateResponse other = (TemplateResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(defaultSubstitutions(), other.defaultSubstitutions())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(tags(), other.tags())
                && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TemplateResponse").add("Arn", arn()).add("CreationDate", creationDate())
                .add("DefaultSubstitutions", defaultSubstitutions()).add("LastModifiedDate", lastModifiedDate())
                .add("Tags", tags()).add("TemplateDescription", templateDescription()).add("TemplateName", templateName())
                .add("TemplateType", templateTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "DefaultSubstitutions":
            return Optional.ofNullable(clazz.cast(defaultSubstitutions()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateResponse, T> g) {
        return obj -> g.apply((TemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the message template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date when the message template was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the message template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The JSON object that specifies the default values that are used for message variables in the message
         * template. This object is a set of key-value pairs. Each key defines a message variable in the template. The
         * corresponding value defines the default value for that variable.
         * </p>
         * 
         * @param defaultSubstitutions
         *        The JSON object that specifies the default values that are used for message variables in the message
         *        template. This object is a set of key-value pairs. Each key defines a message variable in the
         *        template. The corresponding value defines the default value for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubstitutions(String defaultSubstitutions);

        /**
         * <p>
         * The date when the message template was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the message template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the message
         * template. Each tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that identifies the tags that are associated with the
         *        message template. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The custom description of the message template.
         * </p>
         * 
         * @param templateDescription
         *        The custom description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param templateName
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The type of channel that the message template is designed for.
         * </p>
         * 
         * @param templateType
         *        The type of channel that the message template is designed for.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of channel that the message template is designed for.
         * </p>
         * 
         * @param templateType
         *        The type of channel that the message template is designed for.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(TemplateType templateType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String creationDate;

        private String defaultSubstitutions;

        private String lastModifiedDate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private String templateName;

        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateResponse model) {
            arn(model.arn);
            creationDate(model.creationDate);
            defaultSubstitutions(model.defaultSubstitutions);
            lastModifiedDate(model.lastModifiedDate);
            tags(model.tags);
            templateDescription(model.templateDescription);
            templateName(model.templateName);
            templateType(model.templateType);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDefaultSubstitutions() {
            return defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getTemplateTypeAsString() {
            return templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public TemplateResponse build() {
            return new TemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
