/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointsBatchResponse extends PinpointResponse implements
        ToCopyableBuilder<UpdateEndpointsBatchResponse.Builder, UpdateEndpointsBatchResponse> {
    private static final SdkField<MessageBody> MESSAGE_BODY_FIELD = SdkField
            .<MessageBody> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateEndpointsBatchResponse::messageBody))
            .setter(setter(Builder::messageBody))
            .constructor(MessageBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_BODY_FIELD));

    private final MessageBody messageBody;

    private UpdateEndpointsBatchResponse(BuilderImpl builder) {
        super(builder);
        this.messageBody = builder.messageBody;
    }

    /**
     * Returns the value of the MessageBody property for this object.
     * 
     * @return The value of the MessageBody property for this object.
     */
    public MessageBody messageBody() {
        return messageBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageBody());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointsBatchResponse)) {
            return false;
        }
        UpdateEndpointsBatchResponse other = (UpdateEndpointsBatchResponse) obj;
        return Objects.equals(messageBody(), other.messageBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEndpointsBatchResponse").add("MessageBody", messageBody()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageBody":
            return Optional.ofNullable(clazz.cast(messageBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointsBatchResponse, T> g) {
        return obj -> g.apply((UpdateEndpointsBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEndpointsBatchResponse> {
        /**
         * Sets the value of the MessageBody property for this object.
         *
         * @param messageBody
         *        The new value for the MessageBody property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageBody(MessageBody messageBody);

        /**
         * Sets the value of the MessageBody property for this object.
         *
         * This is a convenience that creates an instance of the {@link MessageBody.Builder} avoiding the need to create
         * one manually via {@link MessageBody#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageBody.Builder#build()} is called immediately and its result
         * is passed to {@link #messageBody(MessageBody)}.
         * 
         * @param messageBody
         *        a consumer that will call methods on {@link MessageBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageBody(MessageBody)
         */
        default Builder messageBody(Consumer<MessageBody.Builder> messageBody) {
            return messageBody(MessageBody.builder().applyMutation(messageBody).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private MessageBody messageBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointsBatchResponse model) {
            super(model);
            messageBody(model.messageBody);
        }

        public final MessageBody.Builder getMessageBody() {
            return messageBody != null ? messageBody.toBuilder() : null;
        }

        @Override
        public final Builder messageBody(MessageBody messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final void setMessageBody(MessageBody.BuilderImpl messageBody) {
            this.messageBody = messageBody != null ? messageBody.build() : null;
        }

        @Override
        public UpdateEndpointsBatchResponse build() {
            return new UpdateEndpointsBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
