/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a duration or a date and time that indicates when Amazon Pinpoint determines whether an activity's
 * conditions have been met or an activity moves participants to the next activity in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaitTime implements SdkPojo, Serializable, ToCopyableBuilder<WaitTime.Builder, WaitTime> {
    private static final SdkField<String> WAIT_FOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WaitTime::waitFor)).setter(setter(Builder::waitFor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitFor").build()).build();

    private static final SdkField<String> WAIT_UNTIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WaitTime::waitUntil)).setter(setter(Builder::waitUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitUntil").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAIT_FOR_FIELD,
            WAIT_UNTIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String waitFor;

    private final String waitUntil;

    private WaitTime(BuilderImpl builder) {
        this.waitFor = builder.waitFor;
        this.waitUntil = builder.waitUntil;
    }

    /**
     * <p>
     * The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity's
     * conditions have been met or moving participants to the next activity in the journey.
     * </p>
     * 
     * @return The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity's
     *         conditions have been met or moving participants to the next activity in the journey.
     */
    public String waitFor() {
        return waitFor;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's conditions have
     * been met or the activity moves participants to the next activity in the journey.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's conditions
     *         have been met or the activity moves participants to the next activity in the journey.
     */
    public String waitUntil() {
        return waitUntil;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(waitFor());
        hashCode = 31 * hashCode + Objects.hashCode(waitUntil());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaitTime)) {
            return false;
        }
        WaitTime other = (WaitTime) obj;
        return Objects.equals(waitFor(), other.waitFor()) && Objects.equals(waitUntil(), other.waitUntil());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WaitTime").add("WaitFor", waitFor()).add("WaitUntil", waitUntil()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WaitFor":
            return Optional.ofNullable(clazz.cast(waitFor()));
        case "WaitUntil":
            return Optional.ofNullable(clazz.cast(waitUntil()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WaitTime, T> g) {
        return obj -> g.apply((WaitTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaitTime> {
        /**
         * <p>
         * The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity's
         * conditions have been met or moving participants to the next activity in the journey.
         * </p>
         * 
         * @param waitFor
         *        The amount of time to wait, as a duration in ISO 8601 format, before determining whether the
         *        activity's conditions have been met or moving participants to the next activity in the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitFor(String waitFor);

        /**
         * <p>
         * The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's conditions have
         * been met or the activity moves participants to the next activity in the journey.
         * </p>
         * 
         * @param waitUntil
         *        The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity's
         *        conditions have been met or the activity moves participants to the next activity in the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitUntil(String waitUntil);
    }

    static final class BuilderImpl implements Builder {
        private String waitFor;

        private String waitUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(WaitTime model) {
            waitFor(model.waitFor);
            waitUntil(model.waitUntil);
        }

        public final String getWaitFor() {
            return waitFor;
        }

        @Override
        public final Builder waitFor(String waitFor) {
            this.waitFor = waitFor;
            return this;
        }

        public final void setWaitFor(String waitFor) {
            this.waitFor = waitFor;
        }

        public final String getWaitUntil() {
            return waitUntil;
        }

        @Override
        public final Builder waitUntil(String waitUntil) {
            this.waitUntil = waitUntil;
            return this;
        }

        public final void setWaitUntil(String waitUntil) {
            this.waitUntil = waitUntil;
        }

        @Override
        public WaitTime build() {
            return new WaitTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
