/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSmsTemplateRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateSmsTemplateRequest> {
    private static final SdkField<SMSTemplateRequest> SMS_TEMPLATE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateSmsTemplateRequest.getter(UpdateSmsTemplateRequest::smsTemplateRequest)).setter(UpdateSmsTemplateRequest.setter(Builder::smsTemplateRequest)).constructor(SMSTemplateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSTemplateRequest").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSmsTemplateRequest.getter(UpdateSmsTemplateRequest::templateName)).setter(UpdateSmsTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_TEMPLATE_REQUEST_FIELD, TEMPLATE_NAME_FIELD));
    private final SMSTemplateRequest smsTemplateRequest;
    private final String templateName;

    private UpdateSmsTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.smsTemplateRequest = builder.smsTemplateRequest;
        this.templateName = builder.templateName;
    }

    public SMSTemplateRequest smsTemplateRequest() {
        return this.smsTemplateRequest;
    }

    public String templateName() {
        return this.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.smsTemplateRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmsTemplateRequest)) {
            return false;
        }
        UpdateSmsTemplateRequest other = (UpdateSmsTemplateRequest)((Object)obj);
        return Objects.equals(this.smsTemplateRequest(), other.smsTemplateRequest()) && Objects.equals(this.templateName(), other.templateName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSmsTemplateRequest").add("SMSTemplateRequest", (Object)this.smsTemplateRequest()).add("TemplateName", (Object)this.templateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SMSTemplateRequest": {
                return Optional.ofNullable(clazz.cast(this.smsTemplateRequest()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmsTemplateRequest, T> g) {
        return obj -> g.apply((UpdateSmsTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private SMSTemplateRequest smsTemplateRequest;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmsTemplateRequest model) {
            super(model);
            this.smsTemplateRequest(model.smsTemplateRequest);
            this.templateName(model.templateName);
        }

        public final SMSTemplateRequest.Builder getSmsTemplateRequest() {
            return this.smsTemplateRequest != null ? this.smsTemplateRequest.toBuilder() : null;
        }

        @Override
        public final Builder smsTemplateRequest(SMSTemplateRequest smsTemplateRequest) {
            this.smsTemplateRequest = smsTemplateRequest;
            return this;
        }

        public final void setSmsTemplateRequest(SMSTemplateRequest.BuilderImpl smsTemplateRequest) {
            this.smsTemplateRequest = smsTemplateRequest != null ? smsTemplateRequest.build() : null;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmsTemplateRequest build() {
            return new UpdateSmsTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSmsTemplateRequest> {
        public Builder smsTemplateRequest(SMSTemplateRequest var1);

        default public Builder smsTemplateRequest(Consumer<SMSTemplateRequest.Builder> smsTemplateRequest) {
            return this.smsTemplateRequest((SMSTemplateRequest)((SMSTemplateRequest.Builder)SMSTemplateRequest.builder().applyMutation(smsTemplateRequest)).build());
        }

        public Builder templateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

