/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteEventStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventStreamRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, PutEventStreamRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutEventStreamRequest.getter(PutEventStreamRequest::applicationId)).setter(PutEventStreamRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<WriteEventStream> WRITE_EVENT_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutEventStreamRequest.getter(PutEventStreamRequest::writeEventStream)).setter(PutEventStreamRequest.setter(Builder::writeEventStream)).constructor(WriteEventStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteEventStream").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, WRITE_EVENT_STREAM_FIELD));
    private final String applicationId;
    private final WriteEventStream writeEventStream;

    private PutEventStreamRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeEventStream = builder.writeEventStream;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteEventStream writeEventStream() {
        return this.writeEventStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeEventStream());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventStreamRequest)) {
            return false;
        }
        PutEventStreamRequest other = (PutEventStreamRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.writeEventStream(), other.writeEventStream());
    }

    public String toString() {
        return ToString.builder((String)"PutEventStreamRequest").add("ApplicationId", (Object)this.applicationId()).add("WriteEventStream", (Object)this.writeEventStream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "WriteEventStream": {
                return Optional.ofNullable(clazz.cast(this.writeEventStream()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventStreamRequest, T> g) {
        return obj -> g.apply((PutEventStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteEventStream writeEventStream;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventStreamRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.writeEventStream(model.writeEventStream);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteEventStream.Builder getWriteEventStream() {
            return this.writeEventStream != null ? this.writeEventStream.toBuilder() : null;
        }

        @Override
        public final Builder writeEventStream(WriteEventStream writeEventStream) {
            this.writeEventStream = writeEventStream;
            return this;
        }

        public final void setWriteEventStream(WriteEventStream.BuilderImpl writeEventStream) {
            this.writeEventStream = writeEventStream != null ? writeEventStream.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventStreamRequest build() {
            return new PutEventStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventStreamRequest> {
        public Builder applicationId(String var1);

        public Builder writeEventStream(WriteEventStream var1);

        default public Builder writeEventStream(Consumer<WriteEventStream.Builder> writeEventStream) {
            return this.writeEventStream((WriteEventStream)((WriteEventStream.Builder)WriteEventStream.builder().applyMutation(writeEventStream)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

