/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.SegmentCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartCondition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartCondition.getter(StartCondition::description)).setter(StartCondition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<SegmentCondition> SEGMENT_START_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartCondition.getter(StartCondition::segmentStartCondition)).setter(StartCondition.setter(Builder::segmentStartCondition)).constructor(SegmentCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentStartCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, SEGMENT_START_CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final SegmentCondition segmentStartCondition;

    private StartCondition(BuilderImpl builder) {
        this.description = builder.description;
        this.segmentStartCondition = builder.segmentStartCondition;
    }

    public String description() {
        return this.description;
    }

    public SegmentCondition segmentStartCondition() {
        return this.segmentStartCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentStartCondition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCondition)) {
            return false;
        }
        StartCondition other = (StartCondition)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.segmentStartCondition(), other.segmentStartCondition());
    }

    public String toString() {
        return ToString.builder((String)"StartCondition").add("Description", (Object)this.description()).add("SegmentStartCondition", (Object)this.segmentStartCondition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SegmentStartCondition": {
                return Optional.ofNullable(clazz.cast(this.segmentStartCondition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCondition, T> g) {
        return obj -> g.apply((StartCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private SegmentCondition segmentStartCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCondition model) {
            this.description(model.description);
            this.segmentStartCondition(model.segmentStartCondition);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SegmentCondition.Builder getSegmentStartCondition() {
            return this.segmentStartCondition != null ? this.segmentStartCondition.toBuilder() : null;
        }

        @Override
        public final Builder segmentStartCondition(SegmentCondition segmentStartCondition) {
            this.segmentStartCondition = segmentStartCondition;
            return this;
        }

        public final void setSegmentStartCondition(SegmentCondition.BuilderImpl segmentStartCondition) {
            this.segmentStartCondition = segmentStartCondition != null ? segmentStartCondition.build() : null;
        }

        public StartCondition build() {
            return new StartCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartCondition> {
        public Builder description(String var1);

        public Builder segmentStartCondition(SegmentCondition var1);

        default public Builder segmentStartCondition(Consumer<SegmentCondition.Builder> segmentStartCondition) {
            return this.segmentStartCondition((SegmentCondition)((SegmentCondition.Builder)SegmentCondition.builder().applyMutation(segmentStartCondition)).build());
        }
    }
}

