/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJourneyRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, CreateJourneyRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJourneyRequest.getter(CreateJourneyRequest::applicationId)).setter(CreateJourneyRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<WriteJourneyRequest> WRITE_JOURNEY_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateJourneyRequest.getter(CreateJourneyRequest::writeJourneyRequest)).setter(CreateJourneyRequest.setter(Builder::writeJourneyRequest)).constructor(WriteJourneyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteJourneyRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, WRITE_JOURNEY_REQUEST_FIELD));
    private final String applicationId;
    private final WriteJourneyRequest writeJourneyRequest;

    private CreateJourneyRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeJourneyRequest = builder.writeJourneyRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteJourneyRequest writeJourneyRequest() {
        return this.writeJourneyRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeJourneyRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJourneyRequest)) {
            return false;
        }
        CreateJourneyRequest other = (CreateJourneyRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.writeJourneyRequest(), other.writeJourneyRequest());
    }

    public String toString() {
        return ToString.builder((String)"CreateJourneyRequest").add("ApplicationId", (Object)this.applicationId()).add("WriteJourneyRequest", (Object)this.writeJourneyRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "WriteJourneyRequest": {
                return Optional.ofNullable(clazz.cast(this.writeJourneyRequest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJourneyRequest, T> g) {
        return obj -> g.apply((CreateJourneyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteJourneyRequest writeJourneyRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJourneyRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.writeJourneyRequest(model.writeJourneyRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteJourneyRequest.Builder getWriteJourneyRequest() {
            return this.writeJourneyRequest != null ? this.writeJourneyRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeJourneyRequest(WriteJourneyRequest writeJourneyRequest) {
            this.writeJourneyRequest = writeJourneyRequest;
            return this;
        }

        public final void setWriteJourneyRequest(WriteJourneyRequest.BuilderImpl writeJourneyRequest) {
            this.writeJourneyRequest = writeJourneyRequest != null ? writeJourneyRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJourneyRequest build() {
            return new CreateJourneyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJourneyRequest> {
        public Builder applicationId(String var1);

        public Builder writeJourneyRequest(WriteJourneyRequest var1);

        default public Builder writeJourneyRequest(Consumer<WriteJourneyRequest.Builder> writeJourneyRequest) {
            return this.writeJourneyRequest((WriteJourneyRequest)((WriteJourneyRequest.Builder)WriteJourneyRequest.builder().applyMutation(writeJourneyRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

