/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoiceMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VoiceMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(VoiceMessage.getter(VoiceMessage::body)).setter(VoiceMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(VoiceMessage.getter(VoiceMessage::languageCode)).setter(VoiceMessage.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> ORIGINATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationNumber").getter(VoiceMessage.getter(VoiceMessage::originationNumber)).setter(VoiceMessage.setter(Builder::originationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationNumber").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Substitutions").getter(VoiceMessage.getter(VoiceMessage::substitutions)).setter(VoiceMessage.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceId").getter(VoiceMessage.getter(VoiceMessage::voiceId)).setter(VoiceMessage.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, LANGUAGE_CODE_FIELD, ORIGINATION_NUMBER_FIELD, SUBSTITUTIONS_FIELD, VOICE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String languageCode;
    private final String originationNumber;
    private final Map<String, List<String>> substitutions;
    private final String voiceId;

    private VoiceMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.languageCode = builder.languageCode;
        this.originationNumber = builder.originationNumber;
        this.substitutions = builder.substitutions;
        this.voiceId = builder.voiceId;
    }

    public String body() {
        return this.body;
    }

    public String languageCode() {
        return this.languageCode;
    }

    public String originationNumber() {
        return this.originationNumber;
    }

    public boolean hasSubstitutions() {
        return this.substitutions != null && !(this.substitutions instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String voiceId() {
        return this.voiceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceMessage)) {
            return false;
        }
        VoiceMessage other = (VoiceMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.originationNumber(), other.originationNumber()) && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.voiceId(), other.voiceId());
    }

    public String toString() {
        return ToString.builder((String)"VoiceMessage").add("Body", (Object)this.body()).add("LanguageCode", (Object)this.languageCode()).add("OriginationNumber", (Object)this.originationNumber()).add("Substitutions", this.substitutions()).add("VoiceId", (Object)this.voiceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "OriginationNumber": {
                return Optional.ofNullable(clazz.cast(this.originationNumber()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceMessage, T> g) {
        return obj -> g.apply((VoiceMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String languageCode;
        private String originationNumber;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceMessage model) {
            this.body(model.body);
            this.languageCode(model.languageCode);
            this.originationNumber(model.originationNumber);
            this.substitutions(model.substitutions);
            this.voiceId(model.voiceId);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getOriginationNumber() {
            return this.originationNumber;
        }

        @Override
        public final Builder originationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public final void setOriginationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public VoiceMessage build() {
            return new VoiceMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VoiceMessage> {
        public Builder body(String var1);

        public Builder languageCode(String var1);

        public Builder originationNumber(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder voiceId(String var1);
    }
}

