/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey,
 * and provides information about that query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyExecutionMetricsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyExecutionMetricsResponse.Builder, JourneyExecutionMetricsResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(JourneyExecutionMetricsResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JourneyId").getter(getter(JourneyExecutionMetricsResponse::journeyId))
            .setter(setter(Builder::journeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyId").build()).build();

    private static final SdkField<String> LAST_EVALUATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastEvaluatedTime").getter(getter(JourneyExecutionMetricsResponse::lastEvaluatedTime))
            .setter(setter(Builder::lastEvaluatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTime").build()).build();

    private static final SdkField<Map<String, String>> METRICS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Metrics")
            .getter(getter(JourneyExecutionMetricsResponse::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            JOURNEY_ID_FIELD, LAST_EVALUATED_TIME_FIELD, METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String journeyId;

    private final String lastEvaluatedTime;

    private final Map<String, String> metrics;

    private JourneyExecutionMetricsResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.journeyId = builder.journeyId;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * The unique identifier for the application that the metric applies to.
     * </p>
     * 
     * @return The unique identifier for the application that the metric applies to.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the journey that the metric applies to.
     * </p>
     * 
     * @return The unique identifier for the journey that the metric applies to.
     */
    public String journeyId() {
        return journeyId;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey and updated the data for
     * the metric.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey and updated the
     *         data for the metric.
     */
    public String lastEvaluatedTime() {
        return lastEvaluatedTime;
    }

    /**
     * Returns true if the Metrics property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A JSON object that contains the results of the query. For information about the structure and contents of the
     * results, see the <a
     * href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
     * Pinpoint Developer Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A JSON object that contains the results of the query. For information about the structure and contents of
     *         the results, see the <a
     *         href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
     *         Pinpoint Developer Guide</a>.
     */
    public Map<String, String> metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyExecutionMetricsResponse)) {
            return false;
        }
        JourneyExecutionMetricsResponse other = (JourneyExecutionMetricsResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(journeyId(), other.journeyId())
                && Objects.equals(lastEvaluatedTime(), other.lastEvaluatedTime()) && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JourneyExecutionMetricsResponse").add("ApplicationId", applicationId())
                .add("JourneyId", journeyId()).add("LastEvaluatedTime", lastEvaluatedTime()).add("Metrics", metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "JourneyId":
            return Optional.ofNullable(clazz.cast(journeyId()));
        case "LastEvaluatedTime":
            return Optional.ofNullable(clazz.cast(lastEvaluatedTime()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyExecutionMetricsResponse, T> g) {
        return obj -> g.apply((JourneyExecutionMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyExecutionMetricsResponse> {
        /**
         * <p>
         * The unique identifier for the application that the metric applies to.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the metric applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the journey that the metric applies to.
         * </p>
         * 
         * @param journeyId
         *        The unique identifier for the journey that the metric applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyId(String journeyId);

        /**
         * <p>
         * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey and updated the data
         * for the metric.
         * </p>
         * 
         * @param lastEvaluatedTime
         *        The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey and updated the
         *        data for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedTime(String lastEvaluatedTime);

        /**
         * <p>
         * A JSON object that contains the results of the query. For information about the structure and contents of the
         * results, see the <a
         * href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
         * Pinpoint Developer Guide</a>.
         * </p>
         * 
         * @param metrics
         *        A JSON object that contains the results of the query. For information about the structure and contents
         *        of the results, see the <a
         *        href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html"
         *        >Amazon Pinpoint Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, String> metrics);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String journeyId;

        private String lastEvaluatedTime;

        private Map<String, String> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyExecutionMetricsResponse model) {
            applicationId(model.applicationId);
            journeyId(model.journeyId);
            lastEvaluatedTime(model.lastEvaluatedTime);
            metrics(model.metrics);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getJourneyId() {
            return journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        public final String getLastEvaluatedTime() {
            return lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final void setLastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        public final Map<String, String> getMetrics() {
            return metrics;
        }

        @Override
        public final Builder metrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
        }

        @Override
        public JourneyExecutionMetricsResponse build() {
            return new JourneyExecutionMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
