/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the content and settings for a message template that can be used in messages that are sent
 * through a push notification channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushNotificationTemplateResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<PushNotificationTemplateResponse.Builder, PushNotificationTemplateResponse> {
    private static final SdkField<AndroidPushNotificationTemplate> ADM_FIELD = SdkField
            .<AndroidPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("ADM")
            .getter(getter(PushNotificationTemplateResponse::adm)).setter(setter(Builder::adm))
            .constructor(AndroidPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADM").build()).build();

    private static final SdkField<APNSPushNotificationTemplate> APNS_FIELD = SdkField
            .<APNSPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("APNS")
            .getter(getter(PushNotificationTemplateResponse::apns)).setter(setter(Builder::apns))
            .constructor(APNSPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNS").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PushNotificationTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<AndroidPushNotificationTemplate> BAIDU_FIELD = SdkField
            .<AndroidPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("Baidu")
            .getter(getter(PushNotificationTemplateResponse::baidu)).setter(setter(Builder::baidu))
            .constructor(AndroidPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Baidu").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(PushNotificationTemplateResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<DefaultPushNotificationTemplate> DEFAULT_FIELD = SdkField
            .<DefaultPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("Default")
            .getter(getter(PushNotificationTemplateResponse::defaultValue)).setter(setter(Builder::defaultValue))
            .constructor(DefaultPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Default").build()).build();

    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSubstitutions").getter(getter(PushNotificationTemplateResponse::defaultSubstitutions))
            .setter(setter(Builder::defaultSubstitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build())
            .build();

    private static final SdkField<AndroidPushNotificationTemplate> GCM_FIELD = SdkField
            .<AndroidPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("GCM")
            .getter(getter(PushNotificationTemplateResponse::gcm)).setter(setter(Builder::gcm))
            .constructor(AndroidPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCM").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(PushNotificationTemplateResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommenderId").getter(getter(PushNotificationTemplateResponse::recommenderId))
            .setter(setter(Builder::recommenderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PushNotificationTemplateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(PushNotificationTemplateResponse::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(PushNotificationTemplateResponse::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(PushNotificationTemplateResponse::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(PushNotificationTemplateResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_FIELD, APNS_FIELD,
            ARN_FIELD, BAIDU_FIELD, CREATION_DATE_FIELD, DEFAULT_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, GCM_FIELD,
            LAST_MODIFIED_DATE_FIELD, RECOMMENDER_ID_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD,
            TEMPLATE_TYPE_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AndroidPushNotificationTemplate adm;

    private final APNSPushNotificationTemplate apns;

    private final String arn;

    private final AndroidPushNotificationTemplate baidu;

    private final String creationDate;

    private final DefaultPushNotificationTemplate defaultValue;

    private final String defaultSubstitutions;

    private final AndroidPushNotificationTemplate gcm;

    private final String lastModifiedDate;

    private final String recommenderId;

    private final Map<String, String> tags;

    private final String templateDescription;

    private final String templateName;

    private final String templateType;

    private final String version;

    private PushNotificationTemplateResponse(BuilderImpl builder) {
        this.adm = builder.adm;
        this.apns = builder.apns;
        this.arn = builder.arn;
        this.baidu = builder.baidu;
        this.creationDate = builder.creationDate;
        this.defaultValue = builder.defaultValue;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.gcm = builder.gcm;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.recommenderId = builder.recommenderId;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.version = builder.version;
    }

    /**
     * <p>
     * The message template that's used for the ADM (Amazon Device Messaging) channel. This message template overrides
     * the default template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template that's used for the ADM (Amazon Device Messaging) channel. This message template
     *         overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public AndroidPushNotificationTemplate adm() {
        return adm;
    }

    /**
     * <p>
     * The message template that's used for the APNs (Apple Push Notification service) channel. This message template
     * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template that's used for the APNs (Apple Push Notification service) channel. This message
     *         template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public APNSPushNotificationTemplate apns() {
        return apns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the message template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the message template.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The message template that's used for the Baidu (Baidu Cloud Push) channel. This message template overrides the
     * default template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template that's used for the Baidu (Baidu Cloud Push) channel. This message template
     *         overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public AndroidPushNotificationTemplate baidu() {
        return baidu;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the message template was created.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the message template was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The default message template that's used for push notification channels.
     * </p>
     * 
     * @return The default message template that's used for push notification channels.
     */
    public DefaultPushNotificationTemplate defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The JSON object that specifies the default values that are used for message variables in the message template.
     * This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding
     * value defines the default value for that variable.
     * </p>
     * 
     * @return The JSON object that specifies the default values that are used for message variables in the message
     *         template. This object is a set of key-value pairs. Each key defines a message variable in the template.
     *         The corresponding value defines the default value for that variable.
     */
    public String defaultSubstitutions() {
        return defaultSubstitutions;
    }

    /**
     * <p>
     * The message template that's used for the GCM channel, which is used to send notifications through the Firebase
     * Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the
     * default template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template that's used for the GCM channel, which is used to send notifications through the
     *         Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template
     *         overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public AndroidPushNotificationTemplate gcm() {
        return gcm;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the message template was last modified.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the message template was last modified.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The unique identifier for the recommender model that's used by the message template.
     * </p>
     * 
     * @return The unique identifier for the recommender model that's used by the message template.
     */
    public String recommenderId() {
        return recommenderId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the message template.
     * Each tag consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that identifies the tags that are associated with the message
     *         template. Each tag consists of a required tag key and an associated tag value.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The custom description of the message template.
     * </p>
     * 
     * @return The custom description of the message template.
     */
    public String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The type of channel that the message template is designed for. For a push notification template, this value is
     * PUSH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of channel that the message template is designed for. For a push notification template, this
     *         value is PUSH.
     * @see TemplateType
     */
    public TemplateType templateType() {
        return TemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of channel that the message template is designed for. For a push notification template, this value is
     * PUSH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of channel that the message template is designed for. For a push notification template, this
     *         value is PUSH.
     * @see TemplateType
     */
    public String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * The unique identifier, as an integer, for the active version of the message template, or the version of the
     * template that you specified by using the version parameter in your request.
     * </p>
     * 
     * @return The unique identifier, as an integer, for the active version of the message template, or the version of
     *         the template that you specified by using the version parameter in your request.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adm());
        hashCode = 31 * hashCode + Objects.hashCode(apns());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(baidu());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(gcm());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushNotificationTemplateResponse)) {
            return false;
        }
        PushNotificationTemplateResponse other = (PushNotificationTemplateResponse) obj;
        return Objects.equals(adm(), other.adm()) && Objects.equals(apns(), other.apns()) && Objects.equals(arn(), other.arn())
                && Objects.equals(baidu(), other.baidu()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(gcm(), other.gcm())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(recommenderId(), other.recommenderId()) && Objects.equals(tags(), other.tags())
                && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PushNotificationTemplateResponse").add("ADM", adm()).add("APNS", apns()).add("Arn", arn())
                .add("Baidu", baidu()).add("CreationDate", creationDate()).add("Default", defaultValue())
                .add("DefaultSubstitutions", defaultSubstitutions()).add("GCM", gcm())
                .add("LastModifiedDate", lastModifiedDate()).add("RecommenderId", recommenderId()).add("Tags", tags())
                .add("TemplateDescription", templateDescription()).add("TemplateName", templateName())
                .add("TemplateType", templateTypeAsString()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ADM":
            return Optional.ofNullable(clazz.cast(adm()));
        case "APNS":
            return Optional.ofNullable(clazz.cast(apns()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Baidu":
            return Optional.ofNullable(clazz.cast(baidu()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Default":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "DefaultSubstitutions":
            return Optional.ofNullable(clazz.cast(defaultSubstitutions()));
        case "GCM":
            return Optional.ofNullable(clazz.cast(gcm()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "RecommenderId":
            return Optional.ofNullable(clazz.cast(recommenderId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushNotificationTemplateResponse, T> g) {
        return obj -> g.apply((PushNotificationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushNotificationTemplateResponse> {
        /**
         * <p>
         * The message template that's used for the ADM (Amazon Device Messaging) channel. This message template
         * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param adm
         *        The message template that's used for the ADM (Amazon Device Messaging) channel. This message template
         *        overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adm(AndroidPushNotificationTemplate adm);

        /**
         * <p>
         * The message template that's used for the ADM (Amazon Device Messaging) channel. This message template
         * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience that creates an instance of the {@link AndroidPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link AndroidPushNotificationTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AndroidPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #adm(AndroidPushNotificationTemplate)}.
         * 
         * @param adm
         *        a consumer that will call methods on {@link AndroidPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adm(AndroidPushNotificationTemplate)
         */
        default Builder adm(Consumer<AndroidPushNotificationTemplate.Builder> adm) {
            return adm(AndroidPushNotificationTemplate.builder().applyMutation(adm).build());
        }

        /**
         * <p>
         * The message template that's used for the APNs (Apple Push Notification service) channel. This message
         * template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param apns
         *        The message template that's used for the APNs (Apple Push Notification service) channel. This message
         *        template overrides the default template for push notification channels
         *        (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apns(APNSPushNotificationTemplate apns);

        /**
         * <p>
         * The message template that's used for the APNs (Apple Push Notification service) channel. This message
         * template overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience that creates an instance of the {@link APNSPushNotificationTemplate.Builder} avoiding
         * the need to create one manually via {@link APNSPushNotificationTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link APNSPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #apns(APNSPushNotificationTemplate)}.
         * 
         * @param apns
         *        a consumer that will call methods on {@link APNSPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apns(APNSPushNotificationTemplate)
         */
        default Builder apns(Consumer<APNSPushNotificationTemplate.Builder> apns) {
            return apns(APNSPushNotificationTemplate.builder().applyMutation(apns).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the message template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The message template that's used for the Baidu (Baidu Cloud Push) channel. This message template overrides
         * the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param baidu
         *        The message template that's used for the Baidu (Baidu Cloud Push) channel. This message template
         *        overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baidu(AndroidPushNotificationTemplate baidu);

        /**
         * <p>
         * The message template that's used for the Baidu (Baidu Cloud Push) channel. This message template overrides
         * the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience that creates an instance of the {@link AndroidPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link AndroidPushNotificationTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AndroidPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #baidu(AndroidPushNotificationTemplate)}.
         * 
         * @param baidu
         *        a consumer that will call methods on {@link AndroidPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baidu(AndroidPushNotificationTemplate)
         */
        default Builder baidu(Consumer<AndroidPushNotificationTemplate.Builder> baidu) {
            return baidu(AndroidPushNotificationTemplate.builder().applyMutation(baidu).build());
        }

        /**
         * <p>
         * The date, in ISO 8601 format, when the message template was created.
         * </p>
         * 
         * @param creationDate
         *        The date, in ISO 8601 format, when the message template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The default message template that's used for push notification channels.
         * </p>
         * 
         * @param defaultValue
         *        The default message template that's used for push notification channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(DefaultPushNotificationTemplate defaultValue);

        /**
         * <p>
         * The default message template that's used for push notification channels.
         * </p>
         * This is a convenience that creates an instance of the {@link DefaultPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link DefaultPushNotificationTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefaultPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultValue(DefaultPushNotificationTemplate)}.
         * 
         * @param defaultValue
         *        a consumer that will call methods on {@link DefaultPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValue(DefaultPushNotificationTemplate)
         */
        default Builder defaultValue(Consumer<DefaultPushNotificationTemplate.Builder> defaultValue) {
            return defaultValue(DefaultPushNotificationTemplate.builder().applyMutation(defaultValue).build());
        }

        /**
         * <p>
         * The JSON object that specifies the default values that are used for message variables in the message
         * template. This object is a set of key-value pairs. Each key defines a message variable in the template. The
         * corresponding value defines the default value for that variable.
         * </p>
         * 
         * @param defaultSubstitutions
         *        The JSON object that specifies the default values that are used for message variables in the message
         *        template. This object is a set of key-value pairs. Each key defines a message variable in the
         *        template. The corresponding value defines the default value for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubstitutions(String defaultSubstitutions);

        /**
         * <p>
         * The message template that's used for the GCM channel, which is used to send notifications through the
         * Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template
         * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param gcm
         *        The message template that's used for the GCM channel, which is used to send notifications through the
         *        Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template
         *        overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcm(AndroidPushNotificationTemplate gcm);

        /**
         * <p>
         * The message template that's used for the GCM channel, which is used to send notifications through the
         * Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template
         * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience that creates an instance of the {@link AndroidPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link AndroidPushNotificationTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AndroidPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #gcm(AndroidPushNotificationTemplate)}.
         * 
         * @param gcm
         *        a consumer that will call methods on {@link AndroidPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gcm(AndroidPushNotificationTemplate)
         */
        default Builder gcm(Consumer<AndroidPushNotificationTemplate.Builder> gcm) {
            return gcm(AndroidPushNotificationTemplate.builder().applyMutation(gcm).build());
        }

        /**
         * <p>
         * The date, in ISO 8601 format, when the message template was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date, in ISO 8601 format, when the message template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The unique identifier for the recommender model that's used by the message template.
         * </p>
         * 
         * @param recommenderId
         *        The unique identifier for the recommender model that's used by the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderId(String recommenderId);

        /**
         * <p>
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the message
         * template. Each tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that identifies the tags that are associated with the
         *        message template. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The custom description of the message template.
         * </p>
         * 
         * @param templateDescription
         *        The custom description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param templateName
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The type of channel that the message template is designed for. For a push notification template, this value
         * is PUSH.
         * </p>
         * 
         * @param templateType
         *        The type of channel that the message template is designed for. For a push notification template, this
         *        value is PUSH.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of channel that the message template is designed for. For a push notification template, this value
         * is PUSH.
         * </p>
         * 
         * @param templateType
         *        The type of channel that the message template is designed for. For a push notification template, this
         *        value is PUSH.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(TemplateType templateType);

        /**
         * <p>
         * The unique identifier, as an integer, for the active version of the message template, or the version of the
         * template that you specified by using the version parameter in your request.
         * </p>
         * 
         * @param version
         *        The unique identifier, as an integer, for the active version of the message template, or the version
         *        of the template that you specified by using the version parameter in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private AndroidPushNotificationTemplate adm;

        private APNSPushNotificationTemplate apns;

        private String arn;

        private AndroidPushNotificationTemplate baidu;

        private String creationDate;

        private DefaultPushNotificationTemplate defaultValue;

        private String defaultSubstitutions;

        private AndroidPushNotificationTemplate gcm;

        private String lastModifiedDate;

        private String recommenderId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private String templateName;

        private String templateType;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(PushNotificationTemplateResponse model) {
            adm(model.adm);
            apns(model.apns);
            arn(model.arn);
            baidu(model.baidu);
            creationDate(model.creationDate);
            defaultValue(model.defaultValue);
            defaultSubstitutions(model.defaultSubstitutions);
            gcm(model.gcm);
            lastModifiedDate(model.lastModifiedDate);
            recommenderId(model.recommenderId);
            tags(model.tags);
            templateDescription(model.templateDescription);
            templateName(model.templateName);
            templateType(model.templateType);
            version(model.version);
        }

        public final AndroidPushNotificationTemplate.Builder getAdm() {
            return adm != null ? adm.toBuilder() : null;
        }

        @Override
        public final Builder adm(AndroidPushNotificationTemplate adm) {
            this.adm = adm;
            return this;
        }

        public final void setAdm(AndroidPushNotificationTemplate.BuilderImpl adm) {
            this.adm = adm != null ? adm.build() : null;
        }

        public final APNSPushNotificationTemplate.Builder getApns() {
            return apns != null ? apns.toBuilder() : null;
        }

        @Override
        public final Builder apns(APNSPushNotificationTemplate apns) {
            this.apns = apns;
            return this;
        }

        public final void setApns(APNSPushNotificationTemplate.BuilderImpl apns) {
            this.apns = apns != null ? apns.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final AndroidPushNotificationTemplate.Builder getBaidu() {
            return baidu != null ? baidu.toBuilder() : null;
        }

        @Override
        public final Builder baidu(AndroidPushNotificationTemplate baidu) {
            this.baidu = baidu;
            return this;
        }

        public final void setBaidu(AndroidPushNotificationTemplate.BuilderImpl baidu) {
            this.baidu = baidu != null ? baidu.build() : null;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final DefaultPushNotificationTemplate.Builder getDefaultValue() {
            return defaultValue != null ? defaultValue.toBuilder() : null;
        }

        @Override
        public final Builder defaultValue(DefaultPushNotificationTemplate defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(DefaultPushNotificationTemplate.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        public final String getDefaultSubstitutions() {
            return defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        public final AndroidPushNotificationTemplate.Builder getGcm() {
            return gcm != null ? gcm.toBuilder() : null;
        }

        @Override
        public final Builder gcm(AndroidPushNotificationTemplate gcm) {
            this.gcm = gcm;
            return this;
        }

        public final void setGcm(AndroidPushNotificationTemplate.BuilderImpl gcm) {
            this.gcm = gcm != null ? gcm.build() : null;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getRecommenderId() {
            return recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getTemplateType() {
            return templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public PushNotificationTemplateResponse build() {
            return new PushNotificationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
