/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about which users and endpoints a message was sent to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendUsersMessageResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<SendUsersMessageResponse.Builder, SendUsersMessageResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(SendUsersMessageResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(SendUsersMessageResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Map<String, Map<String, EndpointMessageResult>>> RESULT_FIELD = SdkField
            .<Map<String, Map<String, EndpointMessageResult>>> builder(MarshallingType.MAP)
            .memberName("Result")
            .getter(getter(SendUsersMessageResponse::result))
            .setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, EndpointMessageResult>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<EndpointMessageResult> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(EndpointMessageResult::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            REQUEST_ID_FIELD, RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String requestId;

    private final Map<String, Map<String, EndpointMessageResult>> result;

    private SendUsersMessageResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.requestId = builder.requestId;
        this.result = builder.result;
    }

    /**
     * <p>
     * The unique identifier for the application that was used to send the message.
     * </p>
     * 
     * @return The unique identifier for the application that was used to send the message.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier that was assigned to the message request.
     * </p>
     * 
     * @return The unique identifier that was assigned to the message request.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * Returns true if the Result property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResult() {
        return result != null && !(result instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that indicates which endpoints the message was sent to, for each user. The object lists user IDs and,
     * for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID, it provides an
     * EndpointMessageResult object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResult()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that indicates which endpoints the message was sent to, for each user. The object lists user
     *         IDs and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID,
     *         it provides an EndpointMessageResult object.
     */
    public Map<String, Map<String, EndpointMessageResult>> result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessageResponse)) {
            return false;
        }
        SendUsersMessageResponse other = (SendUsersMessageResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendUsersMessageResponse").add("ApplicationId", applicationId()).add("RequestId", requestId())
                .add("Result", result()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessageResponse, T> g) {
        return obj -> g.apply((SendUsersMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendUsersMessageResponse> {
        /**
         * <p>
         * The unique identifier for the application that was used to send the message.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that was used to send the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier that was assigned to the message request.
         * </p>
         * 
         * @param requestId
         *        The unique identifier that was assigned to the message request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * An object that indicates which endpoints the message was sent to, for each user. The object lists user IDs
         * and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID, it
         * provides an EndpointMessageResult object.
         * </p>
         * 
         * @param result
         *        An object that indicates which endpoints the message was sent to, for each user. The object lists user
         *        IDs and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint
         *        ID, it provides an EndpointMessageResult object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Map<String, Map<String, EndpointMessageResult>> result);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String requestId;

        private Map<String, Map<String, EndpointMessageResult>> result = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessageResponse model) {
            applicationId(model.applicationId);
            requestId(model.requestId);
            result(model.result);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Map<String, Map<String, EndpointMessageResult>> getResult() {
            return result;
        }

        @Override
        public final Builder result(Map<String, Map<String, EndpointMessageResult>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copy(result);
            return this;
        }

        public final void setResult(Map<String, Map<String, EndpointMessageResult>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copy(result);
        }

        @Override
        public SendUsersMessageResponse build() {
            return new SendUsersMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
