/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecommenderConfigurationRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateRecommenderConfigurationRequest.Builder, UpdateRecommenderConfigurationRequest> {
    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommenderId").getter(getter(UpdateRecommenderConfigurationRequest::recommenderId))
            .setter(setter(Builder::recommenderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("recommender-id").build()).build();

    private static final SdkField<UpdateRecommenderConfiguration> UPDATE_RECOMMENDER_CONFIGURATION_FIELD = SdkField
            .<UpdateRecommenderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("UpdateRecommenderConfiguration")
            .getter(getter(UpdateRecommenderConfigurationRequest::updateRecommenderConfiguration))
            .setter(setter(Builder::updateRecommenderConfiguration))
            .constructor(UpdateRecommenderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRecommenderConfiguration")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ID_FIELD,
            UPDATE_RECOMMENDER_CONFIGURATION_FIELD));

    private final String recommenderId;

    private final UpdateRecommenderConfiguration updateRecommenderConfiguration;

    private UpdateRecommenderConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.recommenderId = builder.recommenderId;
        this.updateRecommenderConfiguration = builder.updateRecommenderConfiguration;
    }

    /**
     * <p>
     * The unique identifier for the recommender model configuration. This identifier is displayed as the <b>Recommender
     * ID</b> on the Amazon Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the recommender model configuration. This identifier is displayed as the
     *         <b>Recommender ID</b> on the Amazon Pinpoint console.
     */
    public String recommenderId() {
        return recommenderId;
    }

    /**
     * Returns the value of the UpdateRecommenderConfiguration property for this object.
     * 
     * @return The value of the UpdateRecommenderConfiguration property for this object.
     */
    public UpdateRecommenderConfiguration updateRecommenderConfiguration() {
        return updateRecommenderConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(updateRecommenderConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommenderConfigurationRequest)) {
            return false;
        }
        UpdateRecommenderConfigurationRequest other = (UpdateRecommenderConfigurationRequest) obj;
        return Objects.equals(recommenderId(), other.recommenderId())
                && Objects.equals(updateRecommenderConfiguration(), other.updateRecommenderConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRecommenderConfigurationRequest").add("RecommenderId", recommenderId())
                .add("UpdateRecommenderConfiguration", updateRecommenderConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommenderId":
            return Optional.ofNullable(clazz.cast(recommenderId()));
        case "UpdateRecommenderConfiguration":
            return Optional.ofNullable(clazz.cast(updateRecommenderConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommenderConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateRecommenderConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRecommenderConfigurationRequest> {
        /**
         * <p>
         * The unique identifier for the recommender model configuration. This identifier is displayed as the
         * <b>Recommender ID</b> on the Amazon Pinpoint console.
         * </p>
         * 
         * @param recommenderId
         *        The unique identifier for the recommender model configuration. This identifier is displayed as the
         *        <b>Recommender ID</b> on the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderId(String recommenderId);

        /**
         * Sets the value of the UpdateRecommenderConfiguration property for this object.
         *
         * @param updateRecommenderConfiguration
         *        The new value for the UpdateRecommenderConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateRecommenderConfiguration(UpdateRecommenderConfiguration updateRecommenderConfiguration);

        /**
         * Sets the value of the UpdateRecommenderConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link UpdateRecommenderConfiguration.Builder} avoiding
         * the need to create one manually via {@link UpdateRecommenderConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateRecommenderConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #updateRecommenderConfiguration(UpdateRecommenderConfiguration)}.
         * 
         * @param updateRecommenderConfiguration
         *        a consumer that will call methods on {@link UpdateRecommenderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateRecommenderConfiguration(UpdateRecommenderConfiguration)
         */
        default Builder updateRecommenderConfiguration(
                Consumer<UpdateRecommenderConfiguration.Builder> updateRecommenderConfiguration) {
            return updateRecommenderConfiguration(UpdateRecommenderConfiguration.builder()
                    .applyMutation(updateRecommenderConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String recommenderId;

        private UpdateRecommenderConfiguration updateRecommenderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommenderConfigurationRequest model) {
            super(model);
            recommenderId(model.recommenderId);
            updateRecommenderConfiguration(model.updateRecommenderConfiguration);
        }

        public final String getRecommenderId() {
            return recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        public final UpdateRecommenderConfiguration.Builder getUpdateRecommenderConfiguration() {
            return updateRecommenderConfiguration != null ? updateRecommenderConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder updateRecommenderConfiguration(UpdateRecommenderConfiguration updateRecommenderConfiguration) {
            this.updateRecommenderConfiguration = updateRecommenderConfiguration;
            return this;
        }

        public final void setUpdateRecommenderConfiguration(
                UpdateRecommenderConfiguration.BuilderImpl updateRecommenderConfiguration) {
            this.updateRecommenderConfiguration = updateRecommenderConfiguration != null ? updateRecommenderConfiguration.build()
                    : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecommenderConfigurationRequest build() {
            return new UpdateRecommenderConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
