/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the general settings and status of all channels for an application, including channels
 * that aren't enabled for the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelsResponse.Builder, ChannelsResponse> {
    private static final SdkField<Map<String, ChannelResponse>> CHANNELS_FIELD = SdkField
            .<Map<String, ChannelResponse>> builder(MarshallingType.MAP)
            .memberName("Channels")
            .getter(getter(ChannelsResponse::channels))
            .setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ChannelResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, ChannelResponse> channels;

    private ChannelsResponse(BuilderImpl builder) {
        this.channels = builder.channels;
    }

    /**
     * Returns true if the Channels property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains a multipart response for each channel. For each item in this object, the ChannelType is the
     * key and the Channel is the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChannels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains a multipart response for each channel. For each item in this object, the ChannelType
     *         is the key and the Channel is the value.
     */
    public Map<String, ChannelResponse> channels() {
        return channels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channels() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelsResponse)) {
            return false;
        }
        ChannelsResponse other = (ChannelsResponse) obj;
        return hasChannels() == other.hasChannels() && Objects.equals(channels(), other.channels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ChannelsResponse").add("Channels", hasChannels() ? channels() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelsResponse, T> g) {
        return obj -> g.apply((ChannelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelsResponse> {
        /**
         * <p>
         * A map that contains a multipart response for each channel. For each item in this object, the ChannelType is
         * the key and the Channel is the value.
         * </p>
         * 
         * @param channels
         *        A map that contains a multipart response for each channel. For each item in this object, the
         *        ChannelType is the key and the Channel is the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Map<String, ChannelResponse> channels);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ChannelResponse> channels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelsResponse model) {
            channels(model.channels);
        }

        public final Map<String, ChannelResponse.Builder> getChannels() {
            if (channels instanceof SdkAutoConstructMap) {
                return null;
            }
            return channels != null ? CollectionUtils.mapValues(channels, ChannelResponse::toBuilder) : null;
        }

        @Override
        public final Builder channels(Map<String, ChannelResponse> channels) {
            this.channels = MapOfChannelResponseCopier.copy(channels);
            return this;
        }

        public final void setChannels(Map<String, ChannelResponse.BuilderImpl> channels) {
            this.channels = MapOfChannelResponseCopier.copyFromBuilder(channels);
        }

        @Override
        public ChannelsResponse build() {
            return new ChannelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
