/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for an event that causes a journey activity to start.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventStartCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<EventStartCondition.Builder, EventStartCondition> {
    private static final SdkField<EventFilter> EVENT_FILTER_FIELD = SdkField.<EventFilter> builder(MarshallingType.SDK_POJO)
            .memberName("EventFilter").getter(getter(EventStartCondition::eventFilter)).setter(setter(Builder::eventFilter))
            .constructor(EventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentId").getter(getter(EventStartCondition::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FILTER_FIELD,
            SEGMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final EventFilter eventFilter;

    private final String segmentId;

    private EventStartCondition(BuilderImpl builder) {
        this.eventFilter = builder.eventFilter;
        this.segmentId = builder.segmentId;
    }

    /**
     * Returns the value of the EventFilter property for this object.
     * 
     * @return The value of the EventFilter property for this object.
     */
    public EventFilter eventFilter() {
        return eventFilter;
    }

    /**
     * Returns the value of the SegmentId property for this object.
     * 
     * @return The value of the SegmentId property for this object.
     */
    public String segmentId() {
        return segmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStartCondition)) {
            return false;
        }
        EventStartCondition other = (EventStartCondition) obj;
        return Objects.equals(eventFilter(), other.eventFilter()) && Objects.equals(segmentId(), other.segmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventStartCondition").add("EventFilter", eventFilter()).add("SegmentId", segmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventFilter":
            return Optional.ofNullable(clazz.cast(eventFilter()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventStartCondition, T> g) {
        return obj -> g.apply((EventStartCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventStartCondition> {
        /**
         * Sets the value of the EventFilter property for this object.
         *
         * @param eventFilter
         *        The new value for the EventFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(EventFilter eventFilter);

        /**
         * Sets the value of the EventFilter property for this object.
         *
         * This is a convenience that creates an instance of the {@link EventFilter.Builder} avoiding the need to create
         * one manually via {@link EventFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #eventFilter(EventFilter)}.
         * 
         * @param eventFilter
         *        a consumer that will call methods on {@link EventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFilter(EventFilter)
         */
        default Builder eventFilter(Consumer<EventFilter.Builder> eventFilter) {
            return eventFilter(EventFilter.builder().applyMutation(eventFilter).build());
        }

        /**
         * Sets the value of the SegmentId property for this object.
         *
         * @param segmentId
         *        The new value for the SegmentId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);
    }

    static final class BuilderImpl implements Builder {
        private EventFilter eventFilter;

        private String segmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(EventStartCondition model) {
            eventFilter(model.eventFilter);
            segmentId(model.segmentId);
        }

        public final EventFilter.Builder getEventFilter() {
            return eventFilter != null ? eventFilter.toBuilder() : null;
        }

        @Override
        public final Builder eventFilter(EventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final void setEventFilter(EventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public EventStartCondition build() {
            return new EventStartCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
