/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneySMSMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneySMSMessage.Builder, JourneySMSMessage> {
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(JourneySMSMessage::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderId").getter(getter(JourneySMSMessage::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TYPE_FIELD,
            SENDER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageType;

    private final String senderId;

    private JourneySMSMessage(BuilderImpl builder) {
        this.messageType = builder.messageType;
        this.senderId = builder.senderId;
    }

    /**
     * <p>
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a
     * one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing
     * messages).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive,
     *         such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such
     *         as marketing messages).
     * @see MessageType
     */
    public MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a
     * one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing
     * messages).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive,
     *         such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such
     *         as marketing messages).
     * @see MessageType
     */
    public String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by
     * country or region. For more information, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and
     * Regions</a> in the Amazon Pinpoint User Guide.
     * </p>
     * 
     * @return The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs
     *         varies by country or region. For more information, see <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported
     *         Countries and Regions</a> in the Amazon Pinpoint User Guide.
     */
    public String senderId() {
        return senderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneySMSMessage)) {
            return false;
        }
        JourneySMSMessage other = (JourneySMSMessage) obj;
        return Objects.equals(messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(senderId(), other.senderId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JourneySMSMessage").add("MessageType", messageTypeAsString()).add("SenderId", senderId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneySMSMessage, T> g) {
        return obj -> g.apply((JourneySMSMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneySMSMessage> {
        /**
         * <p>
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such
         * as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as
         * marketing messages).
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or
         *        time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or
         *        time-sensitive, such as marketing messages).
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such
         * as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as
         * marketing messages).
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or
         *        time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or
         *        time-sensitive, such as marketing messages).
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies
         * by country or region. For more information, see <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries
         * and Regions</a> in the Amazon Pinpoint User Guide.
         * </p>
         * 
         * @param senderId
         *        The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs
         *        varies by country or region. For more information, see <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported
         *        Countries and Regions</a> in the Amazon Pinpoint User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);
    }

    static final class BuilderImpl implements Builder {
        private String messageType;

        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneySMSMessage model) {
            messageType(model.messageType);
            senderId(model.senderId);
        }

        public final String getMessageType() {
            return messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getSenderId() {
            return senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public JourneySMSMessage build() {
            return new JourneySMSMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
