/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateEndpointRequest.Builder, UpdateEndpointRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(UpdateEndpointRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(UpdateEndpointRequest::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpoint-id").build()).build();

    private static final SdkField<EndpointRequest> ENDPOINT_REQUEST_FIELD = SdkField
            .<EndpointRequest> builder(MarshallingType.SDK_POJO)
            .memberName("EndpointRequest")
            .getter(getter(UpdateEndpointRequest::endpointRequest))
            .setter(setter(Builder::endpointRequest))
            .constructor(EndpointRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ENDPOINT_ID_FIELD, ENDPOINT_REQUEST_FIELD));

    private final String applicationId;

    private final String endpointId;

    private final EndpointRequest endpointRequest;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.endpointId = builder.endpointId;
        this.endpointRequest = builder.endpointRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the endpoint.
     * </p>
     * 
     * @return The unique identifier for the endpoint.
     */
    public String endpointId() {
        return endpointId;
    }

    /**
     * Returns the value of the EndpointRequest property for this object.
     * 
     * @return The value of the EndpointRequest property for this object.
     */
    public EndpointRequest endpointRequest() {
        return endpointRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(endpointId(), other.endpointId())
                && Objects.equals(endpointRequest(), other.endpointRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEndpointRequest").add("ApplicationId", applicationId()).add("EndpointId", endpointId())
                .add("EndpointRequest", endpointRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "EndpointRequest":
            return Optional.ofNullable(clazz.cast(endpointRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEndpointRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the endpoint.
         * </p>
         * 
         * @param endpointId
         *        The unique identifier for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * Sets the value of the EndpointRequest property for this object.
         *
         * @param endpointRequest
         *        The new value for the EndpointRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointRequest(EndpointRequest endpointRequest);

        /**
         * Sets the value of the EndpointRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link EndpointRequest.Builder} avoiding the need to
         * create one manually via {@link EndpointRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointRequest(EndpointRequest)}.
         * 
         * @param endpointRequest
         *        a consumer that will call methods on {@link EndpointRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointRequest(EndpointRequest)
         */
        default Builder endpointRequest(Consumer<EndpointRequest.Builder> endpointRequest) {
            return endpointRequest(EndpointRequest.builder().applyMutation(endpointRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String endpointId;

        private EndpointRequest endpointRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            applicationId(model.applicationId);
            endpointId(model.endpointId);
            endpointRequest(model.endpointRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final EndpointRequest.Builder getEndpointRequest() {
            return endpointRequest != null ? endpointRequest.toBuilder() : null;
        }

        @Override
        public final Builder endpointRequest(EndpointRequest endpointRequest) {
            this.endpointRequest = endpointRequest;
            return this;
        }

        public final void setEndpointRequest(EndpointRequest.BuilderImpl endpointRequest) {
            this.endpointRequest = endpointRequest != null ? endpointRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
