/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRecommenderConfigurationRequest extends PinpointRequest implements
        ToCopyableBuilder<CreateRecommenderConfigurationRequest.Builder, CreateRecommenderConfigurationRequest> {
    private static final SdkField<CreateRecommenderConfiguration> CREATE_RECOMMENDER_CONFIGURATION_FIELD = SdkField
            .<CreateRecommenderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CreateRecommenderConfiguration")
            .getter(getter(CreateRecommenderConfigurationRequest::createRecommenderConfiguration))
            .setter(setter(Builder::createRecommenderConfiguration))
            .constructor(CreateRecommenderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateRecommenderConfiguration")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATE_RECOMMENDER_CONFIGURATION_FIELD));

    private final CreateRecommenderConfiguration createRecommenderConfiguration;

    private CreateRecommenderConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.createRecommenderConfiguration = builder.createRecommenderConfiguration;
    }

    /**
     * Returns the value of the CreateRecommenderConfiguration property for this object.
     * 
     * @return The value of the CreateRecommenderConfiguration property for this object.
     */
    public CreateRecommenderConfiguration createRecommenderConfiguration() {
        return createRecommenderConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createRecommenderConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommenderConfigurationRequest)) {
            return false;
        }
        CreateRecommenderConfigurationRequest other = (CreateRecommenderConfigurationRequest) obj;
        return Objects.equals(createRecommenderConfiguration(), other.createRecommenderConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRecommenderConfigurationRequest")
                .add("CreateRecommenderConfiguration", createRecommenderConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateRecommenderConfiguration":
            return Optional.ofNullable(clazz.cast(createRecommenderConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommenderConfigurationRequest, T> g) {
        return obj -> g.apply((CreateRecommenderConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRecommenderConfigurationRequest> {
        /**
         * Sets the value of the CreateRecommenderConfiguration property for this object.
         *
         * @param createRecommenderConfiguration
         *        The new value for the CreateRecommenderConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createRecommenderConfiguration(CreateRecommenderConfiguration createRecommenderConfiguration);

        /**
         * Sets the value of the CreateRecommenderConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link CreateRecommenderConfiguration.Builder} avoiding
         * the need to create one manually via {@link CreateRecommenderConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateRecommenderConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #createRecommenderConfiguration(CreateRecommenderConfiguration)}.
         * 
         * @param createRecommenderConfiguration
         *        a consumer that will call methods on {@link CreateRecommenderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createRecommenderConfiguration(CreateRecommenderConfiguration)
         */
        default Builder createRecommenderConfiguration(
                Consumer<CreateRecommenderConfiguration.Builder> createRecommenderConfiguration) {
            return createRecommenderConfiguration(CreateRecommenderConfiguration.builder()
                    .applyMutation(createRecommenderConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private CreateRecommenderConfiguration createRecommenderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommenderConfigurationRequest model) {
            super(model);
            createRecommenderConfiguration(model.createRecommenderConfiguration);
        }

        public final CreateRecommenderConfiguration.Builder getCreateRecommenderConfiguration() {
            return createRecommenderConfiguration != null ? createRecommenderConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder createRecommenderConfiguration(CreateRecommenderConfiguration createRecommenderConfiguration) {
            this.createRecommenderConfiguration = createRecommenderConfiguration;
            return this;
        }

        public final void setCreateRecommenderConfiguration(
                CreateRecommenderConfiguration.BuilderImpl createRecommenderConfiguration) {
            this.createRecommenderConfiguration = createRecommenderConfiguration != null ? createRecommenderConfiguration.build()
                    : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRecommenderConfigurationRequest build() {
            return new CreateRecommenderConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
