/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default settings and content for a push notification that's sent directly to an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultPushNotificationMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultPushNotificationMessage.Builder, DefaultPushNotificationMessage> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(DefaultPushNotificationMessage::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(DefaultPushNotificationMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Data")
            .getter(getter(DefaultPushNotificationMessage::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SilentPush").getter(getter(DefaultPushNotificationMessage::silentPush))
            .setter(setter(Builder::silentPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Substitutions")
            .getter(getter(DefaultPushNotificationMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(DefaultPushNotificationMessage::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(DefaultPushNotificationMessage::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD,
            DATA_FIELD, SILENT_PUSH_FIELD, SUBSTITUTIONS_FIELD, TITLE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String body;

    private final Map<String, String> data;

    private final Boolean silentPush;

    private final Map<String, List<String>> substitutions;

    private final String title;

    private final String url;

    private DefaultPushNotificationMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.data = builder.data;
        this.silentPush = builder.silentPush;
        this.substitutions = builder.substitutions;
        this.title = builder.title;
        this.url = builder.url;
    }

    /**
     * <p>
     * The default action to occur if a recipient taps the push notification. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default
     * action.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     * deep-linking features of the iOS and Android platforms.
     * </p>
     * </li>
     * <li>
     * <p>
     * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     * specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The default action to occur if a recipient taps the push notification. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
     *         default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     *         deep-linking features of the iOS and Android platforms.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     *         specify.
     *         </p>
     *         </li>
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * The default action to occur if a recipient taps the push notification. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default
     * action.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     * deep-linking features of the iOS and Android platforms.
     * </p>
     * </li>
     * <li>
     * <p>
     * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     * specify.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The default action to occur if a recipient taps the push notification. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
     *         default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
     *         deep-linking features of the iOS and Android platforms.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
     *         specify.
     *         </p>
     *         </li>
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The default body of the notification message.
     * </p>
     * 
     * @return The default body of the notification message.
     */
    public String body() {
        return body;
    }

    /**
     * Returns true if the Data property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasData() {
        return data != null && !(data instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The JSON data payload to use for the default push notification, if the notification is a silent push
     * notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasData()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The JSON data payload to use for the default push notification, if the notification is a silent push
     *         notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
     */
    public Map<String, String> data() {
        return data;
    }

    /**
     * <p>
     * Specifies whether the default notification is a silent push notification, which is a push notification that
     * doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an
     * app's configuration or delivering messages to an in-app notification center.
     * </p>
     * 
     * @return Specifies whether the default notification is a silent push notification, which is a push notification
     *         that doesn't display on a recipient's device. Silent push notifications can be used for cases such as
     *         updating an app's configuration or delivering messages to an in-app notification center.
     */
    public Boolean silentPush() {
        return silentPush;
    }

    /**
     * Returns true if the Substitutions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubstitutions() {
        return substitutions != null && !(substitutions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The default message variables to use in the notification message. You can override the default variables with
     * individual address variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubstitutions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The default message variables to use in the notification message. You can override the default variables
     *         with individual address variables.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * <p>
     * The default title to display above the notification message on a recipient's device.
     * </p>
     * 
     * @return The default title to display above the notification message on a recipient's device.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The default URL to open in a recipient's default mobile browser, if a recipient taps the push notification and
     * the value of the Action property is URL.
     * </p>
     * 
     * @return The default URL to open in a recipient's default mobile browser, if a recipient taps the push
     *         notification and the value of the Action property is URL.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(hasData() ? data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubstitutions() ? substitutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPushNotificationMessage)) {
            return false;
        }
        DefaultPushNotificationMessage other = (DefaultPushNotificationMessage) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(body(), other.body())
                && hasData() == other.hasData() && Objects.equals(data(), other.data())
                && Objects.equals(silentPush(), other.silentPush()) && hasSubstitutions() == other.hasSubstitutions()
                && Objects.equals(substitutions(), other.substitutions()) && Objects.equals(title(), other.title())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DefaultPushNotificationMessage").add("Action", actionAsString()).add("Body", body())
                .add("Data", hasData() ? data() : null).add("SilentPush", silentPush())
                .add("Substitutions", hasSubstitutions() ? substitutions() : null).add("Title", title()).add("Url", url())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "SilentPush":
            return Optional.ofNullable(clazz.cast(silentPush()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultPushNotificationMessage, T> g) {
        return obj -> g.apply((DefaultPushNotificationMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultPushNotificationMessage> {
        /**
         * <p>
         * The default action to occur if a recipient taps the push notification. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         * deep-linking features of the iOS and Android platforms.
         * </p>
         * </li>
         * <li>
         * <p>
         * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
         * specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The default action to occur if a recipient taps the push notification. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is
         *        the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         *        deep-linking features of the iOS and Android platforms.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that
         *        you specify.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * The default action to occur if a recipient taps the push notification. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         * deep-linking features of the iOS and Android platforms.
         * </p>
         * </li>
         * <li>
         * <p>
         * URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you
         * specify.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The default action to occur if a recipient taps the push notification. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is
         *        the default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the
         *        deep-linking features of the iOS and Android platforms.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that
         *        you specify.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * The default body of the notification message.
         * </p>
         * 
         * @param body
         *        The default body of the notification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The JSON data payload to use for the default push notification, if the notification is a silent push
         * notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
         * </p>
         * 
         * @param data
         *        The JSON data payload to use for the default push notification, if the notification is a silent push
         *        notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Map<String, String> data);

        /**
         * <p>
         * Specifies whether the default notification is a silent push notification, which is a push notification that
         * doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an
         * app's configuration or delivering messages to an in-app notification center.
         * </p>
         * 
         * @param silentPush
         *        Specifies whether the default notification is a silent push notification, which is a push notification
         *        that doesn't display on a recipient's device. Silent push notifications can be used for cases such as
         *        updating an app's configuration or delivering messages to an in-app notification center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silentPush(Boolean silentPush);

        /**
         * <p>
         * The default message variables to use in the notification message. You can override the default variables with
         * individual address variables.
         * </p>
         * 
         * @param substitutions
         *        The default message variables to use in the notification message. You can override the default
         *        variables with individual address variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * <p>
         * The default title to display above the notification message on a recipient's device.
         * </p>
         * 
         * @param title
         *        The default title to display above the notification message on a recipient's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The default URL to open in a recipient's default mobile browser, if a recipient taps the push notification
         * and the value of the Action property is URL.
         * </p>
         * 
         * @param url
         *        The default URL to open in a recipient's default mobile browser, if a recipient taps the push
         *        notification and the value of the Action property is URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String body;

        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();

        private Boolean silentPush;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private String title;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultPushNotificationMessage model) {
            action(model.action);
            body(model.body);
            data(model.data);
            silentPush(model.silentPush);
            substitutions(model.substitutions);
            title(model.title);
            url(model.url);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getData() {
            if (data instanceof SdkAutoConstructMap) {
                return null;
            }
            return data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final Boolean getSilentPush() {
            return silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public DefaultPushNotificationMessage build() {
            return new DefaultPushNotificationMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
