/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.AddressConfiguration;
import software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration;
import software.amazon.awssdk.services.pinpoint.model.MapOfAddressConfigurationCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOfEndpointSendConfigurationCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageRequest> {
    private static final SdkField<Map<String, AddressConfiguration>> ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Addresses").getter(MessageRequest.getter(MessageRequest::addresses)).setter(MessageRequest.setter(Builder::addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddressConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Context").getter(MessageRequest.getter(MessageRequest::context)).setter(MessageRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, EndpointSendConfiguration>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Endpoints").getter(MessageRequest.getter(MessageRequest::endpoints)).setter(MessageRequest.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointSendConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DirectMessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageConfiguration").getter(MessageRequest.getter(MessageRequest::messageConfiguration)).setter(MessageRequest.setter(Builder::messageConfiguration)).constructor(DirectMessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateConfiguration").getter(MessageRequest.getter(MessageRequest::templateConfiguration)).setter(MessageRequest.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TraceId").getter(MessageRequest.getter(MessageRequest::traceId)).setter(MessageRequest.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESSES_FIELD, CONTEXT_FIELD, ENDPOINTS_FIELD, MESSAGE_CONFIGURATION_FIELD, TEMPLATE_CONFIGURATION_FIELD, TRACE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AddressConfiguration> addresses;
    private final Map<String, String> context;
    private final Map<String, EndpointSendConfiguration> endpoints;
    private final DirectMessageConfiguration messageConfiguration;
    private final TemplateConfiguration templateConfiguration;
    private final String traceId;

    private MessageRequest(BuilderImpl builder) {
        this.addresses = builder.addresses;
        this.context = builder.context;
        this.endpoints = builder.endpoints;
        this.messageConfiguration = builder.messageConfiguration;
        this.templateConfiguration = builder.templateConfiguration;
        this.traceId = builder.traceId;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !(this.addresses instanceof SdkAutoConstructMap);
    }

    public Map<String, AddressConfiguration> addresses() {
        return this.addresses;
    }

    public boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public Map<String, String> context() {
        return this.context;
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructMap);
    }

    public Map<String, EndpointSendConfiguration> endpoints() {
        return this.endpoints;
    }

    public DirectMessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public String traceId() {
        return this.traceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddresses() ? this.addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageRequest)) {
            return false;
        }
        MessageRequest other = (MessageRequest)obj;
        return this.hasAddresses() == other.hasAddresses() && Objects.equals(this.addresses(), other.addresses()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.traceId(), other.traceId());
    }

    public String toString() {
        return ToString.builder((String)"MessageRequest").add("Addresses", this.hasAddresses() ? this.addresses() : null).add("Context", this.hasContext() ? this.context() : null).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("MessageConfiguration", (Object)this.messageConfiguration()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TraceId", (Object)this.traceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Addresses": {
                return Optional.ofNullable(clazz.cast(this.addresses()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "TraceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageRequest, T> g) {
        return obj -> g.apply((MessageRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AddressConfiguration> addresses = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, EndpointSendConfiguration> endpoints = DefaultSdkAutoConstructMap.getInstance();
        private DirectMessageConfiguration messageConfiguration;
        private TemplateConfiguration templateConfiguration;
        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageRequest model) {
            this.addresses(model.addresses);
            this.context(model.context);
            this.endpoints(model.endpoints);
            this.messageConfiguration(model.messageConfiguration);
            this.templateConfiguration(model.templateConfiguration);
            this.traceId(model.traceId);
        }

        public final Map<String, AddressConfiguration.Builder> getAddresses() {
            if (this.addresses instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.addresses != null ? CollectionUtils.mapValues(this.addresses, AddressConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder addresses(Map<String, AddressConfiguration> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copy(addresses);
            return this;
        }

        public final void setAddresses(Map<String, AddressConfiguration.BuilderImpl> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copyFromBuilder(addresses);
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final Map<String, EndpointSendConfiguration.Builder> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.endpoints != null ? CollectionUtils.mapValues(this.endpoints, EndpointSendConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder endpoints(Map<String, EndpointSendConfiguration> endpoints) {
            this.endpoints = MapOfEndpointSendConfigurationCopier.copy(endpoints);
            return this;
        }

        public final void setEndpoints(Map<String, EndpointSendConfiguration.BuilderImpl> endpoints) {
            this.endpoints = MapOfEndpointSendConfigurationCopier.copyFromBuilder(endpoints);
        }

        public final DirectMessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(DirectMessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public MessageRequest build() {
            return new MessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageRequest> {
        public Builder addresses(Map<String, AddressConfiguration> var1);

        public Builder context(Map<String, String> var1);

        public Builder endpoints(Map<String, EndpointSendConfiguration> var1);

        public Builder messageConfiguration(DirectMessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<DirectMessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((DirectMessageConfiguration)((DirectMessageConfiguration.Builder)DirectMessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder traceId(String var1);
    }
}

