/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration and other settings for an activity in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Activity implements SdkPojo, Serializable, ToCopyableBuilder<Activity.Builder, Activity> {
    private static final SdkField<CustomMessageActivity> CUSTOM_FIELD = SdkField
            .<CustomMessageActivity> builder(MarshallingType.SDK_POJO).memberName("CUSTOM").getter(getter(Activity::custom))
            .setter(setter(Builder::custom)).constructor(CustomMessageActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CUSTOM").build()).build();

    private static final SdkField<ConditionalSplitActivity> CONDITIONAL_SPLIT_FIELD = SdkField
            .<ConditionalSplitActivity> builder(MarshallingType.SDK_POJO).memberName("ConditionalSplit")
            .getter(getter(Activity::conditionalSplit)).setter(setter(Builder::conditionalSplit))
            .constructor(ConditionalSplitActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalSplit").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Activity::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<EmailMessageActivity> EMAIL_FIELD = SdkField
            .<EmailMessageActivity> builder(MarshallingType.SDK_POJO).memberName("EMAIL").getter(getter(Activity::email))
            .setter(setter(Builder::email)).constructor(EmailMessageActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EMAIL").build()).build();

    private static final SdkField<HoldoutActivity> HOLDOUT_FIELD = SdkField.<HoldoutActivity> builder(MarshallingType.SDK_POJO)
            .memberName("Holdout").getter(getter(Activity::holdout)).setter(setter(Builder::holdout))
            .constructor(HoldoutActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Holdout").build()).build();

    private static final SdkField<MultiConditionalSplitActivity> MULTI_CONDITION_FIELD = SdkField
            .<MultiConditionalSplitActivity> builder(MarshallingType.SDK_POJO).memberName("MultiCondition")
            .getter(getter(Activity::multiCondition)).setter(setter(Builder::multiCondition))
            .constructor(MultiConditionalSplitActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiCondition").build()).build();

    private static final SdkField<PushMessageActivity> PUSH_FIELD = SdkField
            .<PushMessageActivity> builder(MarshallingType.SDK_POJO).memberName("PUSH").getter(getter(Activity::push))
            .setter(setter(Builder::push)).constructor(PushMessageActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PUSH").build()).build();

    private static final SdkField<RandomSplitActivity> RANDOM_SPLIT_FIELD = SdkField
            .<RandomSplitActivity> builder(MarshallingType.SDK_POJO).memberName("RandomSplit")
            .getter(getter(Activity::randomSplit)).setter(setter(Builder::randomSplit)).constructor(RandomSplitActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RandomSplit").build()).build();

    private static final SdkField<SMSMessageActivity> SMS_FIELD = SdkField.<SMSMessageActivity> builder(MarshallingType.SDK_POJO)
            .memberName("SMS").getter(getter(Activity::sms)).setter(setter(Builder::sms))
            .constructor(SMSMessageActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMS").build()).build();

    private static final SdkField<WaitActivity> WAIT_FIELD = SdkField.<WaitActivity> builder(MarshallingType.SDK_POJO)
            .memberName("Wait").getter(getter(Activity::waitValue)).setter(setter(Builder::waitValue))
            .constructor(WaitActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Wait").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_FIELD,
            CONDITIONAL_SPLIT_FIELD, DESCRIPTION_FIELD, EMAIL_FIELD, HOLDOUT_FIELD, MULTI_CONDITION_FIELD, PUSH_FIELD,
            RANDOM_SPLIT_FIELD, SMS_FIELD, WAIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomMessageActivity custom;

    private final ConditionalSplitActivity conditionalSplit;

    private final String description;

    private final EmailMessageActivity email;

    private final HoldoutActivity holdout;

    private final MultiConditionalSplitActivity multiCondition;

    private final PushMessageActivity push;

    private final RandomSplitActivity randomSplit;

    private final SMSMessageActivity sms;

    private final WaitActivity wait;

    private Activity(BuilderImpl builder) {
        this.custom = builder.custom;
        this.conditionalSplit = builder.conditionalSplit;
        this.description = builder.description;
        this.email = builder.email;
        this.holdout = builder.holdout;
        this.multiCondition = builder.multiCondition;
        this.push = builder.push;
        this.randomSplit = builder.randomSplit;
        this.sms = builder.sms;
        this.wait = builder.wait;
    }

    /**
     * <p>
     * The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that
     * sends messages to participants.
     * </p>
     * 
     * @return The settings for a custom message activity. This type of activity calls an AWS Lambda function or web
     *         hook that sends messages to participants.
     */
    public final CustomMessageActivity custom() {
        return custom;
    }

    /**
     * <p>
     * The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a
     * journey, based on conditions that you specify.
     * </p>
     * 
     * @return The settings for a yes/no split activity. This type of activity sends participants down one of two paths
     *         in a journey, based on conditions that you specify.
     */
    public final ConditionalSplitActivity conditionalSplit() {
        return conditionalSplit;
    }

    /**
     * <p>
     * The custom description of the activity.
     * </p>
     * 
     * @return The custom description of the activity.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The settings for an email activity. This type of activity sends an email message to participants.
     * </p>
     * 
     * @return The settings for an email activity. This type of activity sends an email message to participants.
     */
    public final EmailMessageActivity email() {
        return email;
    }

    /**
     * <p>
     * The settings for a holdout activity. This type of activity stops a journey for a specified percentage of
     * participants.
     * </p>
     * 
     * @return The settings for a holdout activity. This type of activity stops a journey for a specified percentage of
     *         participants.
     */
    public final HoldoutActivity holdout() {
        return holdout;
    }

    /**
     * <p>
     * The settings for a multivariate split activity. This type of activity sends participants down one of as many as
     * five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.
     * </p>
     * 
     * @return The settings for a multivariate split activity. This type of activity sends participants down one of as
     *         many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you
     *         specify.
     */
    public final MultiConditionalSplitActivity multiCondition() {
        return multiCondition;
    }

    /**
     * <p>
     * The settings for a push notification activity. This type of activity sends a push notification to participants.
     * </p>
     * 
     * @return The settings for a push notification activity. This type of activity sends a push notification to
     *         participants.
     */
    public final PushMessageActivity push() {
        return push;
    }

    /**
     * <p>
     * The settings for a random split activity. This type of activity randomly sends specified percentages of
     * participants down one of as many as five paths in a journey, based on conditions that you specify.
     * </p>
     * 
     * @return The settings for a random split activity. This type of activity randomly sends specified percentages of
     *         participants down one of as many as five paths in a journey, based on conditions that you specify.
     */
    public final RandomSplitActivity randomSplit() {
        return randomSplit;
    }

    /**
     * <p>
     * The settings for an SMS activity. This type of activity sends a text message to participants.
     * </p>
     * 
     * @return The settings for an SMS activity. This type of activity sends a text message to participants.
     */
    public final SMSMessageActivity sms() {
        return sms;
    }

    /**
     * <p>
     * The settings for a wait activity. This type of activity waits for a certain amount of time or until a specific
     * date and time before moving participants to the next activity in a journey.
     * </p>
     * 
     * @return The settings for a wait activity. This type of activity waits for a certain amount of time or until a
     *         specific date and time before moving participants to the next activity in a journey.
     */
    public final WaitActivity waitValue() {
        return wait;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        hashCode = 31 * hashCode + Objects.hashCode(conditionalSplit());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(holdout());
        hashCode = 31 * hashCode + Objects.hashCode(multiCondition());
        hashCode = 31 * hashCode + Objects.hashCode(push());
        hashCode = 31 * hashCode + Objects.hashCode(randomSplit());
        hashCode = 31 * hashCode + Objects.hashCode(sms());
        hashCode = 31 * hashCode + Objects.hashCode(waitValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity) obj;
        return Objects.equals(custom(), other.custom()) && Objects.equals(conditionalSplit(), other.conditionalSplit())
                && Objects.equals(description(), other.description()) && Objects.equals(email(), other.email())
                && Objects.equals(holdout(), other.holdout()) && Objects.equals(multiCondition(), other.multiCondition())
                && Objects.equals(push(), other.push()) && Objects.equals(randomSplit(), other.randomSplit())
                && Objects.equals(sms(), other.sms()) && Objects.equals(waitValue(), other.waitValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Activity").add("CUSTOM", custom()).add("ConditionalSplit", conditionalSplit())
                .add("Description", description()).add("EMAIL", email()).add("Holdout", holdout())
                .add("MultiCondition", multiCondition()).add("PUSH", push()).add("RandomSplit", randomSplit()).add("SMS", sms())
                .add("Wait", waitValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CUSTOM":
            return Optional.ofNullable(clazz.cast(custom()));
        case "ConditionalSplit":
            return Optional.ofNullable(clazz.cast(conditionalSplit()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EMAIL":
            return Optional.ofNullable(clazz.cast(email()));
        case "Holdout":
            return Optional.ofNullable(clazz.cast(holdout()));
        case "MultiCondition":
            return Optional.ofNullable(clazz.cast(multiCondition()));
        case "PUSH":
            return Optional.ofNullable(clazz.cast(push()));
        case "RandomSplit":
            return Optional.ofNullable(clazz.cast(randomSplit()));
        case "SMS":
            return Optional.ofNullable(clazz.cast(sms()));
        case "Wait":
            return Optional.ofNullable(clazz.cast(waitValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Activity, T> g) {
        return obj -> g.apply((Activity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Activity> {
        /**
         * <p>
         * The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook
         * that sends messages to participants.
         * </p>
         * 
         * @param custom
         *        The settings for a custom message activity. This type of activity calls an AWS Lambda function or web
         *        hook that sends messages to participants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(CustomMessageActivity custom);

        /**
         * <p>
         * The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook
         * that sends messages to participants.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomMessageActivity.Builder} avoiding the need
         * to create one manually via {@link CustomMessageActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomMessageActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #custom(CustomMessageActivity)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link CustomMessageActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(CustomMessageActivity)
         */
        default Builder custom(Consumer<CustomMessageActivity.Builder> custom) {
            return custom(CustomMessageActivity.builder().applyMutation(custom).build());
        }

        /**
         * <p>
         * The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a
         * journey, based on conditions that you specify.
         * </p>
         * 
         * @param conditionalSplit
         *        The settings for a yes/no split activity. This type of activity sends participants down one of two
         *        paths in a journey, based on conditions that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalSplit(ConditionalSplitActivity conditionalSplit);

        /**
         * <p>
         * The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a
         * journey, based on conditions that you specify.
         * </p>
         * This is a convenience that creates an instance of the {@link ConditionalSplitActivity.Builder} avoiding the
         * need to create one manually via {@link ConditionalSplitActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConditionalSplitActivity.Builder#build()} is called immediately
         * and its result is passed to {@link #conditionalSplit(ConditionalSplitActivity)}.
         * 
         * @param conditionalSplit
         *        a consumer that will call methods on {@link ConditionalSplitActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionalSplit(ConditionalSplitActivity)
         */
        default Builder conditionalSplit(Consumer<ConditionalSplitActivity.Builder> conditionalSplit) {
            return conditionalSplit(ConditionalSplitActivity.builder().applyMutation(conditionalSplit).build());
        }

        /**
         * <p>
         * The custom description of the activity.
         * </p>
         * 
         * @param description
         *        The custom description of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The settings for an email activity. This type of activity sends an email message to participants.
         * </p>
         * 
         * @param email
         *        The settings for an email activity. This type of activity sends an email message to participants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(EmailMessageActivity email);

        /**
         * <p>
         * The settings for an email activity. This type of activity sends an email message to participants.
         * </p>
         * This is a convenience that creates an instance of the {@link EmailMessageActivity.Builder} avoiding the need
         * to create one manually via {@link EmailMessageActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailMessageActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #email(EmailMessageActivity)}.
         * 
         * @param email
         *        a consumer that will call methods on {@link EmailMessageActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(EmailMessageActivity)
         */
        default Builder email(Consumer<EmailMessageActivity.Builder> email) {
            return email(EmailMessageActivity.builder().applyMutation(email).build());
        }

        /**
         * <p>
         * The settings for a holdout activity. This type of activity stops a journey for a specified percentage of
         * participants.
         * </p>
         * 
         * @param holdout
         *        The settings for a holdout activity. This type of activity stops a journey for a specified percentage
         *        of participants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder holdout(HoldoutActivity holdout);

        /**
         * <p>
         * The settings for a holdout activity. This type of activity stops a journey for a specified percentage of
         * participants.
         * </p>
         * This is a convenience that creates an instance of the {@link HoldoutActivity.Builder} avoiding the need to
         * create one manually via {@link HoldoutActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link HoldoutActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #holdout(HoldoutActivity)}.
         * 
         * @param holdout
         *        a consumer that will call methods on {@link HoldoutActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #holdout(HoldoutActivity)
         */
        default Builder holdout(Consumer<HoldoutActivity.Builder> holdout) {
            return holdout(HoldoutActivity.builder().applyMutation(holdout).build());
        }

        /**
         * <p>
         * The settings for a multivariate split activity. This type of activity sends participants down one of as many
         * as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.
         * </p>
         * 
         * @param multiCondition
         *        The settings for a multivariate split activity. This type of activity sends participants down one of
         *        as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that
         *        you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiCondition(MultiConditionalSplitActivity multiCondition);

        /**
         * <p>
         * The settings for a multivariate split activity. This type of activity sends participants down one of as many
         * as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.
         * </p>
         * This is a convenience that creates an instance of the {@link MultiConditionalSplitActivity.Builder} avoiding
         * the need to create one manually via {@link MultiConditionalSplitActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiConditionalSplitActivity.Builder#build()} is called
         * immediately and its result is passed to {@link #multiCondition(MultiConditionalSplitActivity)}.
         * 
         * @param multiCondition
         *        a consumer that will call methods on {@link MultiConditionalSplitActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiCondition(MultiConditionalSplitActivity)
         */
        default Builder multiCondition(Consumer<MultiConditionalSplitActivity.Builder> multiCondition) {
            return multiCondition(MultiConditionalSplitActivity.builder().applyMutation(multiCondition).build());
        }

        /**
         * <p>
         * The settings for a push notification activity. This type of activity sends a push notification to
         * participants.
         * </p>
         * 
         * @param push
         *        The settings for a push notification activity. This type of activity sends a push notification to
         *        participants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder push(PushMessageActivity push);

        /**
         * <p>
         * The settings for a push notification activity. This type of activity sends a push notification to
         * participants.
         * </p>
         * This is a convenience that creates an instance of the {@link PushMessageActivity.Builder} avoiding the need
         * to create one manually via {@link PushMessageActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link PushMessageActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #push(PushMessageActivity)}.
         * 
         * @param push
         *        a consumer that will call methods on {@link PushMessageActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #push(PushMessageActivity)
         */
        default Builder push(Consumer<PushMessageActivity.Builder> push) {
            return push(PushMessageActivity.builder().applyMutation(push).build());
        }

        /**
         * <p>
         * The settings for a random split activity. This type of activity randomly sends specified percentages of
         * participants down one of as many as five paths in a journey, based on conditions that you specify.
         * </p>
         * 
         * @param randomSplit
         *        The settings for a random split activity. This type of activity randomly sends specified percentages
         *        of participants down one of as many as five paths in a journey, based on conditions that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder randomSplit(RandomSplitActivity randomSplit);

        /**
         * <p>
         * The settings for a random split activity. This type of activity randomly sends specified percentages of
         * participants down one of as many as five paths in a journey, based on conditions that you specify.
         * </p>
         * This is a convenience that creates an instance of the {@link RandomSplitActivity.Builder} avoiding the need
         * to create one manually via {@link RandomSplitActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link RandomSplitActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #randomSplit(RandomSplitActivity)}.
         * 
         * @param randomSplit
         *        a consumer that will call methods on {@link RandomSplitActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #randomSplit(RandomSplitActivity)
         */
        default Builder randomSplit(Consumer<RandomSplitActivity.Builder> randomSplit) {
            return randomSplit(RandomSplitActivity.builder().applyMutation(randomSplit).build());
        }

        /**
         * <p>
         * The settings for an SMS activity. This type of activity sends a text message to participants.
         * </p>
         * 
         * @param sms
         *        The settings for an SMS activity. This type of activity sends a text message to participants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(SMSMessageActivity sms);

        /**
         * <p>
         * The settings for an SMS activity. This type of activity sends a text message to participants.
         * </p>
         * This is a convenience that creates an instance of the {@link SMSMessageActivity.Builder} avoiding the need to
         * create one manually via {@link SMSMessageActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link SMSMessageActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #sms(SMSMessageActivity)}.
         * 
         * @param sms
         *        a consumer that will call methods on {@link SMSMessageActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sms(SMSMessageActivity)
         */
        default Builder sms(Consumer<SMSMessageActivity.Builder> sms) {
            return sms(SMSMessageActivity.builder().applyMutation(sms).build());
        }

        /**
         * <p>
         * The settings for a wait activity. This type of activity waits for a certain amount of time or until a
         * specific date and time before moving participants to the next activity in a journey.
         * </p>
         * 
         * @param wait
         *        The settings for a wait activity. This type of activity waits for a certain amount of time or until a
         *        specific date and time before moving participants to the next activity in a journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitValue(WaitActivity wait);

        /**
         * <p>
         * The settings for a wait activity. This type of activity waits for a certain amount of time or until a
         * specific date and time before moving participants to the next activity in a journey.
         * </p>
         * This is a convenience that creates an instance of the {@link WaitActivity.Builder} avoiding the need to
         * create one manually via {@link WaitActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link WaitActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #waitValue(WaitActivity)}.
         * 
         * @param wait
         *        a consumer that will call methods on {@link WaitActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitValue(WaitActivity)
         */
        default Builder waitValue(Consumer<WaitActivity.Builder> wait) {
            return waitValue(WaitActivity.builder().applyMutation(wait).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomMessageActivity custom;

        private ConditionalSplitActivity conditionalSplit;

        private String description;

        private EmailMessageActivity email;

        private HoldoutActivity holdout;

        private MultiConditionalSplitActivity multiCondition;

        private PushMessageActivity push;

        private RandomSplitActivity randomSplit;

        private SMSMessageActivity sms;

        private WaitActivity wait;

        private BuilderImpl() {
        }

        private BuilderImpl(Activity model) {
            custom(model.custom);
            conditionalSplit(model.conditionalSplit);
            description(model.description);
            email(model.email);
            holdout(model.holdout);
            multiCondition(model.multiCondition);
            push(model.push);
            randomSplit(model.randomSplit);
            sms(model.sms);
            waitValue(model.wait);
        }

        public final CustomMessageActivity.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        @Override
        public final Builder custom(CustomMessageActivity custom) {
            this.custom = custom;
            return this;
        }

        public final void setCustom(CustomMessageActivity.BuilderImpl custom) {
            this.custom = custom != null ? custom.build() : null;
        }

        public final ConditionalSplitActivity.Builder getConditionalSplit() {
            return conditionalSplit != null ? conditionalSplit.toBuilder() : null;
        }

        @Override
        public final Builder conditionalSplit(ConditionalSplitActivity conditionalSplit) {
            this.conditionalSplit = conditionalSplit;
            return this;
        }

        public final void setConditionalSplit(ConditionalSplitActivity.BuilderImpl conditionalSplit) {
            this.conditionalSplit = conditionalSplit != null ? conditionalSplit.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final EmailMessageActivity.Builder getEmail() {
            return email != null ? email.toBuilder() : null;
        }

        @Override
        public final Builder email(EmailMessageActivity email) {
            this.email = email;
            return this;
        }

        public final void setEmail(EmailMessageActivity.BuilderImpl email) {
            this.email = email != null ? email.build() : null;
        }

        public final HoldoutActivity.Builder getHoldout() {
            return holdout != null ? holdout.toBuilder() : null;
        }

        @Override
        public final Builder holdout(HoldoutActivity holdout) {
            this.holdout = holdout;
            return this;
        }

        public final void setHoldout(HoldoutActivity.BuilderImpl holdout) {
            this.holdout = holdout != null ? holdout.build() : null;
        }

        public final MultiConditionalSplitActivity.Builder getMultiCondition() {
            return multiCondition != null ? multiCondition.toBuilder() : null;
        }

        @Override
        public final Builder multiCondition(MultiConditionalSplitActivity multiCondition) {
            this.multiCondition = multiCondition;
            return this;
        }

        public final void setMultiCondition(MultiConditionalSplitActivity.BuilderImpl multiCondition) {
            this.multiCondition = multiCondition != null ? multiCondition.build() : null;
        }

        public final PushMessageActivity.Builder getPush() {
            return push != null ? push.toBuilder() : null;
        }

        @Override
        public final Builder push(PushMessageActivity push) {
            this.push = push;
            return this;
        }

        public final void setPush(PushMessageActivity.BuilderImpl push) {
            this.push = push != null ? push.build() : null;
        }

        public final RandomSplitActivity.Builder getRandomSplit() {
            return randomSplit != null ? randomSplit.toBuilder() : null;
        }

        @Override
        public final Builder randomSplit(RandomSplitActivity randomSplit) {
            this.randomSplit = randomSplit;
            return this;
        }

        public final void setRandomSplit(RandomSplitActivity.BuilderImpl randomSplit) {
            this.randomSplit = randomSplit != null ? randomSplit.build() : null;
        }

        public final SMSMessageActivity.Builder getSms() {
            return sms != null ? sms.toBuilder() : null;
        }

        @Override
        public final Builder sms(SMSMessageActivity sms) {
            this.sms = sms;
            return this;
        }

        public final void setSms(SMSMessageActivity.BuilderImpl sms) {
            this.sms = sms != null ? sms.build() : null;
        }

        public final WaitActivity.Builder getWaitValue() {
            return wait != null ? wait.toBuilder() : null;
        }

        @Override
        public final Builder waitValue(WaitActivity wait) {
            this.wait = wait;
            return this;
        }

        public final void setWaitValue(WaitActivity.BuilderImpl wait) {
            this.wait = wait != null ? wait.build() : null;
        }

        @Override
        public Activity build() {
            return new Activity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
