/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApnsChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateApnsChannelRequest> {
    private static final SdkField<APNSChannelRequest> APNS_CHANNEL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("APNSChannelRequest").getter(UpdateApnsChannelRequest.getter(UpdateApnsChannelRequest::apnsChannelRequest)).setter(UpdateApnsChannelRequest.setter(Builder::apnsChannelRequest)).constructor(APNSChannelRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSChannelRequest").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateApnsChannelRequest.getter(UpdateApnsChannelRequest::applicationId)).setter(UpdateApnsChannelRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APNS_CHANNEL_REQUEST_FIELD, APPLICATION_ID_FIELD));
    private final APNSChannelRequest apnsChannelRequest;
    private final String applicationId;

    private UpdateApnsChannelRequest(BuilderImpl builder) {
        super(builder);
        this.apnsChannelRequest = builder.apnsChannelRequest;
        this.applicationId = builder.applicationId;
    }

    public final APNSChannelRequest apnsChannelRequest() {
        return this.apnsChannelRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apnsChannelRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApnsChannelRequest)) {
            return false;
        }
        UpdateApnsChannelRequest other = (UpdateApnsChannelRequest)((Object)obj);
        return Objects.equals(this.apnsChannelRequest(), other.apnsChannelRequest()) && Objects.equals(this.applicationId(), other.applicationId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApnsChannelRequest").add("APNSChannelRequest", (Object)this.apnsChannelRequest()).add("ApplicationId", (Object)this.applicationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "APNSChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.apnsChannelRequest()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApnsChannelRequest, T> g) {
        return obj -> g.apply((UpdateApnsChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private APNSChannelRequest apnsChannelRequest;
        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApnsChannelRequest model) {
            super(model);
            this.apnsChannelRequest(model.apnsChannelRequest);
            this.applicationId(model.applicationId);
        }

        public final APNSChannelRequest.Builder getApnsChannelRequest() {
            return this.apnsChannelRequest != null ? this.apnsChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder apnsChannelRequest(APNSChannelRequest apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest;
            return this;
        }

        public final void setApnsChannelRequest(APNSChannelRequest.BuilderImpl apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest != null ? apnsChannelRequest.build() : null;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApnsChannelRequest build() {
            return new UpdateApnsChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApnsChannelRequest> {
        public Builder apnsChannelRequest(APNSChannelRequest var1);

        default public Builder apnsChannelRequest(Consumer<APNSChannelRequest.Builder> apnsChannelRequest) {
            return this.apnsChannelRequest((APNSChannelRequest)((APNSChannelRequest.Builder)APNSChannelRequest.builder().applyMutation(apnsChannelRequest)).build());
        }

        public Builder applicationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

