/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender
 * model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRecommenderConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateRecommenderConfiguration.Builder, CreateRecommenderConfiguration> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(CreateRecommenderConfiguration::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateRecommenderConfiguration::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRecommenderConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RECOMMENDATION_PROVIDER_ID_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationProviderIdType")
            .getter(getter(CreateRecommenderConfiguration::recommendationProviderIdType))
            .setter(setter(Builder::recommendationProviderIdType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderIdType")
                    .build()).build();

    private static final SdkField<String> RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationProviderRoleArn")
            .getter(getter(CreateRecommenderConfiguration::recommendationProviderRoleArn))
            .setter(setter(Builder::recommendationProviderRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderRoleArn")
                    .build()).build();

    private static final SdkField<String> RECOMMENDATION_PROVIDER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationProviderUri").getter(getter(CreateRecommenderConfiguration::recommendationProviderUri))
            .setter(setter(Builder::recommendationProviderUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderUri").build())
            .build();

    private static final SdkField<String> RECOMMENDATION_TRANSFORMER_URI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationTransformerUri")
            .getter(getter(CreateRecommenderConfiguration::recommendationTransformerUri))
            .setter(setter(Builder::recommendationTransformerUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationTransformerUri")
                    .build()).build();

    private static final SdkField<String> RECOMMENDATIONS_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationsDisplayName")
            .getter(getter(CreateRecommenderConfiguration::recommendationsDisplayName))
            .setter(setter(Builder::recommendationsDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsDisplayName").build())
            .build();

    private static final SdkField<Integer> RECOMMENDATIONS_PER_MESSAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("RecommendationsPerMessage")
            .getter(getter(CreateRecommenderConfiguration::recommendationsPerMessage))
            .setter(setter(Builder::recommendationsPerMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsPerMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, RECOMMENDATION_PROVIDER_ID_TYPE_FIELD, RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD,
            RECOMMENDATION_PROVIDER_URI_FIELD, RECOMMENDATION_TRANSFORMER_URI_FIELD, RECOMMENDATIONS_DISPLAY_NAME_FIELD,
            RECOMMENDATIONS_PER_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> attributes;

    private final String description;

    private final String name;

    private final String recommendationProviderIdType;

    private final String recommendationProviderRoleArn;

    private final String recommendationProviderUri;

    private final String recommendationTransformerUri;

    private final String recommendationsDisplayName;

    private final Integer recommendationsPerMessage;

    private CreateRecommenderConfiguration(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.description = builder.description;
        this.name = builder.name;
        this.recommendationProviderIdType = builder.recommendationProviderIdType;
        this.recommendationProviderRoleArn = builder.recommendationProviderRoleArn;
        this.recommendationProviderUri = builder.recommendationProviderUri;
        this.recommendationTransformerUri = builder.recommendationTransformerUri;
        this.recommendationsDisplayName = builder.recommendationsDisplayName;
        this.recommendationsPerMessage = builder.recommendationsPerMessage;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the
     * RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's
     * retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute
     * can be used as a message variable in a message template.
     * </p>
     * <p>
     * In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute.
     * The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.
     * The following restrictions apply to these names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can
     * be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.
     * </p>
     * </li>
     * <li>
     * <p>
     * An attribute display name must start with a letter or number and it can contain up to 25 characters. The
     * characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
     * </p>
     * </li>
     * </ul>
     * <p>
     * This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to
     * process recommendation data. Otherwise, don't include this object in your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for
     *         the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item
     *         that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing.
     *         Each attribute can be used as a message variable in a message template.</p>
     *         <p>
     *         In the map, the key is the name of a custom attribute and the value is a custom display name for that
     *         attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon
     *         Pinpoint console. The following restrictions apply to these names:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An attribute name must start with a letter or number and it can contain up to 50 characters. The
     *         characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive
     *         and must be unique.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An attribute display name must start with a letter or number and it can contain up to 25 characters. The
     *         characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This object is required if the configuration invokes an AWS Lambda function
     *         (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in
     *         your request.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * A custom description of the configuration for the recommender model. The description can contain up to 128
     * characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.
     * </p>
     * 
     * @return A custom description of the configuration for the recommender model. The description can contain up to
     *         128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A custom name of the configuration for the recommender model. The name must start with a letter or number and it
     * can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens
     * (-).
     * </p>
     * 
     * @return A custom name of the configuration for the recommender model. The name must start with a letter or number
     *         and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_),
     *         or hyphens (-).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the
     * model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint
     * application. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data
     * is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The
     * data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in
     * Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to
     * the user's endpoint.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value
     *         enables the model to use attribute and event data that’s specific to a particular endpoint or user in an
     *         Amazon Pinpoint application. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint.
     *         The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon
     *         Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an
     *         endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID.
     *         Otherwise, messages won’t be sent to the user's endpoint.
     *         </p>
     *         </li>
     */
    public final String recommendationProviderIdType() {
        return recommendationProviderIdType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
     * Pinpoint to retrieve recommendation data from the recommender model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
     *         Amazon Pinpoint to retrieve recommendation data from the recommender model.
     */
    public final String recommendationProviderRoleArn() {
        return recommendationProviderRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must
     * match the ARN of an Amazon Personalize campaign.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value
     *         must match the ARN of an Amazon Personalize campaign.
     */
    public final String recommendationProviderUri() {
        return recommendationProviderUri;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of
     * recommendation data that's retrieved from the recommender model.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of
     *         recommendation data that's retrieved from the recommender model.
     */
    public final String recommendationTransformerUri() {
        return recommendationTransformerUri;
    }

    /**
     * <p>
     * A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores
     * recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType
     * property. This value is required if the configuration doesn't invoke an AWS Lambda function
     * (RecommendationTransformerUri) to perform additional processing of recommendation data.
     * </p>
     * <p>
     * This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The name
     * can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
     * These restrictions don't apply to attribute values.
     * </p>
     * 
     * @return A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily
     *         stores recommended items for each endpoint or user, depending on the value for the
     *         RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS
     *         Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation
     *         data.</p>
     *         <p>
     *         This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.
     *         The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores
     *         (_), or hyphens (-). These restrictions don't apply to attribute values.
     */
    public final String recommendationsDisplayName() {
        return recommendationsDisplayName;
    }

    /**
     * <p>
     * The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for
     * the RecommendationProviderIdType property. This number determines how many recommended items are available for
     * use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.
     * </p>
     * <p>
     * To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda
     * function (RecommendationTransformerUri) to perform additional processing of recommendation data.
     * </p>
     * 
     * @return The number of recommended items to retrieve from the model for each endpoint or user, depending on the
     *         value for the RecommendationProviderIdType property. This number determines how many recommended items
     *         are available for use in message variables. The minimum value is 1. The maximum value is 5. The default
     *         value is 5.</p>
     *         <p>
     *         To use multiple recommended items and custom attributes with message variables, you have to use an AWS
     *         Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
     */
    public final Integer recommendationsPerMessage() {
        return recommendationsPerMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationProviderIdType());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationProviderRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationProviderUri());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTransformerUri());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationsDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationsPerMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommenderConfiguration)) {
            return false;
        }
        CreateRecommenderConfiguration other = (CreateRecommenderConfiguration) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(recommendationProviderIdType(), other.recommendationProviderIdType())
                && Objects.equals(recommendationProviderRoleArn(), other.recommendationProviderRoleArn())
                && Objects.equals(recommendationProviderUri(), other.recommendationProviderUri())
                && Objects.equals(recommendationTransformerUri(), other.recommendationTransformerUri())
                && Objects.equals(recommendationsDisplayName(), other.recommendationsDisplayName())
                && Objects.equals(recommendationsPerMessage(), other.recommendationsPerMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRecommenderConfiguration").add("Attributes", hasAttributes() ? attributes() : null)
                .add("Description", description()).add("Name", name())
                .add("RecommendationProviderIdType", recommendationProviderIdType())
                .add("RecommendationProviderRoleArn", recommendationProviderRoleArn())
                .add("RecommendationProviderUri", recommendationProviderUri())
                .add("RecommendationTransformerUri", recommendationTransformerUri())
                .add("RecommendationsDisplayName", recommendationsDisplayName())
                .add("RecommendationsPerMessage", recommendationsPerMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RecommendationProviderIdType":
            return Optional.ofNullable(clazz.cast(recommendationProviderIdType()));
        case "RecommendationProviderRoleArn":
            return Optional.ofNullable(clazz.cast(recommendationProviderRoleArn()));
        case "RecommendationProviderUri":
            return Optional.ofNullable(clazz.cast(recommendationProviderUri()));
        case "RecommendationTransformerUri":
            return Optional.ofNullable(clazz.cast(recommendationTransformerUri()));
        case "RecommendationsDisplayName":
            return Optional.ofNullable(clazz.cast(recommendationsDisplayName()));
        case "RecommendationsPerMessage":
            return Optional.ofNullable(clazz.cast(recommendationsPerMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommenderConfiguration, T> g) {
        return obj -> g.apply((CreateRecommenderConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateRecommenderConfiguration> {
        /**
         * <p>
         * A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the
         * RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's
         * retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each
         * attribute can be used as a message variable in a message template.
         * </p>
         * <p>
         * In the map, the key is the name of a custom attribute and the value is a custom display name for that
         * attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon
         * Pinpoint console. The following restrictions apply to these names:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An attribute name must start with a letter or number and it can contain up to 50 characters. The characters
         * can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be
         * unique.
         * </p>
         * </li>
         * <li>
         * <p>
         * An attribute display name must start with a letter or number and it can contain up to 25 characters. The
         * characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
         * </p>
         * </li>
         * </ul>
         * <p>
         * This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to
         * process recommendation data. Otherwise, don't include this object in your request.
         * </p>
         * 
         * @param attributes
         *        A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value
         *        for the RecommendationProviderIdType property. Each of these attributes temporarily stores a
         *        recommended item that's retrieved from the recommender model and sent to an AWS Lambda function for
         *        additional processing. Each attribute can be used as a message variable in a message template.</p>
         *        <p>
         *        In the map, the key is the name of a custom attribute and the value is a custom display name for that
         *        attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the
         *        Amazon Pinpoint console. The following restrictions apply to these names:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An attribute name must start with a letter or number and it can contain up to 50 characters. The
         *        characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case
         *        sensitive and must be unique.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An attribute display name must start with a letter or number and it can contain up to 25 characters.
         *        The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This object is required if the configuration invokes an AWS Lambda function
         *        (RecommendationTransformerUri) to process recommendation data. Otherwise, don't include this object in
         *        your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * A custom description of the configuration for the recommender model. The description can contain up to 128
         * characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.
         * </p>
         * 
         * @param description
         *        A custom description of the configuration for the recommender model. The description can contain up to
         *        128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A custom name of the configuration for the recommender model. The name must start with a letter or number and
         * it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or
         * hyphens (-).
         * </p>
         * 
         * @param name
         *        A custom name of the configuration for the recommender model. The name must start with a letter or
         *        number and it can contain up to 128 characters. The characters can be letters, numbers, spaces,
         *        underscores (_), or hyphens (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables
         * the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon
         * Pinpoint application. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The
         * data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint.
         * The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint
         * definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages
         * won’t be sent to the user's endpoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param recommendationProviderIdType
         *        The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value
         *        enables the model to use attribute and event data that’s specific to a particular endpoint or user in
         *        an Amazon Pinpoint application. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint.
         *        The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon
         *        Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an
         *        endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID.
         *        Otherwise, messages won’t be sent to the user's endpoint.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationProviderIdType(String recommendationProviderIdType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
         * Pinpoint to retrieve recommendation data from the recommender model.
         * </p>
         * 
         * @param recommendationProviderRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
         *        Amazon Pinpoint to retrieve recommendation data from the recommender model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationProviderRoleArn(String recommendationProviderRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must
         * match the ARN of an Amazon Personalize campaign.
         * </p>
         * 
         * @param recommendationProviderUri
         *        The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This
         *        value must match the ARN of an Amazon Personalize campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationProviderUri(String recommendationProviderUri);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of
         * recommendation data that's retrieved from the recommender model.
         * </p>
         * 
         * @param recommendationTransformerUri
         *        The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing
         *        of recommendation data that's retrieved from the recommender model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTransformerUri(String recommendationTransformerUri);

        /**
         * <p>
         * A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily
         * stores recommended items for each endpoint or user, depending on the value for the
         * RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an AWS
         * Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.
         * </p>
         * <p>
         * This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The
         * name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or
         * hyphens (-). These restrictions don't apply to attribute values.
         * </p>
         * 
         * @param recommendationsDisplayName
         *        A custom display name for the standard endpoint or user attribute (RecommendationItems) that
         *        temporarily stores recommended items for each endpoint or user, depending on the value for the
         *        RecommendationProviderIdType property. This value is required if the configuration doesn't invoke an
         *        AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation
         *        data.</p>
         *        <p>
         *        This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint
         *        console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces,
         *        underscores (_), or hyphens (-). These restrictions don't apply to attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationsDisplayName(String recommendationsDisplayName);

        /**
         * <p>
         * The number of recommended items to retrieve from the model for each endpoint or user, depending on the value
         * for the RecommendationProviderIdType property. This number determines how many recommended items are
         * available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is
         * 5.
         * </p>
         * <p>
         * To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda
         * function (RecommendationTransformerUri) to perform additional processing of recommendation data.
         * </p>
         * 
         * @param recommendationsPerMessage
         *        The number of recommended items to retrieve from the model for each endpoint or user, depending on the
         *        value for the RecommendationProviderIdType property. This number determines how many recommended items
         *        are available for use in message variables. The minimum value is 1. The maximum value is 5. The
         *        default value is 5.</p>
         *        <p>
         *        To use multiple recommended items and custom attributes with message variables, you have to use an AWS
         *        Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationsPerMessage(Integer recommendationsPerMessage);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private String name;

        private String recommendationProviderIdType;

        private String recommendationProviderRoleArn;

        private String recommendationProviderUri;

        private String recommendationTransformerUri;

        private String recommendationsDisplayName;

        private Integer recommendationsPerMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommenderConfiguration model) {
            attributes(model.attributes);
            description(model.description);
            name(model.name);
            recommendationProviderIdType(model.recommendationProviderIdType);
            recommendationProviderRoleArn(model.recommendationProviderRoleArn);
            recommendationProviderUri(model.recommendationProviderUri);
            recommendationTransformerUri(model.recommendationTransformerUri);
            recommendationsDisplayName(model.recommendationsDisplayName);
            recommendationsPerMessage(model.recommendationsPerMessage);
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRecommendationProviderIdType() {
            return recommendationProviderIdType;
        }

        @Override
        public final Builder recommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
            return this;
        }

        public final void setRecommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
        }

        public final String getRecommendationProviderRoleArn() {
            return recommendationProviderRoleArn;
        }

        @Override
        public final Builder recommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
            return this;
        }

        public final void setRecommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
        }

        public final String getRecommendationProviderUri() {
            return recommendationProviderUri;
        }

        @Override
        public final Builder recommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
            return this;
        }

        public final void setRecommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
        }

        public final String getRecommendationTransformerUri() {
            return recommendationTransformerUri;
        }

        @Override
        public final Builder recommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
            return this;
        }

        public final void setRecommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
        }

        public final String getRecommendationsDisplayName() {
            return recommendationsDisplayName;
        }

        @Override
        public final Builder recommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
            return this;
        }

        public final void setRecommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
        }

        public final Integer getRecommendationsPerMessage() {
            return recommendationsPerMessage;
        }

        @Override
        public final Builder recommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
            return this;
        }

        public final void setRecommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
        }

        @Override
        public CreateRecommenderConfiguration build() {
            return new CreateRecommenderConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
